/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;

public abstract class JdbcFlowRepositoryService {
    public static Table<Record> lastRevision(io.kestra.jdbc.AbstractJdbcRepository<? extends FlowInterface> jdbcRepository, boolean asterisk) {
        ArrayList<Object> fields = new ArrayList<Object>();
        if (asterisk) {
            fields.add(jdbcRepository.getTable().asterisk());
        } else {
            fields.add(AbstractJdbcRepository.field("key", String.class));
            fields.add(AbstractJdbcRepository.field("revision", Integer.class));
        }
        fields.add(DSL.rowNumber().over().partitionBy(List.of(AbstractJdbcRepository.field("tenant_id"), AbstractJdbcRepository.field("namespace"), AbstractJdbcRepository.field("id"))).orderBy(new OrderField[]{AbstractJdbcRepository.field("revision").desc()}).as("revision_rows"));
        return (Table)jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            return context.select(new SelectFieldOrAsterisk[]{DSL.asterisk()}).from((TableLike)context.select((Collection)fields).from(jdbcRepository.getTable()).asTable("rev_ord")).where(AbstractJdbcRepository.field("revision_rows").eq((Object)1)).asTable("rev");
        });
    }

    public static Condition findCondition(io.kestra.jdbc.AbstractJdbcRepository<Flow> jdbcRepository, String query, Map<String, String> labels) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        if (query != null) {
            conditions.add(jdbcRepository.fullTextCondition(List.of("fulltext"), query));
        }
        if (labels != null) {
            labels.forEach((key, value) -> {
                Field field = DSL.field((String)("JQ_STRING(\"value\", '.labels." + key + "')"), String.class);
                if (value == null) {
                    conditions.add(field.isNotNull());
                } else {
                    conditions.add(field.eq(value));
                }
            });
        }
        return conditions.size() == 0 ? DSL.trueCondition() : DSL.and(conditions);
    }

    public static Condition findSourceCodeCondition(io.kestra.jdbc.AbstractJdbcRepository<Flow> jdbcRepository, String query) {
        return jdbcRepository.fullTextCondition(List.of("source_code"), query);
    }
}

