/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.runner;

import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.repositories.TriggerRepositoryInterface;
import io.kestra.core.runners.ScheduleContextInterface;
import io.kestra.core.runners.SchedulerTriggerStateInterface;
import io.kestra.core.services.FlowListenersInterface;
import io.kestra.core.services.FlowService;
import io.kestra.core.utils.ListUtils;
import io.kestra.jdbc.JooqDSLContextWrapper;
import io.kestra.jdbc.repository.AbstractJdbcTriggerRepository;
import io.kestra.jdbc.runner.JdbcRunnerEnabled;
import io.kestra.jdbc.runner.JdbcSchedulerContext;
import io.kestra.scheduler.AbstractScheduler;
import io.kestra.scheduler.SchedulerExecutionState;
import io.kestra.scheduler.SchedulerExecutionStateInterface;
import io.micronaut.context.ApplicationContext;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdbcRunnerEnabled
@Singleton
public class JdbcScheduler
extends AbstractScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcScheduler.class);
    private final TriggerRepositoryInterface triggerRepository;
    private final JooqDSLContextWrapper dslContextWrapper;

    @Inject
    public JdbcScheduler(ApplicationContext applicationContext, FlowListenersInterface flowListeners) {
        super(applicationContext, flowListeners);
        this.triggerRepository = (TriggerRepositoryInterface)applicationContext.getBean(AbstractJdbcTriggerRepository.class);
        this.triggerState = (SchedulerTriggerStateInterface)applicationContext.getBean(SchedulerTriggerStateInterface.class);
        this.executionState = (SchedulerExecutionStateInterface)applicationContext.getBean(SchedulerExecutionState.class);
        this.dslContextWrapper = (JooqDSLContextWrapper)applicationContext.getBean(JooqDSLContextWrapper.class);
    }

    public void run() {
        super.run();
        this.flowListeners.listen((flow, previous) -> {
            if (flow.isDeleted()) {
                ListUtils.emptyOnNull((List)flow.getTriggers()).forEach(abstractTrigger -> this.triggerRepository.delete(Trigger.of((FlowInterface)flow, (AbstractTrigger)abstractTrigger)));
            } else if (previous != null) {
                FlowService.findRemovedTrigger((Flow)flow, (Flow)previous).forEach(abstractTrigger -> this.triggerRepository.delete(Trigger.of((FlowInterface)flow, (AbstractTrigger)abstractTrigger)));
            }
        });
    }

    public void handleNext(List<FlowWithSource> flows, ZonedDateTime now, BiConsumer<List<Trigger>, ScheduleContextInterface> consumer) {
        JdbcSchedulerContext schedulerContext = new JdbcSchedulerContext(this.dslContextWrapper);
        schedulerContext.doInTransaction(scheduleContextInterface -> {
            List triggers = this.triggerState.findByNextExecutionDateReadyForAllTenants(now, scheduleContextInterface);
            consumer.accept(triggers, (ScheduleContextInterface)scheduleContextInterface);
        });
    }
}

