/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import io.kestra.core.events.CrudEvent;
import io.kestra.core.events.CrudEventType;
import io.kestra.core.exceptions.DeserializationException;
import io.kestra.core.exceptions.FlowProcessingException;
import io.kestra.core.models.QueryFilter;
import io.kestra.core.models.SearchResult;
import io.kestra.core.models.dashboards.ColumnDescriptor;
import io.kestra.core.models.dashboards.DataFilter;
import io.kestra.core.models.dashboards.DataFilterKPI;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowForExecution;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.FlowWithException;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.flows.GenericFlow;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.models.validations.ManualConstraintViolation;
import io.kestra.core.models.validations.ModelValidator;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.services.FlowService;
import io.kestra.core.services.PluginDefaultService;
import io.kestra.core.utils.DateUtils;
import io.kestra.core.utils.Either;
import io.kestra.core.utils.ListUtils;
import io.kestra.core.utils.NamespaceUtils;
import io.kestra.core.utils.Rethrow;
import io.kestra.jdbc.JdbcMapper;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.kestra.jdbc.repository.JdbcFlowRepositoryService;
import io.kestra.jdbc.services.JdbcFilterService;
import io.kestra.plugin.core.dashboard.data.IFlows;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.data.model.Pageable;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.annotation.Nullable;
import jakarta.validation.ConstraintViolationException;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record3;
import org.jooq.Record4;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.SelectSeekStep1;
import org.jooq.SelectSeekStepN;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcFlowRepository
extends AbstractJdbcRepository
implements FlowRepositoryInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractJdbcFlowRepository.class);
    protected static final ObjectMapper MAPPER = JdbcMapper.of();
    private static final Field<String> NAMESPACE_FIELD = AbstractJdbcFlowRepository.field("namespace", String.class);
    public static final Field<String> VALUE_FIELD = AbstractJdbcFlowRepository.field("value", String.class);
    public static final Field<String> TENANT_FIELD = AbstractJdbcFlowRepository.field("tenant_id", String.class);
    public static final Field<String> SOURCE_FIELD = AbstractJdbcFlowRepository.field("source_code", String.class);
    private final QueueInterface<FlowInterface> flowQueue;
    private final QueueInterface<Trigger> triggerQueue;
    private final ApplicationEventPublisher<CrudEvent<FlowInterface>> eventPublisher;
    private final ModelValidator modelValidator;
    private final NamespaceUtils namespaceUtils;
    private final PluginDefaultService pluginDefaultService;
    private final JdbcFilterService filterService;
    protected io.kestra.jdbc.AbstractJdbcRepository<FlowInterface> jdbcRepository;
    private final Map<IFlows.Fields, String> fieldsMapping = Map.of(IFlows.Fields.ID, "key", IFlows.Fields.NAMESPACE, "namespace", IFlows.Fields.REVISION, "revision");

    public AbstractJdbcFlowRepository(io.kestra.jdbc.AbstractJdbcRepository<FlowInterface> jdbcRepository, ApplicationContext applicationContext, JdbcFilterService filterService) {
        this.jdbcRepository = jdbcRepository;
        this.modelValidator = (ModelValidator)applicationContext.getBean(ModelValidator.class);
        this.eventPublisher = (ApplicationEventPublisher)applicationContext.getBean(ApplicationEventPublisher.class);
        this.pluginDefaultService = (PluginDefaultService)applicationContext.getBean(PluginDefaultService.class);
        this.triggerQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"triggerQueue"));
        this.flowQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"flowQueue"));
        this.namespaceUtils = (NamespaceUtils)applicationContext.getBean(NamespaceUtils.class);
        this.jdbcRepository.setDeserializer(record -> {
            String source = (String)record.get("value", String.class);
            String namespace = (String)record.get("namespace", String.class);
            String tenantId = (String)record.get("tenant_id", String.class);
            try {
                Map map = (Map)MAPPER.readValue(source, (TypeReference)new TypeReference<Map<String, Object>>(this){});
                map = this.pluginDefaultService.injectVersionDefaults(tenantId, namespace, map);
                Flow deserialize = (Flow)MAPPER.convertValue((Object)map, Flow.class);
                deserialize.allTasksWithChilds();
                return deserialize;
            }
            catch (DeserializationException | FlowProcessingException | IOException | IllegalArgumentException e) {
                try {
                    JsonNode jsonNode = JdbcMapper.of().readTree(source);
                    return (FlowInterface)FlowWithException.from((JsonNode)jsonNode, (Exception)e).orElseThrow(() -> AbstractJdbcFlowRepository.lambda$new$0((Exception)e, source));
                }
                catch (JsonProcessingException ex) {
                    throw new DeserializationException((Exception)((Object)ex), source);
                }
            }
        });
        this.filterService = filterService;
    }

    public Set<IFlows.Fields> dateFields() {
        return Set.of();
    }

    public IFlows.Fields dateFilterField() {
        return null;
    }

    public Optional<Flow> findById(String tenantId, String namespace, String id, Optional<Integer> revision, Boolean allowDeleted) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            Select from = (Select)revision.map(integer -> context.select(VALUE_FIELD, NAMESPACE_FIELD, TENANT_FIELD).from(this.jdbcRepository.getTable()).where(this.revisionDefaultFilter(tenantId)).and(NAMESPACE_FIELD.eq((Object)namespace)).and(AbstractJdbcFlowRepository.field("id", String.class).eq((Object)id)).and(AbstractJdbcFlowRepository.field("revision", Integer.class).eq(integer))).orElseGet(() -> context.select(VALUE_FIELD, NAMESPACE_FIELD, TENANT_FIELD).from(this.fromLastRevision(true)).where(allowDeleted != false ? this.revisionDefaultFilter(tenantId) : this.defaultFilter(tenantId)).and(NAMESPACE_FIELD.eq((Object)namespace)).and(AbstractJdbcFlowRepository.field("id", String.class).eq((Object)id)));
            return this.jdbcRepository.fetchOne(from).map(it -> (Flow)it);
        });
    }

    public Optional<Flow> findByIdWithoutAcl(String tenantId, String namespace, String id, Optional<Integer> revision) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            Select from = (Select)revision.map(integer -> context.select(VALUE_FIELD, NAMESPACE_FIELD, TENANT_FIELD).from(this.jdbcRepository.getTable()).where(this.noAclDefaultFilter(tenantId)).and(NAMESPACE_FIELD.eq((Object)namespace)).and(AbstractJdbcFlowRepository.field("id", String.class).eq((Object)id)).and(AbstractJdbcFlowRepository.field("revision", Integer.class).eq(integer))).orElseGet(() -> context.select(VALUE_FIELD, NAMESPACE_FIELD, TENANT_FIELD).from(this.fromLastRevision(true)).where(this.noAclDefaultFilter(tenantId)).and(NAMESPACE_FIELD.eq((Object)namespace)).and(AbstractJdbcFlowRepository.field("id", String.class).eq((Object)id)));
            return this.jdbcRepository.fetchOne(from).map(it -> (Flow)it);
        });
    }

    protected Table<Record> fromLastRevision(boolean asterisk) {
        return JdbcFlowRepositoryService.lastRevision(this.jdbcRepository, asterisk);
    }

    protected Condition revisionDefaultFilter(String tenantId) {
        return this.buildTenantCondition(tenantId);
    }

    protected Condition noAclDefaultFilter(String tenantId) {
        return this.buildTenantCondition(tenantId);
    }

    protected Condition defaultExecutionFilter(String tenantId) {
        return this.buildTenantCondition(tenantId);
    }

    public Optional<FlowWithSource> findByIdWithSource(String tenantId, String namespace, String id, Optional<Integer> revision, Boolean allowDeleted) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            Select from = (Select)revision.map(integer -> context.select(SOURCE_FIELD, VALUE_FIELD, NAMESPACE_FIELD, TENANT_FIELD).from(this.jdbcRepository.getTable()).where(this.revisionDefaultFilter(tenantId)).and(NAMESPACE_FIELD.eq((Object)namespace)).and(AbstractJdbcFlowRepository.field("id", String.class).eq((Object)id)).and(AbstractJdbcFlowRepository.field("revision", Integer.class).eq(integer))).orElseGet(() -> context.select(SOURCE_FIELD, VALUE_FIELD, NAMESPACE_FIELD, TENANT_FIELD).from(this.fromLastRevision(true)).where(allowDeleted != false ? this.revisionDefaultFilter(tenantId) : this.defaultFilter(tenantId)).and(NAMESPACE_FIELD.eq((Object)namespace)).and(AbstractJdbcFlowRepository.field("id", String.class).eq((Object)id)));
            Record4 fetched = (Record4)from.fetchAny();
            if (fetched == null) {
                return Optional.empty();
            }
            Flow flow = (Flow)this.jdbcRepository.map(fetched);
            String source = (String)fetched.get(SOURCE_FIELD);
            if (flow instanceof FlowWithException) {
                FlowWithException fwe = (FlowWithException)flow;
                return Optional.of(((FlowWithException.FlowWithExceptionBuilder)fwe.toBuilder().source(source)).build());
            }
            return Optional.of(FlowWithSource.of((Flow)flow, (String)source));
        });
    }

    public Optional<FlowWithSource> findByIdWithSourceWithoutAcl(String tenantId, String namespace, String id, Optional<Integer> revision) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            Select from = (Select)revision.map(integer -> context.select(SOURCE_FIELD, VALUE_FIELD, NAMESPACE_FIELD, TENANT_FIELD).from(this.jdbcRepository.getTable()).where(this.noAclDefaultFilter(tenantId)).and(NAMESPACE_FIELD.eq((Object)namespace)).and(AbstractJdbcFlowRepository.field("id", String.class).eq((Object)id)).and(AbstractJdbcFlowRepository.field("revision", Integer.class).eq(integer))).orElseGet(() -> context.select(SOURCE_FIELD, VALUE_FIELD, NAMESPACE_FIELD, TENANT_FIELD).from(this.fromLastRevision(true)).where(this.noAclDefaultFilter(tenantId)).and(NAMESPACE_FIELD.eq((Object)namespace)).and(AbstractJdbcFlowRepository.field("id", String.class).eq((Object)id)));
            Record4 fetched = (Record4)from.fetchAny();
            if (fetched == null) {
                return Optional.empty();
            }
            Flow flow = (Flow)this.jdbcRepository.map(fetched);
            String source = (String)fetched.get(SOURCE_FIELD);
            if (flow instanceof FlowWithException) {
                FlowWithException fwe = (FlowWithException)flow;
                return Optional.of(((FlowWithException.FlowWithExceptionBuilder)fwe.toBuilder().source(source)).build());
            }
            return Optional.of(FlowWithSource.of((Flow)flow, (String)source));
        });
    }

    public List<FlowWithSource> findRevisions(String tenantId, String namespace, String id) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectSeekStep1 select = DSL.using((Configuration)configuration).select(SOURCE_FIELD, VALUE_FIELD, NAMESPACE_FIELD, TENANT_FIELD).from(this.jdbcRepository.getTable()).where(this.revisionDefaultFilter(tenantId)).and(NAMESPACE_FIELD.eq((Object)namespace)).and(AbstractJdbcFlowRepository.field("id", String.class).eq((Object)id)).orderBy((OrderField)AbstractJdbcFlowRepository.field("revision", Integer.class).asc());
            return select.fetch().map(record -> FlowWithSource.of((Flow)((Flow)this.jdbcRepository.map(record)), (String)((String)record.get(SOURCE_FIELD))));
        });
    }

    public int count(String tenantId) {
        return (Integer)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> (Integer)DSL.using((Configuration)configuration).selectCount().from(this.fromLastRevision(true)).where(this.defaultFilter(tenantId)).fetchOne(0, Integer.TYPE));
    }

    public List<Flow> findAll(String tenantId) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcFlowRepository.field("value"), AbstractJdbcFlowRepository.field("namespace"), AbstractJdbcFlowRepository.field("tenant_id")).from(this.fromLastRevision(true)).where(this.defaultFilter(tenantId));
            return this.jdbcRepository.fetch(select);
        });
    }

    public List<Flow> findAllForAllTenants() {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcFlowRepository.field("value"), AbstractJdbcFlowRepository.field("namespace"), AbstractJdbcFlowRepository.field("tenant_id")).from(this.fromLastRevision(true)).where(this.defaultFilter());
            ArrayList flows = new ArrayList();
            select.fetch().forEach(item -> {
                try {
                    Flow flow = (Flow)this.jdbcRepository.map(item);
                    flows.add(flow);
                }
                catch (Exception e) {
                    log.error("Unable to load the following flow:\n{}", item.get("value", String.class), (Object)e);
                }
            });
            return flows;
        });
    }

    public List<FlowWithSource> findAllWithSource(String tenantId) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcFlowRepository.field("value"), AbstractJdbcFlowRepository.field("source_code"), AbstractJdbcFlowRepository.field("namespace"), AbstractJdbcFlowRepository.field("tenant_id")).from(this.fromLastRevision(true)).where(this.defaultFilter(tenantId));
            return select.fetch().map(record -> FlowWithSource.of((Flow)((Flow)this.jdbcRepository.map(record)), (String)((String)record.get(SOURCE_FIELD))));
        });
    }

    public List<FlowWithSource> findAllWithSourceWithNoAcl(String tenantId) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcFlowRepository.field("value"), AbstractJdbcFlowRepository.field("source_code"), AbstractJdbcFlowRepository.field("namespace"), AbstractJdbcFlowRepository.field("tenant_id")).from(this.fromLastRevision(true)).where(this.noAclDefaultFilter(tenantId));
            return select.fetch().map(record -> FlowWithSource.of((Flow)((Flow)this.jdbcRepository.map(record)), (String)((String)record.get(SOURCE_FIELD))));
        });
    }

    public List<FlowWithSource> findAllWithSourceForAllTenants() {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcFlowRepository.field("value"), AbstractJdbcFlowRepository.field("source_code"), AbstractJdbcFlowRepository.field("namespace"), AbstractJdbcFlowRepository.field("tenant_id")).from(this.fromLastRevision(true)).where(this.defaultFilter());
            return select.fetch().stream().map(record -> {
                try {
                    return FlowWithSource.of((Flow)((Flow)this.jdbcRepository.map(record)), (String)((String)record.get("source_code", String.class)));
                }
                catch (Exception e) {
                    log.error("Unable to load the following flow:\n{}", record.get("value", String.class), (Object)e);
                    return null;
                }
            }).filter(Objects::nonNull).toList();
        });
    }

    public List<Flow> findByNamespace(String tenantId, String namespace) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = this.findByNamespaceSelect(namespace).and(this.defaultFilter(tenantId));
            return this.jdbcRepository.fetch(select);
        });
    }

    public List<Flow> findByNamespacePrefix(String tenantId, String namespacePrefix) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = this.findByNamespacePrefixSelect(namespacePrefix).and(this.defaultFilter(tenantId));
            return this.jdbcRepository.fetch(select);
        });
    }

    public List<FlowForExecution> findByNamespaceExecutable(String tenantId, String namespace) {
        return ((List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = this.findByNamespaceSelect(namespace).and(this.defaultExecutionFilter(tenantId));
            return this.jdbcRepository.fetch(select);
        })).stream().map(it -> (Flow)it).map(FlowForExecution::of).toList();
    }

    private SelectConditionStep<Record3<Object, Object, Object>> findByNamespaceSelect(String namespace) {
        return (SelectConditionStep)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> DSL.using((Configuration)configuration).select(AbstractJdbcFlowRepository.field("value"), AbstractJdbcFlowRepository.field("namespace"), AbstractJdbcFlowRepository.field("tenant_id")).from(this.fromLastRevision(true)).where(NAMESPACE_FIELD.eq((Object)namespace)));
    }

    private SelectConditionStep<Record3<Object, Object, Object>> findByNamespacePrefixSelect(String namespacePrefix) {
        return (SelectConditionStep)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> DSL.using((Configuration)configuration).select(AbstractJdbcFlowRepository.field("value"), AbstractJdbcFlowRepository.field("namespace"), AbstractJdbcFlowRepository.field("tenant_id")).from(this.fromLastRevision(true)).where(DSL.or((Condition)NAMESPACE_FIELD.eq((Object)namespacePrefix), (Condition)NAMESPACE_FIELD.likeIgnoreCase(namespacePrefix + ".%"))));
    }

    public List<FlowWithSource> findByNamespaceWithSource(String tenantId, String namespace) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(SOURCE_FIELD, VALUE_FIELD, NAMESPACE_FIELD, TENANT_FIELD).from(this.fromLastRevision(true)).where(NAMESPACE_FIELD.eq((Object)namespace)).and(this.defaultFilter(tenantId));
            return select.fetch().map(record -> FlowWithSource.of((Flow)((Flow)this.jdbcRepository.map(record)), (String)((String)record.get(SOURCE_FIELD))));
        });
    }

    public List<FlowWithSource> findByNamespacePrefixWithSource(String tenantId, String namespacePrefix) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(SOURCE_FIELD, VALUE_FIELD, NAMESPACE_FIELD, TENANT_FIELD).from(this.fromLastRevision(true)).where(DSL.or((Condition)NAMESPACE_FIELD.eq((Object)namespacePrefix), (Condition)NAMESPACE_FIELD.likeIgnoreCase(namespacePrefix + ".%"))).and(this.defaultFilter(tenantId));
            return select.fetch().map(record -> FlowWithSource.of((Flow)((Flow)this.jdbcRepository.map(record)), (String)((String)record.get(SOURCE_FIELD))));
        });
    }

    private <R extends Record, E> SelectConditionStep<R> fullTextSelect(String tenantId, DSLContext context, List<Field<Object>> field) {
        ArrayList<Field<Object>> fields = new ArrayList<Field<Object>>();
        fields.add(AbstractJdbcFlowRepository.field("value"));
        fields.add(AbstractJdbcFlowRepository.field("tenant_id"));
        fields.add(AbstractJdbcFlowRepository.field("namespace"));
        if (field != null) {
            fields.addAll(field);
        }
        return context.select(fields).from(this.fromLastRevision(false)).join((TableLike)this.jdbcRepository.getTable().as("ft")).on(DSL.field((Name)DSL.quotedName((String[])new String[]{"ft", "key"})).eq(DSL.field((SelectField)DSL.field((Name)DSL.quotedName((String[])new String[]{"rev", "key"})))).and(DSL.field((Name)DSL.quotedName((String[])new String[]{"ft", "revision"})).eq(DSL.field((Name)DSL.quotedName((String[])new String[]{"rev", "revision"}))))).where(this.defaultFilter(tenantId));
    }

    protected abstract Condition findCondition(String var1, Map<String, String> var2);

    @Override
    protected Condition findQueryCondition(String query) {
        return this.findCondition(query, Map.of());
    }

    protected abstract Condition findCondition(Object var1, QueryFilter.Op var2);

    @Override
    protected Condition findLabelCondition(Either<Map<?, ?>, String> value, QueryFilter.Op operation) {
        return this.findCondition(value.getLeft(), operation);
    }

    public ArrayListTotal<Flow> find(Pageable pageable, @Nullable String tenantId, @Nullable List<QueryFilter> filters) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = this.getFindFlowSelect(tenantId, filters, context, null);
            return this.jdbcRepository.fetchPage(context, select, pageable);
        });
    }

    public ArrayListTotal<FlowWithSource> findWithSource(Pageable pageable, @Nullable String tenantId, @Nullable List<QueryFilter> filters) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = this.getFindFlowSelect(tenantId, filters, context, List.of(AbstractJdbcFlowRepository.field("source_code")));
            return this.jdbcRepository.fetchPage(context, select, pageable, record -> FlowWithSource.of((Flow)((Flow)this.jdbcRepository.map(record)), (String)((String)record.get("source_code", String.class))));
        });
    }

    private <R extends Record> SelectConditionStep<R> getFindFlowSelect(String tenantId, List<QueryFilter> filters, DSLContext context, List<Field<Object>> additionalFieldsToSelect) {
        SelectConditionStep select = this.fullTextSelect(tenantId, context, additionalFieldsToSelect != null ? additionalFieldsToSelect : List.of());
        select = select.and(this.filter(filters, null, QueryFilter.Resource.FLOW));
        return select;
    }

    protected abstract Condition findSourceCodeCondition(String var1);

    public ArrayListTotal<SearchResult<Flow>> findSourceCode(Pageable pageable, @Nullable String query, @Nullable String tenantId, @Nullable String namespace) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = this.fullTextSelect(tenantId, context, Collections.singletonList(AbstractJdbcFlowRepository.field("source_code")));
            if (query != null) {
                select.and(this.findSourceCodeCondition(query));
            }
            if (namespace != null) {
                select.and(DSL.or((Condition)NAMESPACE_FIELD.eq((Object)namespace), (Condition)NAMESPACE_FIELD.likeIgnoreCase(namespace + ".%")));
            }
            return this.jdbcRepository.fetchPage(context, select, pageable, record -> new SearchResult((Object)this.jdbcRepository.map(record), this.jdbcRepository.fragments(query, (String)record.getValue("source_code", String.class))));
        });
    }

    public FlowWithSource create(GenericFlow flow) throws ConstraintViolationException {
        if (this.findById(flow.getTenantId(), flow.getNamespace(), flow.getId()).isPresent()) {
            throw new ConstraintViolationException(Collections.singleton(ManualConstraintViolation.of((String)"Flow id already exists", (Object)flow, GenericFlow.class, (String)"flow.id", (Object)flow.getId())));
        }
        return this.save(flow, CrudEventType.CREATE);
    }

    public FlowWithSource update(GenericFlow flow, FlowInterface previous) throws ConstraintViolationException {
        Flow o;
        FlowWithSource flowWithDefault = this.pluginDefaultService.injectAllDefaults((FlowInterface)flow, false);
        this.modelValidator.validate((Object)flowWithDefault);
        Object previousFlow = previous instanceof Flow ? (o = (Flow)previous) : this.pluginDefaultService.injectAllDefaults(previous, false);
        Optional checkUpdate = previousFlow.validateUpdate((Flow)flowWithDefault);
        if (checkUpdate.isPresent()) {
            throw (ConstraintViolationException)checkUpdate.get();
        }
        FlowService.findRemovedTrigger((Flow)flowWithDefault, (Flow)previousFlow).forEach(Rethrow.throwConsumer(abstractTrigger -> this.triggerQueue.delete((Object)Trigger.of((FlowInterface)flowWithDefault, (AbstractTrigger)abstractTrigger))));
        return this.save(flow, CrudEventType.UPDATE);
    }

    @VisibleForTesting
    public FlowWithSource save(GenericFlow flow, CrudEventType crudEventType) throws ConstraintViolationException {
        FlowWithSource flowWithSource = this.pluginDefaultService.injectVersionDefaults((FlowInterface)flow, false);
        FlowWithSource nullOrExisting = this.findByIdWithSource(flow.getTenantId(), flow.getNamespace(), flow.getId()).orElse(null);
        if (nullOrExisting != null && nullOrExisting.isSameWithSource((FlowInterface)flow)) {
            return nullOrExisting;
        }
        List<FlowWithSource> revisions = this.findRevisions(flow.getTenantId(), flow.getNamespace(), flow.getId());
        int revision = revisions.isEmpty() ? 1 : revisions.getLast().getRevision() + 1;
        flow = ((GenericFlow.GenericFlowBuilder)flow.toBuilder().revision(Integer.valueOf(revision))).build();
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields((FlowInterface)flow);
        fields.put(AbstractJdbcFlowRepository.field("source_code"), flow.getSource());
        this.jdbcRepository.persist((FlowInterface)flow, fields);
        this.flowQueue.emit((Object)flow);
        this.eventPublisher.publishEvent((Object)new CrudEvent((Object)flow, (Object)nullOrExisting, crudEventType));
        return ((FlowWithSource.FlowWithSourceBuilder)flowWithSource.toBuilder().revision(Integer.valueOf(revision))).build();
    }

    public FlowWithSource delete(FlowInterface flow) {
        Optional existing = this.findByIdWithSource(flow.getTenantId(), flow.getNamespace(), flow.getId(), Optional.ofNullable(flow.getRevision()));
        if (existing.isEmpty()) {
            throw new IllegalStateException("Flow " + flow.getId() + " doesn't exists");
        }
        Optional last = this.findByIdWithSource(flow.getTenantId(), flow.getNamespace(), flow.getId());
        if (last.isEmpty()) {
            throw new IllegalStateException("Flow " + flow.getId() + " doesn't exists");
        }
        if (!((FlowWithSource)last.get()).getRevision().equals(((FlowWithSource)existing.get()).getRevision())) {
            throw new IllegalStateException("Trying to deleted old revision, wanted " + ((FlowWithSource)existing.get()).getRevision() + ", last revision is " + ((FlowWithSource)last.get()).getRevision());
        }
        FlowWithSource deleted = ((FlowWithSource)existing.get()).toDeleted();
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields((FlowInterface)deleted.toFlow());
        fields.put(AbstractJdbcFlowRepository.field("source_code"), deleted.getSource());
        this.jdbcRepository.persist((FlowInterface)deleted, fields);
        this.flowQueue.emit((Object)deleted);
        this.eventPublisher.publishEvent((Object)CrudEvent.delete((Object)flow));
        return deleted;
    }

    public List<String> findDistinctNamespace(String tenantId) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> DSL.using((Configuration)configuration).select(NAMESPACE_FIELD).from(this.fromLastRevision(true)).where(this.defaultFilter(tenantId)).groupBy(new GroupField[]{NAMESPACE_FIELD}).fetch().map(record -> (String)record.getValue("namespace", String.class)));
    }

    public List<String> findDistinctNamespaceExecutable(String tenantId) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> DSL.using((Configuration)configuration).select(NAMESPACE_FIELD).from(this.fromLastRevision(true)).where(this.defaultExecutionFilter(tenantId)).groupBy(new GroupField[]{NAMESPACE_FIELD}).fetch().map(record -> (String)record.getValue("namespace", String.class)));
    }

    public Integer lastRevision(String tenantId, String namespace, String id) {
        return (Integer)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> (Integer)DSL.using((Configuration)configuration).fetchValue((ResultQuery)DSL.select(AbstractJdbcFlowRepository.field("revision", Integer.class)).from(this.fromLastRevision(true)).where(this.defaultFilter(tenantId)).and(NAMESPACE_FIELD.eq((Object)namespace)).and(AbstractJdbcFlowRepository.field("id", String.class).eq((Object)id)).limit((Number)1)));
    }

    public Boolean existAnyNoAcl(String tenantId) {
        return (Boolean)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            return context.fetchExists((Select)context.selectOne().from(this.jdbcRepository.getTable()).where(this.defaultFilterWithNoACL(tenantId, false)));
        });
    }

    public ArrayListTotal<Map<String, Object>> fetchData(String tenantId, DataFilter<IFlows.Fields, ? extends ColumnDescriptor<IFlows.Fields>> descriptors, ZonedDateTime startDate, ZonedDateTime endDate, Pageable pageable) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            Map<String, ColumnDescriptor> columnsWithoutDate = descriptors.getColumns().entrySet().stream().filter(entry -> ((ColumnDescriptor)entry.getValue()).getField() == null || !this.dateFields().contains(((ColumnDescriptor)entry.getValue()).getField())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            boolean hasAgg = descriptors.getColumns().entrySet().stream().anyMatch(col -> ((ColumnDescriptor)col.getValue()).getAgg() != null);
            List<Field<Date>> dateFields = this.generateDateFields(descriptors, this.fieldsMapping, startDate, endDate, this.dateFields(), hasAgg ? null : DateUtils.GroupType.MINUTE);
            SelectConditionStep<Record> selectConditionStep = this.select(context, this.filterService, columnsWithoutDate, dateFields, this.getFieldsMapping(), this.jdbcRepository.getTable(), tenantId);
            selectConditionStep = this.where(selectConditionStep, this.filterService, descriptors.getWhere(), this.fieldsMapping);
            List<ColumnDescriptor> columnsWithoutDateWithOutAggs = columnsWithoutDate.values().stream().filter(column -> column.getAgg() == null).toList();
            SelectHavingStep<Record> selectHavingStep = this.groupBy(selectConditionStep, columnsWithoutDateWithOutAggs, dateFields, this.fieldsMapping);
            SelectSeekStepN<Record> selectSeekStep = this.orderBy(selectHavingStep, descriptors);
            return this.fetchSeekStep(selectSeekStep, pageable);
        });
    }

    public Double fetchValue(String tenantId, DataFilterKPI<IFlows.Fields, ? extends ColumnDescriptor<IFlows.Fields>> dataFilter, ZonedDateTime startDate, ZonedDateTime endDate, boolean numeratorFilter) {
        return (Double)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep selectStep;
            SelectConditionStep<Record> selectConditionStep;
            Record result;
            DSLContext context = DSL.using((Configuration)configuration);
            ColumnDescriptor columnDescriptor = dataFilter.getColumns();
            String columnKey = this.getFieldsMapping().get(columnDescriptor.getField());
            Field<?> field = this.columnToField(columnDescriptor, this.getFieldsMapping());
            if (columnDescriptor.getAgg() != null) {
                field = this.filterService.buildAggregation(field, columnDescriptor.getAgg());
            }
            ArrayList filters = new ArrayList(ListUtils.emptyOnNull((List)dataFilter.getWhere()));
            if (numeratorFilter) {
                filters.addAll(dataFilter.getNumerator());
            }
            return (result = (selectConditionStep = this.where((SelectConditionStep<Record>)(selectStep = context.select(field).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId))), this.filterService, filters, this.getFieldsMapping())).fetchOne()) != null ? (Double)result.getValue(field, Double.class) : null;
        });
    }

    @Generated
    public Map<IFlows.Fields, String> getFieldsMapping() {
        return this.fieldsMapping;
    }

    private static /* synthetic */ DeserializationException lambda$new$0(Exception e, String source) {
        DeserializationException de;
        return e instanceof DeserializationException ? (de = (DeserializationException)((Object)e)) : new DeserializationException(e, source);
    }
}

