/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import io.kestra.core.models.QueryFilter;
import io.kestra.core.models.dashboards.ColumnDescriptor;
import io.kestra.core.models.dashboards.DataFilter;
import io.kestra.core.models.dashboards.DataFilterKPI;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.LogRepositoryInterface;
import io.kestra.core.utils.DateUtils;
import io.kestra.core.utils.ListUtils;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.kestra.jdbc.services.JdbcFilterService;
import io.kestra.plugin.core.dashboard.data.ILogs;
import io.micronaut.data.model.Pageable;
import jakarta.annotation.Nullable;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.DeleteConditionStep;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.SelectConditionStep;
import org.jooq.SelectHavingStep;
import org.jooq.SelectSeekStepN;
import org.jooq.SortOrder;
import org.jooq.impl.DSL;
import org.slf4j.event.Level;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public abstract class AbstractJdbcLogRepository
extends AbstractJdbcRepository
implements LogRepositoryInterface {
    private static final Condition NORMAL_KIND_CONDITION = AbstractJdbcLogRepository.field("execution_kind").isNull();
    public static final String DATE_COLUMN = "timestamp";
    protected io.kestra.jdbc.AbstractJdbcRepository<LogEntry> jdbcRepository;
    protected final JdbcFilterService filterService;

    public AbstractJdbcLogRepository(io.kestra.jdbc.AbstractJdbcRepository<LogEntry> jdbcRepository, JdbcFilterService filterService) {
        this.jdbcRepository = jdbcRepository;
        this.filterService = filterService;
    }

    protected abstract Condition findCondition(String var1);

    @Override
    protected Condition findQueryCondition(String query) {
        return this.findCondition(query);
    }

    protected Map<ILogs.Fields, String> getFieldsMapping() {
        return Map.of(ILogs.Fields.DATE, DATE_COLUMN, ILogs.Fields.NAMESPACE, "namespace", ILogs.Fields.FLOW_ID, "flow_id", ILogs.Fields.TASK_ID, "task_id", ILogs.Fields.EXECUTION_ID, "execution_id", ILogs.Fields.TASK_RUN_ID, "taskrun_id", ILogs.Fields.ATTEMPT_NUMBER, "attempt_number", ILogs.Fields.TRIGGER_ID, "trigger_id", ILogs.Fields.LEVEL, "level", ILogs.Fields.MESSAGE, "message");
    }

    protected Map<ILogs.Fields, String> getWhereMapping() {
        return this.getFieldsMapping();
    }

    public Set<ILogs.Fields> dateFields() {
        return Set.of(ILogs.Fields.DATE);
    }

    public ILogs.Fields dateFilterField() {
        return ILogs.Fields.DATE;
    }

    public ArrayListTotal<LogEntry> find(Pageable pageable, @Nullable String tenantId, @Nullable List<QueryFilter> filters) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select(AbstractJdbcLogRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId)).and(NORMAL_KIND_CONDITION);
            select = select.and(this.filter(filters, DATE_COLUMN, QueryFilter.Resource.LOG));
            return this.jdbcRepository.fetchPage(context, select, pageable);
        });
    }

    public Flux<LogEntry> findAsync(@Nullable String tenantId, List<QueryFilter> filters) {
        return Flux.create(emitter -> this.jdbcRepository.getDslContextWrapper().transaction(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select(AbstractJdbcLogRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId)).and(NORMAL_KIND_CONDITION);
            select = select.and(this.filter(filters, DATE_COLUMN, QueryFilter.Resource.LOG));
            select.orderBy((OrderField)AbstractJdbcLogRepository.field(DATE_COLUMN).asc());
            try (Stream stream = select.fetchSize(100).stream();){
                stream.map(record -> this.jdbcRepository.map(record)).forEach(arg_0 -> ((FluxSink)emitter).next(arg_0));
            }
            finally {
                emitter.complete();
            }
        }), (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER);
    }

    public Flux<LogEntry> findAllAsync(@Nullable String tenantId) {
        return Flux.create(emitter -> this.jdbcRepository.getDslContextWrapper().transaction(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select(AbstractJdbcLogRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            try (Stream stream = select.fetchSize(100).stream();){
                stream.map(record -> this.jdbcRepository.map(record)).forEach(arg_0 -> ((FluxSink)emitter).next(arg_0));
            }
            finally {
                emitter.complete();
            }
        }), (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER);
    }

    public List<LogEntry> findByExecutionId(String tenantId, String executionId, Level minLevel) {
        return this.findByExecutionId(tenantId, executionId, minLevel, true);
    }

    public List<LogEntry> findByExecutionIdWithoutAcl(String tenantId, String executionId, Level minLevel) {
        return this.findByExecutionId(tenantId, executionId, minLevel, false);
    }

    private List<LogEntry> findByExecutionId(String tenantId, String executionId, Level minLevel, boolean withAccessControl) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId), minLevel, withAccessControl);
    }

    public ArrayListTotal<LogEntry> findByExecutionId(String tenantId, String executionId, Level minLevel, Pageable pageable) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId), minLevel, pageable);
    }

    public List<LogEntry> findByExecutionId(String tenantId, String namespace, String flowId, String executionId, Level minLevel) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcLogRepository.field("namespace").eq((Object)namespace)).and(AbstractJdbcLogRepository.field("flow_id").eq((Object)flowId)), minLevel, true);
    }

    public List<LogEntry> findByExecutionIdAndTaskId(String tenantId, String executionId, String taskId, Level minLevel) {
        return this.findByExecutionIdAndTaskId(tenantId, executionId, taskId, minLevel, true);
    }

    public List<LogEntry> findByExecutionIdAndTaskIdWithoutAcl(String tenantId, String executionId, String taskId, Level minLevel) {
        return this.findByExecutionIdAndTaskId(tenantId, executionId, taskId, minLevel, false);
    }

    private List<LogEntry> findByExecutionIdAndTaskId(String tenantId, String executionId, String taskId, Level minLevel, boolean withAccessControl) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcLogRepository.field("task_id").eq((Object)taskId)), minLevel, withAccessControl);
    }

    public ArrayListTotal<LogEntry> findByExecutionIdAndTaskId(String tenantId, String executionId, String taskId, Level minLevel, Pageable pageable) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcLogRepository.field("task_id").eq((Object)taskId)), minLevel, pageable);
    }

    public List<LogEntry> findByExecutionIdAndTaskId(String tenantId, String namespace, String flowId, String executionId, String taskId, Level minLevel) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcLogRepository.field("namespace").eq((Object)namespace)).and(AbstractJdbcLogRepository.field("flow_id").eq((Object)flowId)).and(AbstractJdbcLogRepository.field("task_id").eq((Object)taskId)), minLevel, true);
    }

    public List<LogEntry> findByExecutionIdAndTaskRunId(String tenantId, String executionId, String taskRunId, Level minLevel) {
        return this.findByExecutionIdAndTaskRunId(tenantId, executionId, taskRunId, minLevel, true);
    }

    public List<LogEntry> findByExecutionIdAndTaskRunIdWithoutAcl(String tenantId, String executionId, String taskRunId, Level minLevel) {
        return this.findByExecutionIdAndTaskRunId(tenantId, executionId, taskRunId, minLevel, false);
    }

    private List<LogEntry> findByExecutionIdAndTaskRunId(String tenantId, String executionId, String taskRunId, Level minLevel, boolean withAccessControl) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcLogRepository.field("taskrun_id").eq((Object)taskRunId)), minLevel, withAccessControl);
    }

    public ArrayListTotal<LogEntry> findByExecutionIdAndTaskRunId(String tenantId, String executionId, String taskRunId, Level minLevel, Pageable pageable) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcLogRepository.field("taskrun_id").eq((Object)taskRunId)), minLevel, pageable);
    }

    public List<LogEntry> findByExecutionIdAndTaskRunIdAndAttempt(String tenantId, String executionId, String taskRunId, Level minLevel, Integer attempt) {
        return this.findByExecutionIdAndTaskRunIdAndAttempt(tenantId, executionId, taskRunId, minLevel, attempt, true);
    }

    public List<LogEntry> findByExecutionIdAndTaskRunIdAndAttemptWithoutAcl(String tenantId, String executionId, String taskRunId, Level minLevel, Integer attempt) {
        return this.findByExecutionIdAndTaskRunIdAndAttempt(tenantId, executionId, taskRunId, minLevel, attempt, false);
    }

    private List<LogEntry> findByExecutionIdAndTaskRunIdAndAttempt(String tenantId, String executionId, String taskRunId, Level minLevel, Integer attempt, boolean withAccessControl) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcLogRepository.field("taskrun_id").eq((Object)taskRunId)).and(AbstractJdbcLogRepository.field("attempt_number").eq((Object)attempt)), minLevel, withAccessControl);
    }

    public ArrayListTotal<LogEntry> findByExecutionIdAndTaskRunIdAndAttempt(String tenantId, String executionId, String taskRunId, Level minLevel, Integer attempt, Pageable pageable) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcLogRepository.field("taskrun_id").eq((Object)taskRunId)).and(AbstractJdbcLogRepository.field("attempt_number").eq((Object)attempt)), minLevel, pageable);
    }

    public LogEntry save(LogEntry log) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(log);
        this.jdbcRepository.persist(log, fields);
        return log;
    }

    public int saveBatch(List<LogEntry> items) {
        if (ListUtils.isEmpty(items)) {
            return 0;
        }
        return this.jdbcRepository.persistBatch(items);
    }

    public Integer purge(Execution execution) {
        return (Integer)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            return context.delete(this.jdbcRepository.getTable()).where(AbstractJdbcLogRepository.field("deleted", Boolean.class).eq((Object)false)).and(AbstractJdbcLogRepository.field("execution_id", String.class).eq((Object)execution.getId())).execute();
        });
    }

    public Integer purge(List<Execution> executions) {
        return (Integer)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            return context.delete(this.jdbcRepository.getTable()).where(AbstractJdbcLogRepository.field("deleted", Boolean.class).eq((Object)false)).and(AbstractJdbcLogRepository.field("execution_id", String.class).in(executions.stream().map(Execution::getId).toList())).execute();
        });
    }

    public void deleteByQuery(String tenantId, String executionId, String taskId, String taskRunId, Level minLevel, Integer attempt) {
        this.jdbcRepository.getDslContextWrapper().transaction(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            DeleteConditionStep delete = context.delete(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId)).and(AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId));
            if (taskId != null) {
                delete = delete.and(AbstractJdbcLogRepository.field("task_id").eq((Object)taskId));
            }
            if (taskRunId != null) {
                delete = delete.and(AbstractJdbcLogRepository.field("taskrun_id").eq((Object)taskRunId));
            }
            if (minLevel != null) {
                delete = delete.and(this.minLevel(minLevel));
            }
            if (attempt != null) {
                delete = delete.and(AbstractJdbcLogRepository.field("attempt_number").eq((Object)attempt));
            }
            delete.execute();
        });
    }

    public void deleteByQuery(String tenantId, String namespace, String flowId, String triggerId) {
        this.jdbcRepository.getDslContextWrapper().transaction(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            DeleteConditionStep delete = context.delete(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId)).and(AbstractJdbcLogRepository.field("namespace").eq((Object)namespace)).and(AbstractJdbcLogRepository.field("flow_id").eq((Object)flowId));
            if (triggerId != null) {
                delete = delete.and(AbstractJdbcLogRepository.field("trigger_id").eq((Object)triggerId));
            }
            delete.execute();
        });
    }

    public int deleteByQuery(String tenantId, String namespace, String flowId, String executionId, List<Level> logLevels, ZonedDateTime startDate, ZonedDateTime endDate) {
        return (Integer)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            DeleteConditionStep delete = context.delete(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId)).and(AbstractJdbcLogRepository.field(DATE_COLUMN).lessOrEqual((Object)endDate.toOffsetDateTime()));
            if (startDate != null) {
                delete = delete.and(AbstractJdbcLogRepository.field(DATE_COLUMN).greaterOrEqual((Object)startDate.toOffsetDateTime()));
            }
            if (namespace != null) {
                delete = delete.and(AbstractJdbcLogRepository.field("namespace").eq((Object)namespace));
            }
            if (flowId != null) {
                delete = delete.and(AbstractJdbcLogRepository.field("flow_id").eq((Object)flowId));
            }
            if (executionId != null) {
                delete = delete.and(AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId));
            }
            if (logLevels != null) {
                delete = delete.and(this.levelsCondition(logLevels));
            }
            return delete.execute();
        });
    }

    public void deleteByFilters(String tenantId, List<QueryFilter> filters) {
        this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            DeleteConditionStep delete = context.delete(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            delete = delete.and(this.filter(filters, DATE_COLUMN, QueryFilter.Resource.LOG));
            return delete.execute();
        });
    }

    private ArrayListTotal<LogEntry> query(String tenantId, Condition condition, Level minLevel, Pageable pageable) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select(AbstractJdbcLogRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            select = select.and(condition);
            if (minLevel != null) {
                select = select.and(this.minLevel(minLevel));
            }
            return this.jdbcRepository.fetchPage(context, select, pageable);
        });
    }

    private List<LogEntry> query(String tenantId, Condition condition, Level minLevel, boolean withAccessControl) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcLogRepository.field("value")).from(this.jdbcRepository.getTable()).where(withAccessControl ? this.defaultFilter(tenantId) : this.defaultFilterWithNoACL(tenantId));
            select = select.and(condition);
            if (minLevel != null) {
                select = select.and(this.minLevel(minLevel));
            }
            return this.jdbcRepository.fetch(select.orderBy((OrderField)AbstractJdbcLogRepository.field(DATE_COLUMN).sort(SortOrder.ASC)));
        });
    }

    private Condition minLevel(Level minLevel) {
        return this.levelsCondition(LogEntry.findLevelsByMin((Level)minLevel));
    }

    @Override
    protected Condition levelsCondition(List<Level> levels) {
        return AbstractJdbcLogRepository.field("level").in(levels.stream().map(level -> level.name()).toList());
    }

    public Double fetchValue(String tenantId, DataFilterKPI<ILogs.Fields, ? extends ColumnDescriptor<ILogs.Fields>> dataFilter, ZonedDateTime startDate, ZonedDateTime endDate, boolean numeratorFilter) {
        return (Double)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep selectStep;
            SelectConditionStep<Record> selectConditionStep;
            Record result;
            DSLContext context = DSL.using((Configuration)configuration);
            ColumnDescriptor columnDescriptor = dataFilter.getColumns();
            String columnKey = this.getFieldsMapping().get(columnDescriptor.getField());
            Field<?> field = this.columnToField(columnDescriptor, this.getFieldsMapping());
            if (columnDescriptor.getAgg() != null) {
                field = this.filterService.buildAggregation(field, columnDescriptor.getAgg());
            }
            ArrayList filters = new ArrayList(ListUtils.emptyOnNull((List)dataFilter.getWhere()));
            if (numeratorFilter) {
                filters.addAll(dataFilter.getNumerator());
            }
            if ((result = (selectConditionStep = this.where((SelectConditionStep<Record>)(selectStep = context.select(field).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId))), this.filterService, filters, this.getFieldsMapping())).fetchOne()) != null) {
                return (Double)result.getValue(field, Double.class);
            }
            return null;
        });
    }

    public ArrayListTotal<Map<String, Object>> fetchData(String tenantId, DataFilter<ILogs.Fields, ? extends ColumnDescriptor<ILogs.Fields>> descriptors, ZonedDateTime startDate, ZonedDateTime endDate, Pageable pageable) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            Map<String, ColumnDescriptor> columnsWithoutDate = descriptors.getColumns().entrySet().stream().filter(entry -> ((ColumnDescriptor)entry.getValue()).getField() == null || !this.dateFields().contains(((ColumnDescriptor)entry.getValue()).getField())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            boolean hasAgg = descriptors.getColumns().entrySet().stream().anyMatch(col -> ((ColumnDescriptor)col.getValue()).getAgg() != null);
            List<Field<Date>> dateFields = this.generateDateFields(descriptors, this.getFieldsMapping(), startDate, endDate, this.dateFields(), hasAgg ? null : DateUtils.GroupType.MINUTE);
            SelectConditionStep<Record> selectConditionStep = this.select(context, this.filterService, columnsWithoutDate, dateFields, this.getFieldsMapping(), this.jdbcRepository.getTable(), tenantId);
            selectConditionStep = this.where(selectConditionStep, this.filterService, descriptors.getWhere(), this.getWhereMapping());
            List<ColumnDescriptor> columnsWithoutDateWithOutAggs = columnsWithoutDate.values().stream().filter(column -> column.getAgg() == null).toList();
            SelectHavingStep<Record> selectHavingStep = this.groupBy(selectConditionStep, columnsWithoutDateWithOutAggs, dateFields, this.getFieldsMapping());
            SelectSeekStepN<Record> selectSeekStep = this.orderBy(selectHavingStep, descriptors);
            return this.fetchSeekStep(selectSeekStep, pageable);
        });
    }

    @Override
    protected abstract Field<Date> formatDateField(String var1, DateUtils.GroupType var2);

    @Generated
    public JdbcFilterService getFilterService() {
        return this.filterService;
    }
}

