/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.runner;

import io.kestra.core.runners.ExecutionDelay;
import io.kestra.jdbc.AbstractJdbcRepository;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.function.Consumer;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.SelectForStep;
import org.jooq.impl.DSL;

public abstract class AbstractJdbcExecutionDelayStorage
extends io.kestra.jdbc.repository.AbstractJdbcRepository {
    protected AbstractJdbcRepository<ExecutionDelay> jdbcRepository;

    public AbstractJdbcExecutionDelayStorage(AbstractJdbcRepository<ExecutionDelay> jdbcRepository) {
        this.jdbcRepository = jdbcRepository;
    }

    public void get(Consumer<ExecutionDelay> consumer) {
        ZonedDateTime now = ZonedDateTime.now();
        this.jdbcRepository.getDslContextWrapper().transaction(configuration -> {
            SelectForStep select = DSL.using((Configuration)configuration).select(io.kestra.jdbc.repository.AbstractJdbcRepository.field("value")).from(this.jdbcRepository.getTable()).where(io.kestra.jdbc.repository.AbstractJdbcRepository.field("date").lessOrEqual((Object)now.toOffsetDateTime())).forUpdate().skipLocked();
            this.jdbcRepository.fetch(select).forEach(executionDelay -> {
                consumer.accept((ExecutionDelay)executionDelay);
                this.jdbcRepository.delete((ExecutionDelay)executionDelay);
            });
        });
    }

    public void save(ExecutionDelay executionDelay) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(executionDelay);
        this.jdbcRepository.persist(executionDelay, fields);
    }
}

