/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.runner;

import io.kestra.core.models.flows.sla.SLAMonitor;
import io.kestra.core.models.flows.sla.SLAMonitorStorage;
import io.kestra.jdbc.AbstractJdbcRepository;
import java.time.Instant;
import java.util.Map;
import java.util.function.Consumer;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectForStep;
import org.jooq.impl.DSL;

public abstract class AbstractJdbcSLAMonitorStorage
extends io.kestra.jdbc.repository.AbstractJdbcRepository
implements SLAMonitorStorage {
    protected AbstractJdbcRepository<SLAMonitor> jdbcRepository;

    protected AbstractJdbcSLAMonitorStorage(AbstractJdbcRepository<SLAMonitor> jdbcRepository) {
        this.jdbcRepository = jdbcRepository;
    }

    public void save(SLAMonitor slaMonitor) {
        this.jdbcRepository.getDslContextWrapper().transaction(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(slaMonitor);
            this.jdbcRepository.persist(slaMonitor, context, fields);
        });
    }

    public void purge(String executionId) {
        this.jdbcRepository.getDslContextWrapper().transaction(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            context.delete(this.jdbcRepository.getTable()).where(AbstractJdbcSLAMonitorStorage.field("execution_id").eq((Object)executionId)).execute();
        });
    }

    public void processExpired(Instant date, Consumer<SLAMonitor> consumer) {
        this.jdbcRepository.getDslContextWrapper().transaction(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectForStep select = context.select(new SelectFieldOrAsterisk[0]).from(this.jdbcRepository.getTable()).where(AbstractJdbcSLAMonitorStorage.field("deadline").lt((Object)date)).forUpdate().skipLocked();
            this.jdbcRepository.fetch(select).forEach(slaMonitor -> {
                consumer.accept((SLAMonitor)slaMonitor);
                this.jdbcRepository.delete((SLAMonitor)slaMonitor);
            });
        });
    }
}

