/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.runner;

import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.queues.QueueException;
import io.kestra.core.runners.ScheduleContextInterface;
import io.kestra.core.runners.SchedulerTriggerStateInterface;
import io.kestra.jdbc.repository.AbstractJdbcTriggerRepository;
import io.kestra.jdbc.runner.JdbcRunnerEnabled;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Singleton;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.NotImplementedException;

@Singleton
@JdbcRunnerEnabled
public class JdbcSchedulerTriggerState
implements SchedulerTriggerStateInterface {
    protected AbstractJdbcTriggerRepository triggerRepository;

    public JdbcSchedulerTriggerState(AbstractJdbcTriggerRepository triggerRepository) {
        this.triggerRepository = triggerRepository;
    }

    @PostConstruct
    public void initTriggerEvaluateRunning() {
        this.triggerRepository.findAllForAllTenants().forEach(trigger -> {
            if (trigger.getEvaluateRunningDate() != null) {
                Trigger unlocked = trigger.toBuilder().evaluateRunningDate(null).build();
                this.triggerRepository.save(unlocked);
            }
        });
    }

    public Optional<Trigger> findLast(TriggerContext context) {
        return this.triggerRepository.findLast(context);
    }

    public List<Trigger> findAllForAllTenants() {
        return this.triggerRepository.findAllForAllTenants();
    }

    public Trigger save(Trigger trigger, ScheduleContextInterface scheduleContextInterface) {
        this.triggerRepository.save(trigger, scheduleContextInterface);
        return trigger;
    }

    public Trigger create(Trigger trigger, String headerContent) {
        return this.triggerRepository.create(trigger);
    }

    public Trigger save(Trigger trigger, ScheduleContextInterface scheduleContextInterface, String headerContent) {
        this.triggerRepository.save(trigger, scheduleContextInterface);
        return trigger;
    }

    public Trigger create(Trigger trigger) {
        return this.triggerRepository.create(trigger);
    }

    public Trigger update(Trigger trigger) {
        Optional<Trigger> existing = this.findLast((TriggerContext)trigger);
        Trigger updated = trigger;
        if (existing.isPresent() && existing.get().getDisabled().booleanValue()) {
            updated = ((Trigger.TriggerBuilder)trigger.toBuilder().disabled(Boolean.valueOf(true))).build();
        }
        return this.triggerRepository.update(updated);
    }

    public Trigger update(Flow flow, AbstractTrigger abstractTrigger, ConditionContext conditionContext) {
        return this.triggerRepository.update(flow, abstractTrigger, conditionContext);
    }

    public void delete(Trigger trigger) throws QueueException {
        this.triggerRepository.delete(trigger);
    }

    public List<Trigger> findByNextExecutionDateReadyForAllTenants(ZonedDateTime now, ScheduleContextInterface scheduleContext) {
        return this.triggerRepository.findByNextExecutionDateReadyForAllTenants(now, scheduleContext);
    }

    public List<Trigger> findByNextExecutionDateReadyButLockedTriggers(ZonedDateTime now) {
        return this.triggerRepository.findByNextExecutionDateReadyButLockedTriggers(now);
    }

    public List<Trigger> findByNextExecutionDateReadyForGivenFlows(List<FlowWithSource> flows, ZonedDateTime now, ScheduleContextInterface scheduleContext) {
        throw new NotImplementedException();
    }
}

