/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc;

import io.kestra.core.metrics.MetricRegistry;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.ArrayList;
import javax.sql.DataSource;
import lombok.Generated;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
public class JooqExecuteListenerFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JooqExecuteListenerFactory.class);

    @EachBean(value=DataSource.class)
    public ExecuteListenerProvider jooqConfiguration(final MetricRegistry metricRegistry) {
        return new ExecuteListenerProvider(){

            @NotNull
            public ExecuteListener provide() {
                return new ExecuteListener(){
                    Long startTime;

                    public void executeStart(ExecuteContext ctx) {
                        this.startTime = System.currentTimeMillis();
                    }

                    public void executeEnd(ExecuteContext ctx) {
                        Duration duration = Duration.ofMillis(System.currentTimeMillis() - this.startTime);
                        ArrayList<String> tags = new ArrayList<String>();
                        tags.add("batch");
                        tags.add(ctx.batchMode().name());
                        if (ctx.batchMode() != ExecuteContext.BatchMode.MULTIPLE) {
                            tags.add("sql");
                            tags.add(ctx.sql());
                        }
                        metricRegistry.timer("jdbc.query.duration", "Duration of database queries", tags.toArray(new String[0])).record(duration);
                        if (log.isTraceEnabled()) {
                            log.trace("[Duration: {}] [Rows: {}] [Query: {}]", new Object[]{duration, ctx.rows(), ctx.query()});
                        } else if (log.isDebugEnabled()) {
                            log.debug("[Duration: {}] [Rows: {}] [Query: {}]", new Object[]{duration, ctx.rows(), ctx.sql()});
                        }
                    }
                };
            }
        };
    }
}

