/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.topologies.FlowTopology;
import io.kestra.core.repositories.FlowTopologyRepositoryInterface;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.kestra.jdbc.runner.JdbcQueueIndexerInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DMLQuery;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectConditionStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;

public abstract class AbstractJdbcFlowTopologyRepository
extends AbstractJdbcRepository
implements FlowTopologyRepositoryInterface,
JdbcQueueIndexerInterface<FlowTopology> {
    protected final io.kestra.jdbc.AbstractJdbcRepository<FlowTopology> jdbcRepository;

    public AbstractJdbcFlowTopologyRepository(io.kestra.jdbc.AbstractJdbcRepository<FlowTopology> jdbcRepository) {
        this.jdbcRepository = jdbcRepository;
    }

    public List<FlowTopology> findByFlow(String tenantId, String namespace, String flowId, Boolean destinationOnly) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            ArrayList<Condition> ors = new ArrayList<Condition>();
            ors.add(DSL.and((Condition[])new Condition[]{this.buildTenantCondition("destination", tenantId), AbstractJdbcFlowTopologyRepository.field("destination_namespace").eq((Object)namespace), AbstractJdbcFlowTopologyRepository.field("destination_id").eq((Object)flowId)}));
            if (!destinationOnly.booleanValue()) {
                ors.add(DSL.and((Condition[])new Condition[]{this.buildTenantCondition("source", tenantId), AbstractJdbcFlowTopologyRepository.field("source_namespace").eq((Object)namespace), AbstractJdbcFlowTopologyRepository.field("source_id").eq((Object)flowId)}));
            }
            SelectConditionStep from = DSL.using((Configuration)configuration).select(AbstractJdbcFlowTopologyRepository.field("value")).from(this.jdbcRepository.getTable()).where(DSL.or(ors));
            return this.jdbcRepository.fetch(from);
        });
    }

    public List<FlowTopology> findByNamespace(String tenantId, String namespace) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            ArrayList<Condition> ors = new ArrayList<Condition>();
            ors.add(DSL.and((Condition[])new Condition[]{this.buildTenantCondition("destination", tenantId), AbstractJdbcFlowTopologyRepository.field("destination_namespace").eq((Object)namespace), this.buildTenantCondition("source", tenantId), AbstractJdbcFlowTopologyRepository.field("source_namespace").eq((Object)namespace)}));
            SelectConditionStep from = DSL.using((Configuration)configuration).select(AbstractJdbcFlowTopologyRepository.field("value")).from(this.jdbcRepository.getTable()).where(DSL.or(ors));
            return this.jdbcRepository.fetch(from);
        });
    }

    public List<FlowTopology> findAll(String tenantId) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            ArrayList<Condition> ors = new ArrayList<Condition>();
            ors.add(DSL.and((Condition)this.buildTenantCondition("destination", tenantId), (Condition)this.buildTenantCondition("source", tenantId)));
            SelectConditionStep from = DSL.using((Configuration)configuration).select(AbstractJdbcFlowTopologyRepository.field("value")).from(this.jdbcRepository.getTable()).where(DSL.or(ors));
            return this.jdbcRepository.fetch(from);
        });
    }

    public void save(FlowInterface flow, List<FlowTopology> flowTopologies) {
        this.jdbcRepository.getDslContextWrapper().transaction(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            context.delete(this.jdbcRepository.getTable()).where(DSL.or((Condition)DSL.and((Condition[])new Condition[]{this.buildTenantCondition("destination", flow.getTenantId()), AbstractJdbcFlowTopologyRepository.field("destination_namespace").eq((Object)flow.getNamespace()), AbstractJdbcFlowTopologyRepository.field("destination_id").eq((Object)flow.getId())}), (Condition)DSL.and((Condition[])new Condition[]{this.buildTenantCondition("source", flow.getTenantId()), AbstractJdbcFlowTopologyRepository.field("source_namespace").eq((Object)flow.getNamespace()), AbstractJdbcFlowTopologyRepository.field("source_id").eq((Object)flow.getId())}))).execute();
            if (!flowTopologies.isEmpty()) {
                context.batch(flowTopologies.stream().map(flowTopology -> this.buildMergeStatement(context, (FlowTopology)flowTopology)).toList()).execute();
            }
        });
    }

    protected DMLQuery<Record> buildMergeStatement(DSLContext context, FlowTopology flowTopology) {
        return context.mergeInto(this.jdbcRepository.getTable()).using((TableLike)context.selectOne()).on(AbstractJdbcRepository.field("key").eq((Object)this.jdbcRepository.key(flowTopology))).whenMatchedThenUpdate().set(this.jdbcRepository.persistFields(flowTopology)).whenNotMatchedThenInsert().set(AbstractJdbcRepository.field("key"), (Object)this.jdbcRepository.key(flowTopology)).set(this.jdbcRepository.persistFields(flowTopology));
    }

    public FlowTopology save(FlowTopology flowTopology) {
        this.jdbcRepository.persist(flowTopology);
        return flowTopology;
    }

    @Override
    public FlowTopology save(DSLContext dslContext, FlowTopology flowTopology) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(flowTopology);
        this.jdbcRepository.persist(flowTopology, dslContext, fields);
        return flowTopology;
    }

    protected Condition buildTenantCondition(String prefix, String tenantId) {
        return tenantId == null ? AbstractJdbcFlowTopologyRepository.field(prefix + "_tenant_id").isNull() : AbstractJdbcFlowTopologyRepository.field(prefix + "_tenant_id").eq((Object)tenantId);
    }
}

