/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import io.kestra.core.models.FetchVersion;
import io.kestra.core.models.QueryFilter;
import io.kestra.core.models.TenantAndNamespace;
import io.kestra.core.models.kv.PersistedKvMetadata;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.KvMetadataRepositoryInterface;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.micronaut.data.model.Pageable;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.DeleteConditionStep;
import org.jooq.Field;
import org.jooq.Record1;
import org.jooq.SelectConditionStep;
import org.jooq.impl.DSL;

public abstract class AbstractJdbcKvMetadataRepository
extends AbstractJdbcRepository
implements KvMetadataRepositoryInterface {
    protected final io.kestra.jdbc.AbstractJdbcRepository<PersistedKvMetadata> jdbcRepository;

    public AbstractJdbcKvMetadataRepository(io.kestra.jdbc.AbstractJdbcRepository<PersistedKvMetadata> jdbcRepository) {
        this.jdbcRepository = jdbcRepository;
    }

    private static Condition lastCondition(boolean isLast) {
        return AbstractJdbcKvMetadataRepository.field("last").eq((Object)isLast);
    }

    private static Condition lastCondition() {
        return AbstractJdbcKvMetadataRepository.lastCondition(true);
    }

    protected abstract Condition findCondition(String var1);

    @Override
    protected Condition findQueryCondition(String query) {
        return this.findCondition(query);
    }

    public Optional<PersistedKvMetadata> findByName(String tenantId, String namespace, String name) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep from = DSL.using((Configuration)configuration).select(AbstractJdbcKvMetadataRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId, true)).and(AbstractJdbcKvMetadataRepository.field("namespace").eq((Object)namespace)).and(AbstractJdbcKvMetadataRepository.field("name").eq((Object)name)).and(AbstractJdbcKvMetadataRepository.lastCondition());
            return this.jdbcRepository.fetchOne(from);
        });
    }

    private SelectConditionStep<Record1<Object>> findSelect(DSLContext context, @Nullable String tenantId, @Nullable List<QueryFilter> filters, boolean allowDeleted, boolean allowExpired, FetchVersion fetchBehavior) {
        SelectConditionStep condition = context.select(AbstractJdbcKvMetadataRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId, allowDeleted)).and((Condition)(allowExpired ? DSL.trueCondition() : DSL.or((Condition)AbstractJdbcKvMetadataRepository.field("expiration_date").greaterThan((Object)Instant.now()), (Condition)AbstractJdbcKvMetadataRepository.field("expiration_date").isNull()))).and(this.filter(filters, "updated", QueryFilter.Resource.KV_METADATA));
        switch (fetchBehavior) {
            case LATEST: {
                condition = condition.and(AbstractJdbcKvMetadataRepository.lastCondition());
                break;
            }
            case OLD: {
                condition = condition.and(AbstractJdbcKvMetadataRepository.lastCondition(false));
            }
        }
        return condition;
    }

    public ArrayListTotal<PersistedKvMetadata> find(Pageable pageable, String tenantId, List<QueryFilter> filters, boolean allowDeleted, boolean allowExpired, FetchVersion fetchBehavior) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep<Record1<Object>> select = this.findSelect(context, tenantId, filters, allowDeleted, allowExpired, fetchBehavior);
            return this.jdbcRepository.fetchPage(context, select, pageable);
        });
    }

    public Integer purge(List<PersistedKvMetadata> persistedKvsMetadata) {
        return (Integer)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            Map<TenantAndNamespace, List> byTenantNamespace = persistedKvsMetadata.stream().collect(Collectors.toMap(kvMetadata -> new TenantAndNamespace(kvMetadata.getTenantId(), kvMetadata.getNamespace()), List::of, (kv1, kv2) -> Stream.concat(kv1.stream(), kv2.stream()).toList()));
            return byTenantNamespace.entrySet().stream().reduce(0, (totalForTenantNamespace, e) -> {
                DeleteConditionStep deleteCondition = context.delete(this.jdbcRepository.getTable()).where(this.defaultFilter(((TenantAndNamespace)e.getKey()).tenantId(), true)).and(AbstractJdbcKvMetadataRepository.field("namespace").eq((Object)((TenantAndNamespace)e.getKey()).namespace())).and(AbstractJdbcKvMetadataRepository.field("last").in(new Object[]{true, false}));
                deleteCondition = ((PersistedKvMetadata)((List)e.getValue()).getFirst()).getVersion() == null ? deleteCondition.and(AbstractJdbcKvMetadataRepository.field("name").in(persistedKvsMetadata.stream().map(PersistedKvMetadata::getName).toList())) : deleteCondition.and(DSL.or(((List)e.getValue()).stream().map(kvMetadata -> DSL.and((Condition)AbstractJdbcKvMetadataRepository.field("name").eq((Object)kvMetadata.getName()), (Condition)AbstractJdbcKvMetadataRepository.field("version").eq((Object)kvMetadata.getVersion()))).toList()));
                int deletedAmount = deleteCondition.execute();
                return totalForTenantNamespace + deletedAmount;
            }, Integer::sum);
        });
    }

    public PersistedKvMetadata save(PersistedKvMetadata kvMetadata) {
        return (PersistedKvMetadata)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            Optional<PersistedKvMetadata> maybePrevious = this.findByName(kvMetadata.getTenantId(), kvMetadata.getNamespace(), kvMetadata.getName());
            PersistedKvMetadata kvMetadataToPersist = kvMetadata.asLast().toBuilder().version(Integer.valueOf(maybePrevious.map(PersistedKvMetadata::getVersion).orElse(0) + 1)).build();
            if (maybePrevious.isPresent()) {
                PersistedKvMetadata previous = maybePrevious.get();
                if (kvMetadata.isDeleted()) {
                    kvMetadataToPersist = previous.toBuilder().deleted(true).updated(Instant.now()).build();
                } else {
                    PersistedKvMetadata previousAsNotLast = previous.toBuilder().last(false).build();
                    Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(previousAsNotLast);
                    this.jdbcRepository.persist(previousAsNotLast, context, fields);
                }
            }
            Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(kvMetadataToPersist);
            this.jdbcRepository.persist(kvMetadataToPersist, context, fields);
            return kvMetadataToPersist;
        });
    }
}

