/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import io.kestra.core.exceptions.InvalidQueryFiltersException;
import io.kestra.core.models.QueryFilter;
import io.kestra.core.models.dashboards.ColumnDescriptor;
import io.kestra.core.models.dashboards.DataFilter;
import io.kestra.core.models.dashboards.Order;
import io.kestra.core.models.dashboards.filters.AbstractFilter;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.flows.FlowScope;
import io.kestra.core.models.flows.State;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.utils.DateUtils;
import io.kestra.core.utils.Either;
import io.kestra.core.utils.Enums;
import io.kestra.core.utils.ListUtils;
import io.kestra.jdbc.services.JdbcFilterService;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.Pageable;
import java.lang.runtime.SwitchBootstraps;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.SelectConditionStep;
import org.jooq.SelectHavingStep;
import org.jooq.SelectSeekStepN;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.slf4j.event.Level;

public abstract class AbstractJdbcRepository {
    protected static final int FETCH_SIZE = 100;
    @Value(value="${kestra.system-flows.namespace:system}")
    private String systemFlowNamespace;
    private static final Field<String> NAMESPACE_FIELD = AbstractJdbcRepository.field("namespace", String.class);

    protected Condition defaultFilter() {
        return AbstractJdbcRepository.field("deleted", Boolean.class).eq((Object)false);
    }

    protected Condition defaultFilter(Boolean allowDeleted) {
        return allowDeleted != false ? AbstractJdbcRepository.field("deleted", Boolean.class).in((Object[])new Boolean[]{true, false}) : AbstractJdbcRepository.field("deleted", Boolean.class).eq((Object)false);
    }

    protected Condition defaultFilter(String tenantId) {
        return this.defaultFilter(tenantId, false);
    }

    protected Condition defaultFilter(String tenantId, boolean allowDeleted) {
        Condition tenant = this.buildTenantCondition(tenantId);
        return allowDeleted ? tenant.and(AbstractJdbcRepository.field("deleted", Boolean.class).in((Object[])new Boolean[]{true, false})) : tenant.and(AbstractJdbcRepository.field("deleted", Boolean.class).eq((Object)false));
    }

    protected Condition defaultFilterWithNoACL(String tenantId) {
        return this.defaultFilterWithNoACL(tenantId, false);
    }

    protected Condition defaultFilterWithNoACL(String tenantId, boolean deleted) {
        Condition tenant = this.buildTenantCondition(tenantId);
        return deleted ? tenant.and(AbstractJdbcRepository.field("deleted", Boolean.class).in((Object[])new Boolean[]{true, false})) : tenant.and(AbstractJdbcRepository.field("deleted", Boolean.class).eq((Object)false));
    }

    protected Condition buildTenantCondition(String tenantId) {
        return tenantId == null ? AbstractJdbcRepository.field("tenant_id").isNull() : AbstractJdbcRepository.field("tenant_id").eq((Object)tenantId);
    }

    public static Field<Object> field(String name) {
        return DSL.field((Name)DSL.quotedName((String)name));
    }

    public static <T> Field<T> field(String name, Class<T> cls) {
        return DSL.field((Name)DSL.quotedName((String)name), cls);
    }

    protected List<Field<?>> groupByFields(Duration duration) {
        return this.groupByFields(duration, null, null);
    }

    protected List<Field<?>> groupByFields(Duration duration, boolean withAs) {
        return this.groupByFields(duration, null, null, withAs);
    }

    protected Field<Integer> weekFromTimestamp(Field<Timestamp> timestampField) {
        return DSL.week(timestampField);
    }

    protected List<Field<?>> groupByFields(Duration duration, @Nullable String dateField, @Nullable DateUtils.GroupType groupBy) {
        return this.groupByFields(duration, dateField, groupBy, true);
    }

    protected List<Field<?>> groupByFields(Duration duration, @Nullable String dateField, @Nullable DateUtils.GroupType groupBy, boolean withAs) {
        Field minute;
        String field = dateField != null ? dateField : "timestamp";
        Field month = withAs ? DSL.month((Field)DSL.timestamp(AbstractJdbcRepository.field(field, Date.class))).as("month") : DSL.month((Field)DSL.timestamp(AbstractJdbcRepository.field(field, Date.class)));
        Field year = withAs ? DSL.year((Field)DSL.timestamp(AbstractJdbcRepository.field(field, Date.class))).as("year") : DSL.year((Field)DSL.timestamp(AbstractJdbcRepository.field(field, Date.class)));
        Field day = withAs ? DSL.day((Field)DSL.timestamp(AbstractJdbcRepository.field(field, Date.class))).as("day") : DSL.day((Field)DSL.timestamp(AbstractJdbcRepository.field(field, Date.class)));
        Field week = withAs ? this.weekFromTimestamp((Field<Timestamp>)DSL.timestamp(AbstractJdbcRepository.field(field, Date.class))).as("week") : this.weekFromTimestamp((Field<Timestamp>)DSL.timestamp(AbstractJdbcRepository.field(field, Date.class)));
        Field hour = withAs ? DSL.hour((Field)DSL.timestamp(AbstractJdbcRepository.field(field, Date.class))).as("hour") : DSL.hour((Field)DSL.timestamp(AbstractJdbcRepository.field(field, Date.class)));
        Field field2 = minute = withAs ? DSL.minute((Field)DSL.timestamp(AbstractJdbcRepository.field(field, Date.class))).as("minute") : DSL.minute((Field)DSL.timestamp(AbstractJdbcRepository.field(field, Date.class)));
        if (groupBy == DateUtils.GroupType.MONTH || duration.toDays() > (long)DateUtils.GroupValue.MONTH.getValue()) {
            return List.of(year, month);
        }
        if (groupBy == DateUtils.GroupType.WEEK || duration.toDays() > (long)DateUtils.GroupValue.WEEK.getValue()) {
            return List.of(year, week);
        }
        if (groupBy == DateUtils.GroupType.DAY || duration.toDays() > (long)DateUtils.GroupValue.DAY.getValue()) {
            return List.of(year, month, day);
        }
        if (groupBy == DateUtils.GroupType.HOUR || duration.toHours() > (long)DateUtils.GroupValue.HOUR.getValue()) {
            return List.of(year, month, day, hour);
        }
        return List.of(year, month, day, hour, minute);
    }

    protected <F extends Enum<F>> SelectConditionStep<Record> select(DSLContext context, JdbcFilterService filterService, Map<String, ? extends ColumnDescriptor<F>> descriptors, List<Field<Date>> dateFields, Map<F, String> fieldsMapping, Table<Record> table, String tenantId) {
        return context.select(Stream.concat(descriptors.entrySet().stream().map(entry -> {
            ColumnDescriptor col = (ColumnDescriptor)entry.getValue();
            String key = (String)entry.getKey();
            Field<?> field = this.columnToField(col, fieldsMapping);
            if (col.getAgg() != null) {
                field = filterService.buildAggregation(field, col.getAgg());
            }
            return field.as(key);
        }), dateFields.stream()).toList()).from(table).where(this.defaultFilter(tenantId));
    }

    protected <F extends Enum<F>> SelectConditionStep<Record> where(SelectConditionStep<Record> selectConditionStep, JdbcFilterService jdbcFilterService, List<AbstractFilter<F>> filters, Map<F, String> fieldsMapping) {
        return (SelectConditionStep)jdbcFilterService.addFilters(selectConditionStep, fieldsMapping, filters);
    }

    protected <F extends Enum<F>> SelectHavingStep<Record> groupBy(SelectConditionStep<Record> selectConditionStep, List<? extends ColumnDescriptor<F>> columnsNoDate, List<Field<Date>> dateFields, Map<F, String> fieldsMapping) {
        return selectConditionStep.groupBy(Stream.concat(columnsNoDate.stream().filter(col -> col.getAgg() == null).map(col -> AbstractJdbcRepository.field((String)fieldsMapping.get(col.getField()))), dateFields.stream()).toList());
    }

    protected <F extends Enum<F>> SelectSeekStepN<Record> orderBy(SelectHavingStep<Record> selectHavingStep, DataFilter<F, ? extends ColumnDescriptor<F>> descriptors) {
        List<Object> orderFields = new ArrayList();
        if (!ListUtils.isEmpty((List)descriptors.getOrderBy())) {
            orderFields = descriptors.getOrderBy().stream().map(orderBy -> {
                Field<Object> field = AbstractJdbcRepository.field(orderBy.getColumn());
                return orderBy.getOrder() == Order.ASC ? field.asc() : field.desc();
            }).toList();
        }
        return selectHavingStep.orderBy(orderFields);
    }

    protected ArrayListTotal<Map<String, Object>> fetchSeekStep(SelectSeekStepN<Record> selectSeekStep, @Nullable Pageable pageable) {
        int totalCount = DSL.using((Configuration)selectSeekStep.configuration()).fetchCount(selectSeekStep);
        List results = (pageable != null && pageable.getSize() != -1 ? selectSeekStep.limit((Number)pageable.getSize()).offset((Number)(pageable.getOffset() - (long)pageable.getSize())) : selectSeekStep).fetch().intoMaps();
        return new ArrayListTotal(results, (long)totalCount);
    }

    protected <F extends Enum<F>> Field<?> columnToField(ColumnDescriptor<?> column, Map<F, String> fieldsMapping) {
        return column.getField() != null ? AbstractJdbcRepository.field(fieldsMapping.get(column.getField())) : null;
    }

    protected Condition filter(List<QueryFilter> filters, String dateColumn, QueryFilter.Resource resource) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        if (filters != null) {
            QueryFilter.validateQueryFilters(filters, (QueryFilter.Resource)resource);
            for (QueryFilter filter : filters) {
                QueryFilter.Field field = filter.field();
                QueryFilter.Op operation = filter.operation();
                Object value = filter.value();
                conditions.add(this.getConditionOnField(field, value, operation, dateColumn));
            }
        }
        return conditions.stream().reduce(DSL.noCondition(), Condition::and);
    }

    protected Condition getConditionOnField(QueryFilter.Field field, Object value, QueryFilter.Op operation, @Nullable String dateColumn) {
        if (field.equals((Object)QueryFilter.Field.QUERY)) {
            return this.handleQuery(value, operation);
        }
        if (field.equals((Object)QueryFilter.Field.STATE)) {
            return this.generateStateCondition(value, operation);
        }
        if (field.equals((Object)QueryFilter.Field.CHILD_FILTER)) {
            return this.handleChildFilter(value);
        }
        if (field.equals((Object)QueryFilter.Field.MIN_LEVEL)) {
            return this.handleMinLevelField(value, operation);
        }
        if (field == QueryFilter.Field.START_DATE || field == QueryFilter.Field.END_DATE || field == QueryFilter.Field.UPDATED) {
            if (dateColumn == null) {
                throw new InvalidQueryFiltersException("When creating filtering on START_DATE and/or END_DATE, dateColumn is required but was null");
            }
            OffsetDateTime dateTime = value instanceof ZonedDateTime ? ((ZonedDateTime)value).toOffsetDateTime() : ZonedDateTime.parse(value.toString()).toOffsetDateTime();
            return this.applyDateCondition(dateTime, operation, dateColumn);
        }
        if (field == QueryFilter.Field.SCOPE) {
            return this.applyScopeCondition(value, operation);
        }
        if (field.equals((Object)QueryFilter.Field.LABELS)) {
            if (value instanceof Map) {
                Map map = (Map)value;
                return this.findLabelCondition(Either.left((Object)map), operation);
            }
            if (value instanceof String) {
                String string = (String)value;
                return this.findLabelCondition(Either.right((Object)string), operation);
            }
            throw new InvalidQueryFiltersException("Label field value must be instance of Map or String");
        }
        if (field == QueryFilter.Field.KIND) {
            return this.applyKindCondition(value, operation);
        }
        Name columnName = DSL.quotedName((String)field.name().toLowerCase());
        return switch (operation) {
            case QueryFilter.Op.EQUALS -> DSL.field((Name)columnName).eq(value);
            case QueryFilter.Op.NOT_EQUALS -> DSL.field((Name)columnName).ne(value);
            case QueryFilter.Op.GREATER_THAN -> DSL.field((Name)columnName).greaterThan(value);
            case QueryFilter.Op.LESS_THAN -> DSL.field((Name)columnName).lessThan(value);
            case QueryFilter.Op.IN -> DSL.field((Name)columnName).in((Collection)ListUtils.convertToList((Object)value));
            case QueryFilter.Op.NOT_IN -> DSL.field((Name)columnName).notIn((Collection)ListUtils.convertToList((Object)value));
            case QueryFilter.Op.STARTS_WITH -> DSL.field((Name)columnName).like(String.valueOf(value) + "%");
            case QueryFilter.Op.ENDS_WITH -> DSL.field((Name)columnName).like("%" + String.valueOf(value));
            case QueryFilter.Op.CONTAINS -> DSL.field((Name)columnName).like("%" + String.valueOf(value) + "%");
            case QueryFilter.Op.REGEX -> DSL.field((Name)columnName).likeRegex((String)value);
            case QueryFilter.Op.PREFIX -> DSL.field((Name)columnName).like(String.valueOf(value) + ".%").or(DSL.field((Name)columnName).eq(value));
            default -> throw new InvalidQueryFiltersException("Unsupported operation: " + String.valueOf(operation));
        };
    }

    protected Condition findQueryCondition(String query) {
        throw new InvalidQueryFiltersException("Unsupported operation: ");
    }

    protected Condition findLabelCondition(Either<Map<?, ?>, String> value, QueryFilter.Op operation) {
        throw new InvalidQueryFiltersException("Unsupported operation: " + String.valueOf(operation));
    }

    private Condition generateStateCondition(Object value, QueryFilter.Op operation) {
        List list;
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        block10: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{List.class, List.class, State.Type.class, String.class}, (Object)object2, n)) {
                case 0: {
                    List list2 = (List)object2;
                    if (list2.isEmpty() || !(list2.getFirst() instanceof State.Type)) {
                        n = 1;
                        continue block10;
                    }
                    list = list2;
                    break block10;
                }
                case 1: {
                    List list3 = (List)object2;
                    list = list3.stream().map(item -> State.Type.valueOf((String)item.toString())).toList();
                    break block10;
                }
                case 2: {
                    State.Type state = (State.Type)object2;
                    list = List.of(state);
                    break block10;
                }
                case 3: {
                    String state = (String)object2;
                    list = List.of(State.Type.valueOf((String)state));
                    break block10;
                }
                default: {
                    throw new InvalidQueryFiltersException("Field 'state' requires a State.Type or List<State.Type> value");
                }
            }
            break;
        }
        List stateList = list;
        return switch (operation) {
            case QueryFilter.Op.EQUALS, QueryFilter.Op.IN -> this.statesFilter(stateList);
            case QueryFilter.Op.NOT_EQUALS, QueryFilter.Op.NOT_IN -> DSL.not((Condition)this.statesFilter(stateList));
            default -> throw new InvalidQueryFiltersException("Unsupported operation for State.Type: " + String.valueOf(operation));
        };
    }

    protected Condition statesFilter(List<State.Type> state) {
        return AbstractJdbcRepository.field("state_current").in(state.stream().map(Enum::name).toList());
    }

    private Condition handleQuery(Object value, QueryFilter.Op operation) {
        Condition condition = this.findQueryCondition(value.toString());
        return switch (operation) {
            case QueryFilter.Op.EQUALS -> condition;
            case QueryFilter.Op.NOT_EQUALS -> condition.not();
            default -> throw new InvalidQueryFiltersException("Unsupported operation for QUERY field: " + String.valueOf(operation));
        };
    }

    private Condition handleChildFilter(Object value) {
        ExecutionRepositoryInterface.ChildFilter childFilter;
        if (value instanceof String) {
            String val = (String)value;
            childFilter = ExecutionRepositoryInterface.ChildFilter.valueOf((String)val);
        } else {
            childFilter = (ExecutionRepositoryInterface.ChildFilter)value;
        }
        ExecutionRepositoryInterface.ChildFilter childFilter2 = childFilter;
        return switch (childFilter2) {
            default -> throw new MatchException(null, null);
            case ExecutionRepositoryInterface.ChildFilter.CHILD -> AbstractJdbcRepository.field("trigger_execution_id").isNotNull();
            case ExecutionRepositoryInterface.ChildFilter.MAIN -> AbstractJdbcRepository.field("trigger_execution_id").isNull();
        };
    }

    private Condition handleMinLevelField(Object value, QueryFilter.Op operation) {
        Level minLevel = value instanceof Level ? (Level)value : Level.valueOf((String)((String)value));
        return switch (operation) {
            case QueryFilter.Op.EQUALS -> this.minLevelCondition(minLevel);
            case QueryFilter.Op.NOT_EQUALS -> this.minLevelCondition(minLevel).not();
            default -> throw new InvalidQueryFiltersException("Unsupported operation for MIN_LEVEL: " + String.valueOf(operation));
        };
    }

    private Condition minLevelCondition(Level minLevel) {
        return this.levelsCondition(LogEntry.findLevelsByMin((Level)minLevel));
    }

    protected Condition levelsCondition(List<Level> levels) {
        return AbstractJdbcRepository.field("level").in(levels.stream().map(level -> level.name()).toList());
    }

    private Condition applyDateCondition(OffsetDateTime dateTime, QueryFilter.Op operation, String fieldName) {
        return switch (operation) {
            case QueryFilter.Op.LESS_THAN -> AbstractJdbcRepository.field(fieldName).lessThan((Object)dateTime);
            case QueryFilter.Op.LESS_THAN_OR_EQUAL_TO -> AbstractJdbcRepository.field(fieldName).lessOrEqual((Object)dateTime);
            case QueryFilter.Op.GREATER_THAN -> AbstractJdbcRepository.field(fieldName).greaterThan((Object)dateTime);
            case QueryFilter.Op.GREATER_THAN_OR_EQUAL_TO -> AbstractJdbcRepository.field(fieldName).greaterOrEqual((Object)dateTime);
            case QueryFilter.Op.EQUALS -> AbstractJdbcRepository.field(fieldName).eq((Object)dateTime);
            case QueryFilter.Op.NOT_EQUALS -> AbstractJdbcRepository.field(fieldName).ne((Object)dateTime);
            default -> throw new InvalidQueryFiltersException("Unsupported operation for date condition: " + String.valueOf(operation));
        };
    }

    private Condition applyScopeCondition(Object value, QueryFilter.Op operation) {
        List flowScopes = Enums.fromList((Object)value, FlowScope.class);
        if (flowScopes.size() > 1) {
            throw new InvalidQueryFiltersException("Only one scope can be use in the same time");
        }
        FlowScope scope = (FlowScope)flowScopes.getFirst();
        String systemNamespace = this.getSystemFlowNamespace();
        return switch (operation) {
            case QueryFilter.Op.EQUALS -> {
                if (FlowScope.USER.equals((Object)scope)) {
                    yield AbstractJdbcRepository.field("namespace").ne((Object)systemNamespace);
                }
                yield AbstractJdbcRepository.field("namespace").eq((Object)systemNamespace);
            }
            case QueryFilter.Op.NOT_EQUALS -> {
                if (FlowScope.USER.equals((Object)scope)) {
                    yield AbstractJdbcRepository.field("namespace").eq((Object)systemNamespace);
                }
                yield AbstractJdbcRepository.field("namespace").ne((Object)systemNamespace);
            }
            default -> throw new InvalidQueryFiltersException("Unsupported operation for SCOPE: " + String.valueOf(operation));
        };
    }

    private Condition applyKindCondition(Object value, QueryFilter.Op operation) {
        String kind = value.toString();
        return switch (operation) {
            case QueryFilter.Op.EQUALS -> AbstractJdbcRepository.field("kind").eq((Object)kind);
            case QueryFilter.Op.NOT_EQUALS -> AbstractJdbcRepository.field("kind").ne((Object)kind);
            default -> throw new InvalidQueryFiltersException("Unsupported operation for KIND: " + String.valueOf(operation));
        };
    }

    protected Field<Date> formatDateField(String dateField, DateUtils.GroupType groupType) {
        throw new UnsupportedOperationException("formatDateField() not implemented");
    }

    protected <F extends Enum<F>> List<Field<Date>> generateDateFields(DataFilter<F, ? extends ColumnDescriptor<F>> descriptors, Map<F, String> fieldsMapping, ZonedDateTime startDate, ZonedDateTime endDate, Set<F> dateFields, @Nullable DateUtils.GroupType groupType) {
        return descriptors.getColumns().entrySet().stream().filter(entry -> ((ColumnDescriptor)entry.getValue()).getAgg() == null && dateFields.contains(((ColumnDescriptor)entry.getValue()).getField())).map(entry -> {
            Duration duration = Duration.between(startDate, endDate == null ? ZonedDateTime.now() : endDate);
            DateUtils.GroupType effectiveGroupType = groupType != null ? groupType : DateUtils.groupByType((Duration)duration);
            return this.formatDateField((String)fieldsMapping.get(((ColumnDescriptor)entry.getValue()).getField()), effectiveGroupType).as((String)entry.getKey());
        }).toList();
    }

    @Generated
    public String getSystemFlowNamespace() {
        return this.systemFlowNamespace;
    }
}

