/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import io.kestra.core.models.QueryFilter;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.dashboards.ColumnDescriptor;
import io.kestra.core.models.dashboards.DataFilter;
import io.kestra.core.models.dashboards.DataFilterKPI;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.TriggerRepositoryInterface;
import io.kestra.core.runners.ScheduleContextInterface;
import io.kestra.core.utils.DateUtils;
import io.kestra.core.utils.ListUtils;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.kestra.jdbc.runner.JdbcQueueIndexerInterface;
import io.kestra.jdbc.runner.JdbcSchedulerContext;
import io.kestra.jdbc.services.JdbcFilterService;
import io.kestra.plugin.core.dashboard.data.ITriggers;
import io.micronaut.data.model.Pageable;
import jakarta.annotation.Nullable;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.SelectConditionStep;
import org.jooq.SelectHavingStep;
import org.jooq.SelectJoinStep;
import org.jooq.SelectSeekStepN;
import org.jooq.impl.DSL;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public abstract class AbstractJdbcTriggerRepository
extends AbstractJdbcRepository
implements TriggerRepositoryInterface,
JdbcQueueIndexerInterface<Trigger> {
    public static final Field<Object> NAMESPACE_FIELD = AbstractJdbcTriggerRepository.field("namespace");
    protected io.kestra.jdbc.AbstractJdbcRepository<Trigger> jdbcRepository;
    private final JdbcFilterService filterService;
    private final Map<ITriggers.Fields, String> fieldsMapping = Map.of(ITriggers.Fields.ID, "key", ITriggers.Fields.NAMESPACE, "namespace", ITriggers.Fields.FLOW_ID, "flow_id", ITriggers.Fields.TRIGGER_ID, "trigger_id", ITriggers.Fields.EXECUTION_ID, "execution_id", ITriggers.Fields.NEXT_EXECUTION_DATE, "next_execution_date", ITriggers.Fields.WORKER_ID, "worker_id");

    public Set<ITriggers.Fields> dateFields() {
        return Set.of();
    }

    public ITriggers.Fields dateFilterField() {
        return null;
    }

    public AbstractJdbcTriggerRepository(io.kestra.jdbc.AbstractJdbcRepository<Trigger> jdbcRepository, JdbcFilterService filterService) {
        this.jdbcRepository = jdbcRepository;
        this.filterService = filterService;
    }

    public Optional<Trigger> findLast(TriggerContext trigger) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcTriggerRepository.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcTriggerRepository.field("key").eq((Object)trigger.uid()));
            return this.jdbcRepository.fetchOne(select);
        });
    }

    public Optional<Trigger> findByExecution(Execution execution) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcTriggerRepository.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcTriggerRepository.field("execution_id").eq((Object)execution.getId()));
            return this.jdbcRepository.fetchOne(select);
        });
    }

    public List<Trigger> findAll(String tenantId) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcTriggerRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            return this.jdbcRepository.fetch(select);
        });
    }

    public List<Trigger> findAllForAllTenants() {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectJoinStep select = DSL.using((Configuration)configuration).select(AbstractJdbcTriggerRepository.field("value")).from(this.jdbcRepository.getTable());
            return this.jdbcRepository.fetch(select);
        });
    }

    public int count(@Nullable String tenantId) {
        return (Integer)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> (Integer)DSL.using((Configuration)configuration).selectCount().from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId)).fetchOne(0, Integer.TYPE));
    }

    public List<Trigger> findByNextExecutionDateReadyForAllTenants(ZonedDateTime now, ScheduleContextInterface scheduleContextInterface) {
        JdbcSchedulerContext jdbcSchedulerContext = (JdbcSchedulerContext)scheduleContextInterface;
        return jdbcSchedulerContext.getContext().select(AbstractJdbcTriggerRepository.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcTriggerRepository.field("next_execution_date").lessThan((Object)this.toNextExecutionTime(now)).or(AbstractJdbcTriggerRepository.field("next_execution_date").isNull()).and(AbstractJdbcTriggerRepository.field("execution_id").isNull())).orderBy((OrderField)AbstractJdbcTriggerRepository.field("next_execution_date").asc()).forUpdate().skipLocked().fetch().map(r -> this.jdbcRepository.deserialize((String)r.get("value", String.class)));
    }

    public List<Trigger> findByNextExecutionDateReadyButLockedTriggers(ZonedDateTime now) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> DSL.using((Configuration)configuration).select(AbstractJdbcTriggerRepository.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcTriggerRepository.field("next_execution_date").lessThan((Object)this.toNextExecutionTime(now)).or(AbstractJdbcTriggerRepository.field("next_execution_date").isNull()).and(AbstractJdbcTriggerRepository.field("execution_id").isNotNull())).orderBy((OrderField)AbstractJdbcTriggerRepository.field("next_execution_date").asc()).fetch().map(r -> this.jdbcRepository.deserialize((String)r.get("value", String.class))));
    }

    protected Temporal toNextExecutionTime(ZonedDateTime now) {
        return now.toOffsetDateTime();
    }

    public Trigger save(Trigger trigger, ScheduleContextInterface scheduleContextInterface) {
        JdbcSchedulerContext jdbcSchedulerContext = (JdbcSchedulerContext)scheduleContextInterface;
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(trigger);
        this.jdbcRepository.persist(trigger, jdbcSchedulerContext.getContext(), fields);
        return trigger;
    }

    public Trigger save(Trigger trigger) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(trigger);
        this.jdbcRepository.persist(trigger, fields);
        return trigger;
    }

    @Override
    public Trigger save(DSLContext dslContext, Trigger trigger) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(trigger);
        this.jdbcRepository.persist(trigger, dslContext, fields);
        return trigger;
    }

    public Trigger create(Trigger trigger) {
        return (Trigger)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSL.using((Configuration)configuration).insertInto(this.jdbcRepository.getTable()).set(AbstractJdbcRepository.field("key"), (Object)this.jdbcRepository.key(trigger)).set(this.jdbcRepository.persistFields(trigger)).execute();
            return trigger;
        });
    }

    public void delete(Trigger trigger) {
        this.jdbcRepository.delete(trigger);
    }

    public Trigger update(Trigger trigger) {
        return (Trigger)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSL.using((Configuration)configuration).update(this.jdbcRepository.getTable()).set(this.jdbcRepository.persistFields(trigger)).where(AbstractJdbcTriggerRepository.field("key").eq((Object)trigger.uid())).execute();
            return trigger;
        });
    }

    public Trigger update(Flow flow, AbstractTrigger abstractTrigger, ConditionContext conditionContext) {
        return (Trigger)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            Optional<Trigger> lastTrigger = this.jdbcRepository.fetchOne(DSL.using((Configuration)configuration).select(AbstractJdbcTriggerRepository.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcTriggerRepository.field("key").eq((Object)Trigger.uid((Flow)flow, (AbstractTrigger)abstractTrigger))).forUpdate());
            Trigger updatedTrigger = Trigger.of((FlowInterface)flow, (AbstractTrigger)abstractTrigger, (ConditionContext)conditionContext, lastTrigger);
            DSL.using((Configuration)configuration).update(this.jdbcRepository.getTable()).set(this.jdbcRepository.persistFields(updatedTrigger)).where(AbstractJdbcTriggerRepository.field("key").eq((Object)updatedTrigger.uid())).execute();
            return updatedTrigger;
        });
    }

    public Trigger lock(String triggerUid, Function<Trigger, Trigger> function) {
        return (Trigger)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            Optional<Trigger> optionalTrigger = this.jdbcRepository.fetchOne(context.select(AbstractJdbcTriggerRepository.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcTriggerRepository.field("key").eq((Object)triggerUid)).forUpdate());
            if (optionalTrigger.isPresent()) {
                Trigger trigger = (Trigger)function.apply(optionalTrigger.get());
                this.save(context, trigger);
                return trigger;
            }
            return null;
        });
    }

    public ArrayListTotal<Trigger> find(Pageable pageable, String tenantId, List<QueryFilter> filters) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep<?> select = this.generateSelect(context, tenantId, filters);
            return this.jdbcRepository.fetchPage(context, select, pageable);
        });
    }

    private SelectConditionStep<?> generateSelect(DSLContext context, String tenantId, List<QueryFilter> filters) {
        SelectConditionStep select = context.select(AbstractJdbcTriggerRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
        return select.and(this.filter(filters, "next_execution_date", QueryFilter.Resource.TRIGGER));
    }

    public ArrayListTotal<Trigger> find(Pageable pageable, String query, String tenantId, String namespace, String flowId, String workerId) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select(AbstractJdbcTriggerRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.fullTextCondition(query)).and(this.defaultFilter(tenantId));
            if (namespace != null) {
                select.and(DSL.or((Condition)NAMESPACE_FIELD.eq((Object)namespace), (Condition)NAMESPACE_FIELD.likeIgnoreCase(namespace + ".%")));
            }
            if (flowId != null) {
                select.and(AbstractJdbcTriggerRepository.field("flow_id").eq((Object)flowId));
            }
            if (workerId != null) {
                select.and(AbstractJdbcTriggerRepository.field("worker_id").eq((Object)workerId));
            }
            select.and(this.defaultFilter());
            return this.jdbcRepository.fetchPage(context, select, pageable);
        });
    }

    public Flux<Trigger> find(String tenantId, List<QueryFilter> filters) {
        return Flux.create(emitter -> this.jdbcRepository.getDslContextWrapper().transaction(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep<?> select = this.generateSelect(context, tenantId, filters);
            select.fetch().map(this.jdbcRepository::map).forEach(arg_0 -> ((FluxSink)emitter).next(arg_0));
            emitter.complete();
        }), (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER);
    }

    protected Condition fullTextCondition(String query) {
        return query == null ? DSL.trueCondition() : this.jdbcRepository.fullTextCondition(List.of("fulltext"), query);
    }

    @Override
    protected Condition findQueryCondition(String query) {
        return this.fullTextCondition(query);
    }

    @Override
    protected Condition defaultFilter(String tenantId, boolean allowDeleted) {
        return this.buildTenantCondition(tenantId);
    }

    @Override
    protected Condition defaultFilter() {
        return DSL.trueCondition();
    }

    public Function<String, String> sortMapping() throws IllegalArgumentException {
        Map<String, String> mapper = Map.of("flowId", "flow_id", "triggerId", "trigger_id", "executionId", "execution_id", "nextExecutionDate", "next_execution_date");
        return s -> mapper.getOrDefault(s, (String)s);
    }

    public ArrayListTotal<Map<String, Object>> fetchData(String tenantId, DataFilter<ITriggers.Fields, ? extends ColumnDescriptor<ITriggers.Fields>> descriptors, ZonedDateTime startDate, ZonedDateTime endDate, Pageable pageable) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            Map<String, ColumnDescriptor> columnsWithoutDate = descriptors.getColumns().entrySet().stream().filter(entry -> ((ColumnDescriptor)entry.getValue()).getField() == null || !this.dateFields().contains(((ColumnDescriptor)entry.getValue()).getField())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            boolean hasAgg = descriptors.getColumns().entrySet().stream().anyMatch(col -> ((ColumnDescriptor)col.getValue()).getAgg() != null);
            List<Field<Date>> dateFields = this.generateDateFields(descriptors, this.fieldsMapping, startDate, endDate, this.dateFields(), hasAgg ? null : DateUtils.GroupType.MINUTE);
            SelectConditionStep<Record> selectConditionStep = this.select(context, this.filterService, columnsWithoutDate, dateFields, this.getFieldsMapping(), this.jdbcRepository.getTable(), tenantId);
            selectConditionStep = this.where(selectConditionStep, this.filterService, descriptors.getWhere(), this.fieldsMapping);
            List<ColumnDescriptor> columnsWithoutDateWithOutAggs = columnsWithoutDate.values().stream().filter(column -> column.getAgg() == null).toList();
            SelectHavingStep<Record> selectHavingStep = this.groupBy(selectConditionStep, columnsWithoutDateWithOutAggs, dateFields, this.fieldsMapping);
            SelectSeekStepN<Record> selectSeekStep = this.orderBy(selectHavingStep, descriptors);
            return this.fetchSeekStep(selectSeekStep, pageable);
        });
    }

    public Double fetchValue(String tenantId, DataFilterKPI<ITriggers.Fields, ? extends ColumnDescriptor<ITriggers.Fields>> dataFilter, ZonedDateTime startDate, ZonedDateTime endDate, boolean numeratorFilter) {
        return (Double)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep selectStep;
            SelectConditionStep<Record> selectConditionStep;
            Record result;
            DSLContext context = DSL.using((Configuration)configuration);
            ColumnDescriptor columnDescriptor = dataFilter.getColumns();
            String columnKey = this.getFieldsMapping().get(columnDescriptor.getField());
            Field<?> field = this.columnToField(columnDescriptor, this.getFieldsMapping());
            if (columnDescriptor.getAgg() != null) {
                field = this.filterService.buildAggregation(field, columnDescriptor.getAgg());
            }
            ArrayList filters = new ArrayList(ListUtils.emptyOnNull((List)dataFilter.getWhere()));
            if (numeratorFilter) {
                filters.addAll(dataFilter.getNumerator());
            }
            if ((result = (selectConditionStep = this.where((SelectConditionStep<Record>)(selectStep = context.select(field).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId))), this.filterService, filters, this.getFieldsMapping())).fetchOne()) != null) {
                return (Double)result.getValue(field, Double.class);
            }
            return null;
        });
    }

    @Override
    protected abstract Field<Date> formatDateField(String var1, DateUtils.GroupType var2);

    @Generated
    public Map<ITriggers.Fields, String> getFieldsMapping() {
        return this.fieldsMapping;
    }
}

