/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.runner;

import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.runners.ConcurrencyLimit;
import io.kestra.core.runners.ExecutionRunning;
import io.kestra.jdbc.AbstractJdbcRepository;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.commons.lang3.tuple.Pair;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertSetMoreStep;
import org.jooq.SQLDialect;
import org.jooq.SelectConditionStep;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;

public class AbstractJdbcConcurrencyLimitStorage
extends io.kestra.jdbc.repository.AbstractJdbcRepository {
    protected AbstractJdbcRepository<ConcurrencyLimit> jdbcRepository;

    public AbstractJdbcConcurrencyLimitStorage(AbstractJdbcRepository<ConcurrencyLimit> jdbcRepository) {
        this.jdbcRepository = jdbcRepository;
    }

    public ExecutionRunning countThenProcess(FlowInterface flow, BiFunction<DSLContext, ConcurrencyLimit, Pair<ExecutionRunning, ConcurrencyLimit>> consumer) {
        return (ExecutionRunning)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext dslContext = DSL.using((Configuration)configuration);
            ConcurrencyLimit selected = this.fetchOne(dslContext, flow).orElseGet(() -> {
                try {
                    ConcurrencyLimit zeroConcurrencyLimit = ConcurrencyLimit.builder().tenantId(flow.getTenantId()).namespace(flow.getNamespace()).flowId(flow.getId()).running(Integer.valueOf(0)).build();
                    Map<Field<Object>, Object> finalFields = this.jdbcRepository.persistFields(zeroConcurrencyLimit);
                    InsertSetMoreStep insert = dslContext.insertInto(this.jdbcRepository.getTable()).set(AbstractJdbcConcurrencyLimitStorage.field("key"), (Object)this.jdbcRepository.key(zeroConcurrencyLimit)).set(finalFields);
                    if (dslContext.configuration().dialect().supports(SQLDialect.POSTGRES)) {
                        insert.onDuplicateKeyIgnore().execute();
                    } else {
                        insert.execute();
                    }
                }
                catch (DataAccessException dataAccessException) {
                    // empty catch block
                }
                return this.fetchOne(dslContext, flow).orElseThrow();
            });
            Pair pair = (Pair)consumer.apply(dslContext, selected);
            this.update(dslContext, (ConcurrencyLimit)pair.getRight());
            return (ExecutionRunning)pair.getLeft();
        });
    }

    public void decrement(FlowInterface flow) {
        this.jdbcRepository.getDslContextWrapper().transaction(configuration -> {
            DSLContext dslContext = DSL.using((Configuration)configuration);
            this.fetchOne(dslContext, flow).ifPresent(concurrencyLimit -> this.update(dslContext, concurrencyLimit.withRunning(Integer.valueOf(concurrencyLimit.getRunning() == 0 ? 0 : concurrencyLimit.getRunning() - 1))));
        });
    }

    public void increment(DSLContext dslContext, FlowInterface flow) {
        this.fetchOne(dslContext, flow).ifPresent(concurrencyLimit -> this.update(dslContext, concurrencyLimit.withRunning(Integer.valueOf(concurrencyLimit.getRunning() + 1))));
    }

    public List<ConcurrencyLimit> find(String tenantId) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcConcurrencyLimitStorage.field("value")).from(this.jdbcRepository.getTable()).where(this.buildTenantCondition(tenantId));
            return this.jdbcRepository.fetch(select);
        });
    }

    public ConcurrencyLimit update(ConcurrencyLimit concurrencyLimit) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(concurrencyLimit);
        this.jdbcRepository.persist(concurrencyLimit, fields);
        return concurrencyLimit;
    }

    private Optional<ConcurrencyLimit> fetchOne(DSLContext dslContext, FlowInterface flow) {
        SelectConditionStep select = dslContext.select(new SelectFieldOrAsterisk[0]).from(this.jdbcRepository.getTable()).where(this.buildTenantCondition(flow.getTenantId())).and(AbstractJdbcConcurrencyLimitStorage.field("namespace").eq((Object)flow.getNamespace())).and(AbstractJdbcConcurrencyLimitStorage.field("flow_id").eq((Object)flow.getId()));
        return this.jdbcRepository.fetchOne(select.forUpdate());
    }

    private void update(DSLContext dslContext, ConcurrencyLimit concurrencyLimit) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(concurrencyLimit);
        this.jdbcRepository.persist(concurrencyLimit, dslContext, fields);
    }

    public Optional<ConcurrencyLimit> findById(String tenantId, String namespace, String flowId) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcConcurrencyLimitStorage.field("value")).from(this.jdbcRepository.getTable()).where(this.buildTenantCondition(tenantId)).and(AbstractJdbcConcurrencyLimitStorage.field("namespace").eq((Object)namespace)).and(AbstractJdbcConcurrencyLimitStorage.field("flow_id").eq((Object)flowId));
            return this.jdbcRepository.fetchOne(select);
        });
    }
}

