/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.runner;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.runners.ExecutionQueued;
import io.kestra.core.utils.IdUtils;
import io.kestra.jdbc.AbstractJdbcRepository;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.SelectForStep;
import org.jooq.SelectJoinStep;
import org.jooq.impl.DSL;

public abstract class AbstractJdbcExecutionQueuedStorage
extends io.kestra.jdbc.repository.AbstractJdbcRepository {
    protected AbstractJdbcRepository<ExecutionQueued> jdbcRepository;

    public AbstractJdbcExecutionQueuedStorage(AbstractJdbcRepository<ExecutionQueued> jdbcRepository) {
        this.jdbcRepository = jdbcRepository;
    }

    public void save(DSLContext dslContext, ExecutionQueued executionQueued) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(executionQueued);
        this.jdbcRepository.persist(executionQueued, dslContext, fields);
    }

    public void pop(String tenantId, String namespace, String flowId, BiConsumer<DSLContext, Execution> consumer) {
        this.jdbcRepository.getDslContextWrapper().transaction(configuration -> {
            DSLContext dslContext = DSL.using((Configuration)configuration);
            SelectForStep select = dslContext.select(io.kestra.jdbc.repository.AbstractJdbcRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.buildTenantCondition(tenantId)).and(AbstractJdbcExecutionQueuedStorage.field("namespace").eq((Object)namespace)).and(AbstractJdbcExecutionQueuedStorage.field("flow_id").eq((Object)flowId)).orderBy((OrderField)AbstractJdbcExecutionQueuedStorage.field("date").asc()).limit((Number)1).forUpdate().skipLocked();
            Optional<ExecutionQueued> maybeExecution = this.jdbcRepository.fetchOne(select);
            if (maybeExecution.isPresent()) {
                consumer.accept(dslContext, maybeExecution.get().getExecution());
                this.jdbcRepository.delete(maybeExecution.get());
            }
        });
    }

    public List<ExecutionQueued> getAllForAllTenants() {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectJoinStep select = DSL.using((Configuration)configuration).select(io.kestra.jdbc.repository.AbstractJdbcRepository.field("value")).from(this.jdbcRepository.getTable());
            return this.jdbcRepository.fetch(select);
        });
    }

    public void remove(Execution execution) {
        this.jdbcRepository.getDslContextWrapper().transaction(configuration -> DSL.using((Configuration)configuration).deleteFrom(this.jdbcRepository.getTable()).where(this.buildTenantCondition(execution.getTenantId())).and(AbstractJdbcExecutionQueuedStorage.field("key").eq((Object)IdUtils.fromParts((String[])new String[]{execution.getTenantId(), execution.getNamespace(), execution.getFlowId(), execution.getId()}))).execute());
    }
}

