/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.runner;

import io.kestra.core.models.flows.FlowId;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionStorageInterface;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionWindow;
import io.kestra.jdbc.AbstractJdbcRepository;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectConditionStep;
import org.jooq.impl.DSL;

public abstract class AbstractJdbcMultipleConditionStorage
extends io.kestra.jdbc.repository.AbstractJdbcRepository
implements MultipleConditionStorageInterface {
    protected AbstractJdbcRepository<MultipleConditionWindow> jdbcRepository;

    public AbstractJdbcMultipleConditionStorage(AbstractJdbcRepository<MultipleConditionWindow> jdbcRepository) {
        this.jdbcRepository = jdbcRepository;
    }

    public Optional<MultipleConditionWindow> get(FlowId flow, String conditionId) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcMultipleConditionStorage.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcMultipleConditionStorage.field("namespace").eq((Object)flow.getNamespace()).and(this.buildTenantCondition(flow.getTenantId())).and(AbstractJdbcMultipleConditionStorage.field("flow_id").eq((Object)flow.getId())).and(AbstractJdbcMultipleConditionStorage.field("condition_id").eq((Object)conditionId)));
            return this.jdbcRepository.fetchOne(select);
        });
    }

    public List<MultipleConditionWindow> expired(String tenantId) {
        Instant now = Instant.now();
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcMultipleConditionStorage.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcMultipleConditionStorage.field("end_date").lt((Object)Timestamp.from(now)).and(this.buildTenantCondition(tenantId)));
            return this.jdbcRepository.fetch(select);
        });
    }

    public synchronized void save(List<MultipleConditionWindow> multipleConditionWindows) {
        this.jdbcRepository.getDslContextWrapper().transaction(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            multipleConditionWindows.forEach(window -> {
                Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields((MultipleConditionWindow)window);
                this.jdbcRepository.persist((MultipleConditionWindow)window, context, fields);
            });
        });
    }

    public void delete(MultipleConditionWindow multipleConditionWindow) {
        this.jdbcRepository.delete(multipleConditionWindow);
    }
}

