/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.runner;

import io.kestra.core.metrics.MetricRegistry;
import io.kestra.core.repositories.FlowTopologyRepositoryInterface;
import io.kestra.jdbc.runner.JdbcQueueIndexerInterface;
import io.micronaut.context.ApplicationContext;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.jooq.DSLContext;
import org.jooq.exception.DataAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JdbcQueueIndexer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcQueueIndexer.class);
    private final Map<Class<?>, JdbcQueueIndexerInterface<?>> repositories = new HashMap();
    private final MetricRegistry metricRegistry;

    @Inject
    public JdbcQueueIndexer(ApplicationContext applicationContext) {
        applicationContext.getBeansOfType(JdbcQueueIndexerInterface.class).forEach(saveRepositoryInterface -> {
            String typeName = ((ParameterizedType)((Class)saveRepositoryInterface.getClass().getGenericSuperclass()).getGenericInterfaces()[1]).getActualTypeArguments()[0].getTypeName();
            try {
                this.repositories.put(Class.forName(typeName), (JdbcQueueIndexerInterface<?>)saveRepositoryInterface);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
        this.metricRegistry = (MetricRegistry)applicationContext.getBean(MetricRegistry.class);
    }

    public void accept(DSLContext context, Object item) {
        if (this.repositories.containsKey(item.getClass())) {
            this.metricRegistry.counter("indexer.request.count", "Total number of batches of records received by the Indexer", new String[]{"type", item.getClass().getName()}).increment();
            this.metricRegistry.counter("indexer.message.in.count", "Total number of records received by the Indexer", new String[]{"type", item.getClass().getName()}).increment();
            this.metricRegistry.timer("indexer.request.duration", "Batch of records duration inside the Indexer", new String[]{"type", item.getClass().getName()}).record(() -> {
                JdbcQueueIndexerInterface<?> jdbcIndexerInterface = this.repositories.get(item.getClass());
                if (jdbcIndexerInterface instanceof FlowTopologyRepositoryInterface) {
                    try {
                        jdbcIndexerInterface.save(context, JdbcQueueIndexer.cast(item));
                    }
                    catch (DataAccessException e) {
                        log.error("Unable to index a flow topology, skipping it", (Throwable)e);
                    }
                } else {
                    jdbcIndexerInterface.save(context, JdbcQueueIndexer.cast(item));
                }
                this.metricRegistry.counter("indexer.message.out.count", "Total number of records indexed by the Indexer", new String[]{"type", item.getClass().getName()}).increment();
            });
        }
    }

    protected static <T> T cast(Object message) {
        return (T)message;
    }
}

