/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.services;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.State;
import io.kestra.core.runners.ConcurrencyLimit;
import io.kestra.core.services.ConcurrencyLimitService;
import io.kestra.jdbc.runner.AbstractJdbcConcurrencyLimitStorage;
import io.kestra.jdbc.runner.AbstractJdbcExecutionQueuedStorage;
import io.kestra.jdbc.runner.JdbcRunnerEnabled;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Optional;

@Singleton
@JdbcRunnerEnabled
public class JdbcConcurrencyLimitService
implements ConcurrencyLimitService {
    @Inject
    private AbstractJdbcExecutionQueuedStorage executionQueuedStorage;
    @Inject
    private AbstractJdbcConcurrencyLimitStorage concurrencyLimitStorage;

    public Execution unqueue(Execution execution, State.Type state) {
        if (execution.getState().getCurrent() != State.Type.QUEUED) {
            throw new IllegalArgumentException("Only QUEUED execution can be unqueued");
        }
        this.executionQueuedStorage.remove(execution);
        State.Type type = state = state == null ? State.Type.RUNNING : state;
        if (!VALID_TARGET_STATES.contains(state)) {
            throw new IllegalArgumentException("Invalid target state: " + String.valueOf(state) + ". Valid states are: " + String.valueOf(VALID_TARGET_STATES));
        }
        return execution.withState(state);
    }

    public List<ConcurrencyLimit> find(String tenantId) {
        return this.concurrencyLimitStorage.find(tenantId);
    }

    public ConcurrencyLimit update(ConcurrencyLimit concurrencyLimit) {
        return this.concurrencyLimitStorage.update(concurrencyLimit);
    }

    public Optional<ConcurrencyLimit> findById(String tenantId, String namespace, String flowId) {
        return this.concurrencyLimitStorage.findById(tenantId, namespace, flowId);
    }
}

