/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.services;

import io.kestra.core.models.dashboards.AggregationType;
import io.kestra.core.models.dashboards.filters.AbstractFilter;
import io.kestra.core.models.dashboards.filters.Contains;
import io.kestra.core.models.dashboards.filters.EndsWith;
import io.kestra.core.models.dashboards.filters.EqualTo;
import io.kestra.core.models.dashboards.filters.GreaterThan;
import io.kestra.core.models.dashboards.filters.GreaterThanOrEqualTo;
import io.kestra.core.models.dashboards.filters.In;
import io.kestra.core.models.dashboards.filters.IsFalse;
import io.kestra.core.models.dashboards.filters.IsNotNull;
import io.kestra.core.models.dashboards.filters.IsNull;
import io.kestra.core.models.dashboards.filters.IsTrue;
import io.kestra.core.models.dashboards.filters.LessThan;
import io.kestra.core.models.dashboards.filters.LessThanOrEqualTo;
import io.kestra.core.models.dashboards.filters.NotEqualTo;
import io.kestra.core.models.dashboards.filters.NotIn;
import io.kestra.core.models.dashboards.filters.Or;
import io.kestra.core.models.dashboards.filters.Regex;
import io.kestra.core.models.dashboards.filters.StartsWith;
import io.kestra.core.services.AbstractFilterService;
import io.kestra.jdbc.repository.AbstractJdbcDashboardRepository;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Map;
import org.jooq.AggregateFunction;
import org.jooq.Condition;
import org.jooq.False;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectConditionStep;
import org.jooq.impl.DSL;

@Singleton
@Requires(bean=AbstractJdbcDashboardRepository.class)
public class JdbcFilterService
extends AbstractFilterService<SelectConditionStep<Record>> {
    public AggregateFunction<?> buildAggregation(Field<?> field, AggregationType agg) {
        return switch (agg) {
            default -> throw new MatchException(null, null);
            case AggregationType.AVG -> DSL.avg((Field)field.cast(Double.class));
            case AggregationType.MAX -> DSL.max((Field)field.cast(Double.class));
            case AggregationType.MIN -> DSL.min((Field)field.cast(Double.class));
            case AggregationType.SUM -> DSL.sum((Field)field.cast(Double.class));
            case AggregationType.COUNT -> field != null ? DSL.count(field) : DSL.count();
        };
    }

    private <F extends Enum<F>> Condition buildWhere(Map<F, String> fieldsMapping, AbstractFilter<F> filter) {
        return switch (filter.getType()) {
            default -> throw new MatchException(null, null);
            case AbstractFilter.FilterType.CONTAINS -> this.containsCondition(fieldsMapping.get(filter.getField()), (Contains)filter);
            case AbstractFilter.FilterType.ENDS_WITH -> this.endsWithCondition(fieldsMapping.get(filter.getField()), (EndsWith)filter);
            case AbstractFilter.FilterType.EQUAL_TO -> this.equalToCondition(fieldsMapping.get(filter.getField()), (EqualTo)filter);
            case AbstractFilter.FilterType.GREATER_THAN -> this.greaterThanCondition(fieldsMapping.get(filter.getField()), (GreaterThan)filter);
            case AbstractFilter.FilterType.GREATER_THAN_OR_EQUAL_TO -> this.greaterThanOrEqualToCondition(fieldsMapping.get(filter.getField()), (GreaterThanOrEqualTo)filter);
            case AbstractFilter.FilterType.IN -> this.inCondition(fieldsMapping.get(filter.getField()), (In)filter);
            case AbstractFilter.FilterType.IS_FALSE -> this.isFalseCondition(fieldsMapping.get(filter.getField()), (IsFalse)filter);
            case AbstractFilter.FilterType.IS_NOT_NULL -> this.isNotNullCondition(fieldsMapping.get(filter.getField()), (IsNotNull)filter);
            case AbstractFilter.FilterType.IS_NULL -> this.isNullCondition(fieldsMapping.get(filter.getField()), (IsNull)filter);
            case AbstractFilter.FilterType.IS_TRUE -> this.isTrueCondition(fieldsMapping.get(filter.getField()), (IsTrue)filter);
            case AbstractFilter.FilterType.LESS_THAN -> this.lessThanCondition(fieldsMapping.get(filter.getField()), (LessThan)filter);
            case AbstractFilter.FilterType.LESS_THAN_OR_EQUAL_TO -> this.lessThanOrEqualToCondition(fieldsMapping.get(filter.getField()), (LessThanOrEqualTo)filter);
            case AbstractFilter.FilterType.NOT_EQUAL_TO -> this.notEqualToCondition(fieldsMapping.get(filter.getField()), (NotEqualTo)filter);
            case AbstractFilter.FilterType.NOT_IN -> this.notInCondition(fieldsMapping.get(filter.getField()), (NotIn)filter);
            case AbstractFilter.FilterType.OR -> this.orCondition(fieldsMapping, (Or)filter);
            case AbstractFilter.FilterType.REGEX -> this.regexCondition(fieldsMapping.get(filter.getField()), (Regex)filter);
            case AbstractFilter.FilterType.STARTS_WITH -> this.startsWithCondition(fieldsMapping.get(filter.getField()), (StartsWith)filter);
        };
    }

    protected <F extends Enum<F>> SelectConditionStep<Record> contains(SelectConditionStep<Record> query, String field, Contains<F> filter) {
        return query.and(AbstractJdbcRepository.field(field).contains((Object)filter.getValue().toString()));
    }

    protected <F extends Enum<F>> SelectConditionStep<Record> endsWith(SelectConditionStep<Record> query, String field, EndsWith<F> filter) {
        return query.and(AbstractJdbcRepository.field(field).endsWith((Object)filter.getValue()));
    }

    protected <F extends Enum<F>> SelectConditionStep<Record> equalTo(SelectConditionStep<Record> query, String field, EqualTo<F> filter) {
        return query.and(AbstractJdbcRepository.field(field).eq(filter.getValue()));
    }

    protected <F extends Enum<F>> SelectConditionStep<Record> greaterThan(SelectConditionStep<Record> query, String field, GreaterThan<F> filter) {
        return query.and(AbstractJdbcRepository.field(field).gt(filter.getValue()));
    }

    protected <F extends Enum<F>> SelectConditionStep<Record> greaterThanOrEqualTo(SelectConditionStep<Record> query, String field, GreaterThanOrEqualTo<F> filter) {
        return query.and(AbstractJdbcRepository.field(field).ge(filter.getValue()));
    }

    protected <F extends Enum<F>> SelectConditionStep<Record> in(SelectConditionStep<Record> query, String field, In<F> filter) {
        return query.and(AbstractJdbcRepository.field(field).in((Collection)filter.getValues()));
    }

    protected <F extends Enum<F>> SelectConditionStep<Record> isFalse(SelectConditionStep<Record> query, String field, IsFalse<F> filter) {
        return query.and(AbstractJdbcRepository.field(field).isFalse());
    }

    protected <F extends Enum<F>> SelectConditionStep<Record> isNotNull(SelectConditionStep<Record> query, String field, IsNotNull<F> filter) {
        return query.and(AbstractJdbcRepository.field(field).isNotNull());
    }

    protected <F extends Enum<F>> SelectConditionStep<Record> isNull(SelectConditionStep<Record> query, String field, IsNull<F> filter) {
        return query.and(AbstractJdbcRepository.field(field).isNull());
    }

    protected <F extends Enum<F>> SelectConditionStep<Record> isTrue(SelectConditionStep<Record> query, String field, IsTrue<F> filter) {
        return query.and(AbstractJdbcRepository.field(field).isTrue());
    }

    protected <F extends Enum<F>> SelectConditionStep<Record> lessThan(SelectConditionStep<Record> query, String field, LessThan<F> filter) {
        return query.and(AbstractJdbcRepository.field(field).lt(filter.getValue()));
    }

    protected <F extends Enum<F>> SelectConditionStep<Record> lessThanOrEqualTo(SelectConditionStep<Record> query, String field, LessThanOrEqualTo<F> filter) {
        return query.and(AbstractJdbcRepository.field(field).le(filter.getValue()));
    }

    protected <F extends Enum<F>> SelectConditionStep<Record> notEqualTo(SelectConditionStep<Record> query, String field, NotEqualTo<F> filter) {
        return query.and(AbstractJdbcRepository.field(field).ne(filter.getValue()));
    }

    protected <F extends Enum<F>> SelectConditionStep<Record> notIn(SelectConditionStep<Record> query, String field, NotIn<F> filter) {
        return query.and(AbstractJdbcRepository.field(field).notIn((Collection)filter.getValues()));
    }

    protected <F extends Enum<F>> SelectConditionStep<Record> or(SelectConditionStep<Record> query, Map<F, String> fieldsMapping, Or<F> filter) {
        SelectConditionStep orQuery = query;
        for (AbstractFilter subFilter : filter.getValues()) {
            orQuery = orQuery.or(this.buildWhere(fieldsMapping, subFilter));
        }
        return orQuery;
    }

    protected <F extends Enum<F>> SelectConditionStep<Record> regex(SelectConditionStep<Record> query, String field, Regex<F> filter) {
        return query.and(AbstractJdbcRepository.field(field).likeRegex(filter.getValue()));
    }

    protected <F extends Enum<F>> SelectConditionStep<Record> startsWith(SelectConditionStep<Record> query, String field, StartsWith<F> filter) {
        return query.and(AbstractJdbcRepository.field(field).startsWith((Object)filter.getValue()));
    }

    private <F extends Enum<F>> Condition containsCondition(String field, Contains<F> filter) {
        return AbstractJdbcRepository.field(field).contains((Object)filter.getValue().toString());
    }

    private <F extends Enum<F>> Condition endsWithCondition(String field, EndsWith<F> filter) {
        return AbstractJdbcRepository.field(field).endsWith((Object)filter.getValue());
    }

    private <F extends Enum<F>> Condition equalToCondition(String field, EqualTo<F> filter) {
        return AbstractJdbcRepository.field(field).eq(filter.getValue());
    }

    private <F extends Enum<F>> Condition greaterThanCondition(String field, GreaterThan<F> filter) {
        return AbstractJdbcRepository.field(field).gt(filter.getValue());
    }

    private <F extends Enum<F>> Condition greaterThanOrEqualToCondition(String field, GreaterThanOrEqualTo<F> filter) {
        return AbstractJdbcRepository.field(field).ge(filter.getValue());
    }

    private <F extends Enum<F>> Condition inCondition(String field, In<F> filter) {
        return AbstractJdbcRepository.field(field).in((Collection)filter.getValues());
    }

    private <F extends Enum<F>> Condition isFalseCondition(String field, IsFalse<F> filter) {
        return AbstractJdbcRepository.field(field).isFalse();
    }

    private <F extends Enum<F>> Condition isNotNullCondition(String field, IsNotNull<F> filter) {
        return AbstractJdbcRepository.field(field).isNotNull();
    }

    private <F extends Enum<F>> Condition isNullCondition(String field, IsNull<F> filter) {
        return AbstractJdbcRepository.field(field).isNull();
    }

    private <F extends Enum<F>> Condition isTrueCondition(String field, IsTrue<F> filter) {
        return AbstractJdbcRepository.field(field).isTrue();
    }

    private <F extends Enum<F>> Condition lessThanCondition(String field, LessThan<F> filter) {
        return AbstractJdbcRepository.field(field).lt(filter.getValue());
    }

    private <F extends Enum<F>> Condition lessThanOrEqualToCondition(String field, LessThanOrEqualTo<F> filter) {
        return AbstractJdbcRepository.field(field).le(filter.getValue());
    }

    private <F extends Enum<F>> Condition notEqualToCondition(String field, NotEqualTo<F> filter) {
        return AbstractJdbcRepository.field(field).ne(filter.getValue());
    }

    private <F extends Enum<F>> Condition notInCondition(String field, NotIn<F> filter) {
        return AbstractJdbcRepository.field(field).notIn((Collection)filter.getValues());
    }

    private <F extends Enum<F>> Condition orCondition(Map<F, String> fieldsMapping, Or<F> filter) {
        False orCondition = DSL.falseCondition();
        for (AbstractFilter subFilter : filter.getValues()) {
            orCondition = orCondition.or(this.buildWhere(fieldsMapping, subFilter));
        }
        return orCondition;
    }

    private <F extends Enum<F>> Condition regexCondition(String field, Regex<F> filter) {
        return AbstractJdbcRepository.field(field).likeRegex(filter.getValue());
    }

    private <F extends Enum<F>> Condition startsWithCondition(String field, StartsWith<F> filter) {
        return AbstractJdbcRepository.field(field).startsWith((Object)filter.getValue());
    }
}

