/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models;

import io.kestra.core.models.annotations.Plugin;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface Plugin {
    @NotNull
    default public String getType() {
        return this.getClass().getCanonicalName();
    }

    public static Set<String> getAliases(Class<?> plugin) {
        io.kestra.core.models.annotations.Plugin annotation = plugin.getAnnotation(io.kestra.core.models.annotations.Plugin.class);
        return Optional.ofNullable(annotation).map(io.kestra.core.models.annotations.Plugin::aliases).stream().flatMap(Arrays::stream).collect(Collectors.toSet());
    }

    public static boolean isInternal(Class<?> plugin) {
        Objects.requireNonNull(plugin, "Cannot check if a plugin is internal from null");
        io.kestra.core.models.annotations.Plugin annotation = plugin.getAnnotation(io.kestra.core.models.annotations.Plugin.class);
        return Optional.ofNullable(annotation).map(io.kestra.core.models.annotations.Plugin::internal).orElse(false);
    }

    public static boolean isDeprecated(Class<?> plugin) {
        Objects.requireNonNull(plugin, "Cannot check if a plugin is deprecated from null");
        Deprecated annotation = plugin.getAnnotation(Deprecated.class);
        return annotation != null;
    }

    public static boolean isPrimary(Class<?> plugin) {
        Objects.requireNonNull(plugin, "Cannot check priority on null class");
        io.kestra.core.models.annotations.Plugin annotation = plugin.getAnnotation(io.kestra.core.models.annotations.Plugin.class);
        return Optional.ofNullable(annotation).map(a -> a.priority() == Plugin.Priority.PRIMARY).orElse(false);
    }

    public static Optional<String> getId(Class<?> plugin) {
        Objects.requireNonNull(plugin, "Cannot get plugin id from null");
        Plugin.Id annotation = plugin.getAnnotation(Plugin.Id.class);
        return Optional.ofNullable(annotation).map(Plugin.Id::value).map(String::toLowerCase);
    }
}

