/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.elasticsearch;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.executions.metrics.Timer;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.elasticsearch.AbstractTask;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import reactor.core.publisher.Flux;

public abstract class AbstractLoad
extends AbstractTask
implements RunnableTask<Output> {
    @Schema(title="The source file.")
    @PluginProperty(dynamic=true)
    @NotNull
    private String from;
    @Schema(title="The chunk size for every bulk request.")
    @PluginProperty(dynamic=true)
    private Integer chunk;

    protected abstract Flux<DocWriteRequest<?>> source(RunContext var1, BufferedReader var2) throws IllegalVariableEvaluationException, IOException;

    public Output run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        URI from = new URI(runContext.render(this.from));
        try (RestHighLevelClient client = this.connection.client(runContext);){
            Output output;
            try (BufferedReader inputStream = new BufferedReader(new InputStreamReader(runContext.storage().getFile(from)));){
                AtomicLong count = new AtomicLong();
                AtomicLong duration = new AtomicLong();
                Flux flowable = this.source(runContext, inputStream).doOnNext(docWriteRequest -> count.incrementAndGet()).buffer(this.chunk.intValue(), this.chunk.intValue()).map(Rethrow.throwFunction(indexRequests -> {
                    BulkRequest bulkRequest = new BulkRequest();
                    indexRequests.forEach(bulkRequest::add);
                    return client.bulk(bulkRequest, RequestOptions.DEFAULT);
                })).doOnNext(bulkItemResponse -> {
                    duration.addAndGet(bulkItemResponse.getTook().nanos());
                    if (bulkItemResponse.hasFailures()) {
                        throw new RuntimeException("Indexer failed bulk '" + bulkItemResponse.buildFailureMessage() + "'");
                    }
                });
                Long requestCount = (Long)flowable.count().block();
                runContext.metric((AbstractMetricEntry)Counter.of((String)"requests.count", (Long)requestCount, (String[])new String[0]));
                runContext.metric((AbstractMetricEntry)Counter.of((String)"records", (Long)count.get(), (String[])new String[0]));
                runContext.metric((AbstractMetricEntry)Timer.of((String)"requests.duration", (Duration)Duration.ofNanos(duration.get()), (String[])new String[0]));
                logger.info("Successfully send {} requests for {} records in {}", new Object[]{requestCount, count.get(), Duration.ofNanos(duration.get())});
                output = Output.builder().size(count.get()).build();
            }
            return output;
        }
    }

    @Generated
    private static Integer $default$chunk() {
        return 1000;
    }

    @Generated
    protected AbstractLoad(AbstractLoadBuilder<?, ?> b) {
        super(b);
        this.from = b.from;
        this.chunk = b.chunk$set ? b.chunk$value : AbstractLoad.$default$chunk();
    }

    @Override
    @Generated
    public String toString() {
        return "AbstractLoad(super=" + super.toString() + ", from=" + this.getFrom() + ", chunk=" + this.getChunk() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractLoad)) {
            return false;
        }
        AbstractLoad other = (AbstractLoad)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$chunk = this.getChunk();
        Integer other$chunk = other.getChunk();
        if (this$chunk == null ? other$chunk != null : !((Object)this$chunk).equals(other$chunk)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        return !(this$from == null ? other$from != null : !this$from.equals(other$from));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractLoad;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $chunk = this.getChunk();
        result = result * 59 + ($chunk == null ? 43 : ((Object)$chunk).hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        return result;
    }

    @Generated
    public String getFrom() {
        return this.from;
    }

    @Generated
    public Integer getChunk() {
        return this.chunk;
    }

    @Generated
    public AbstractLoad() {
        this.chunk = AbstractLoad.$default$chunk();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The size of the rows fetched.")
        private Long size;

        @ConstructorProperties(value={"size"})
        @Generated
        Output(Long size) {
            this.size = size;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Long getSize() {
            return this.size;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Long size;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder size(Long size) {
                this.size = size;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.size);
            }

            @Generated
            public String toString() {
                return "AbstractLoad.Output.OutputBuilder(size=" + this.size + ")";
            }
        }
    }

    @Generated
    public static abstract class AbstractLoadBuilder<C extends AbstractLoad, B extends AbstractLoadBuilder<C, B>>
    extends AbstractTask.AbstractTaskBuilder<C, B> {
        @Generated
        private String from;
        @Generated
        private boolean chunk$set;
        @Generated
        private Integer chunk$value;

        @Generated
        public B from(String from) {
            this.from = from;
            return (B)((Object)this.self());
        }

        @Generated
        public B chunk(Integer chunk) {
            this.chunk$value = chunk;
            this.chunk$set = true;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AbstractLoad.AbstractLoadBuilder(super=" + super.toString() + ", from=" + this.from + ", chunk$value=" + this.chunk$value + ")";
        }
    }
}

