/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.elasticsearch;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.elasticsearch.AbstractTask;
import io.kestra.plugin.elasticsearch.ElasticsearchService;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.search.builder.SearchSourceBuilder;

public abstract class AbstractSearch
extends AbstractTask {
    @Schema(title="The ElasticSearch indices.", description="Default to all indices.")
    @PluginProperty(dynamic=true)
    private List<String> indexes;
    @Schema(title="The ElasticSearch value.", description="Can be a JSON string. In this case, the contentType will be used or a raw Map.")
    @PluginProperty(dynamic=true)
    private Object request;
    @Schema(title="The content type of `value`.")
    @PluginProperty(dynamic=false)
    private XContentType contentType;

    protected SearchRequest request(RunContext runContext) throws IllegalVariableEvaluationException, IOException {
        SearchRequest request = new SearchRequest();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        try (XContentParser xContentParser = ElasticsearchService.toXContentParser(runContext, this.request, this.contentType);){
            searchSourceBuilder.parseXContent(xContentParser);
        }
        request.source(searchSourceBuilder);
        if (this.indexes != null) {
            request.indices((String[])runContext.render(this.indexes).toArray(String[]::new));
        }
        if (this.routing != null) {
            request.routing(this.routing);
        }
        return request;
    }

    @Generated
    private static XContentType $default$contentType() {
        return XContentType.JSON;
    }

    @Generated
    protected AbstractSearch(AbstractSearchBuilder<?, ?> b) {
        super(b);
        this.indexes = b.indexes;
        this.request = b.request;
        this.contentType = b.contentType$set ? b.contentType$value : AbstractSearch.$default$contentType();
    }

    @Override
    @Generated
    public String toString() {
        return "AbstractSearch(super=" + super.toString() + ", indexes=" + String.valueOf(this.getIndexes()) + ", request=" + String.valueOf(this.getRequest()) + ", contentType=" + String.valueOf(this.getContentType()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractSearch)) {
            return false;
        }
        AbstractSearch other = (AbstractSearch)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$indexes = this.getIndexes();
        List<String> other$indexes = other.getIndexes();
        if (this$indexes == null ? other$indexes != null : !((Object)this$indexes).equals(other$indexes)) {
            return false;
        }
        Object this$request = this.getRequest();
        Object other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        XContentType this$contentType = this.getContentType();
        XContentType other$contentType = other.getContentType();
        return !(this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractSearch;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $indexes = this.getIndexes();
        result = result * 59 + ($indexes == null ? 43 : ((Object)$indexes).hashCode());
        Object $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        XContentType $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        return result;
    }

    @Generated
    public List<String> getIndexes() {
        return this.indexes;
    }

    @Generated
    public Object getRequest() {
        return this.request;
    }

    @Generated
    public XContentType getContentType() {
        return this.contentType;
    }

    @Generated
    public AbstractSearch() {
        this.contentType = AbstractSearch.$default$contentType();
    }

    @Generated
    public static abstract class AbstractSearchBuilder<C extends AbstractSearch, B extends AbstractSearchBuilder<C, B>>
    extends AbstractTask.AbstractTaskBuilder<C, B> {
        @Generated
        private List<String> indexes;
        @Generated
        private Object request;
        @Generated
        private boolean contentType$set;
        @Generated
        private XContentType contentType$value;

        @Generated
        public B indexes(List<String> indexes) {
            this.indexes = indexes;
            return (B)((Object)this.self());
        }

        @Generated
        public B request(Object request) {
            this.request = request;
            return (B)((Object)this.self());
        }

        @Generated
        public B contentType(XContentType contentType) {
            this.contentType$value = contentType;
            this.contentType$set = true;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AbstractSearch.AbstractSearchBuilder(super=" + super.toString() + ", indexes=" + String.valueOf(this.indexes) + ", request=" + String.valueOf(this.request) + ", contentType$value=" + String.valueOf(this.contentType$value) + ")";
        }
    }
}

