/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.elasticsearch;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.elasticsearch.AbstractLoad;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.common.xcontent.XContentType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

@Schema(title="Bulk load documents in ElasticSearch using [bulk files](https://www.elastic.co/guide/en/elasticsearch/reference/current/docs-bulk.html) elastic files.")
@Plugin(examples={@Example(code={"connection:", "  hosts: ", "   - \"http://localhost:9200\"", "from: \"{{ inputs.file }}\""})})
public class Bulk
extends AbstractLoad
implements RunnableTask<AbstractLoad.Output> {
    @Override
    protected Flux<DocWriteRequest<?>> source(RunContext runContext, BufferedReader inputStream) throws IOException {
        return Flux.create(this.esNdJSonReader(inputStream), (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER);
    }

    public Consumer<FluxSink<DocWriteRequest<?>>> esNdJSonReader(BufferedReader input) throws IOException {
        return Rethrow.throwConsumer(s -> {
            String row;
            while ((row = input.readLine()) != null) {
                Map.Entry operation = JacksonMapper.toMap((String)row).entrySet().iterator().next();
                Map value = (Map)operation.getValue();
                ActionRequest docWriteRequest = switch ((String)operation.getKey()) {
                    case "index" -> new IndexRequest().id((String)value.get("_id")).source(input.readLine(), XContentType.JSON);
                    case "create" -> new IndexRequest().id((String)value.get("_id")).opType(DocWriteRequest.OpType.CREATE).source(input.readLine(), XContentType.JSON);
                    case "update" -> new UpdateRequest().id((String)value.get("_id")).docAsUpsert(true).doc(input.readLine(), XContentType.JSON);
                    case "delete" -> new DeleteRequest().id((String)value.get("_id"));
                    default -> throw new IllegalArgumentException("Invalid bulk request type on '" + row + "'");
                };
                if (value.containsKey("_index")) {
                    docWriteRequest.index((String)value.get("_index"));
                }
                s.next((Object)docWriteRequest);
            }
            s.complete();
        });
    }

    @Generated
    protected Bulk(BulkBuilder<?, ?> b) {
        super((AbstractLoad.AbstractLoadBuilder<?, ?>)b);
    }

    @Generated
    public static BulkBuilder<?, ?> builder() {
        return new BulkBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Bulk(super=" + super.toString() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bulk)) {
            return false;
        }
        Bulk other = (Bulk)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Bulk;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public Bulk() {
    }

    @Generated
    private static final class BulkBuilderImpl
    extends BulkBuilder<Bulk, BulkBuilderImpl> {
        @Generated
        private BulkBuilderImpl() {
        }

        @Override
        @Generated
        protected BulkBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Bulk build() {
            return new Bulk(this);
        }
    }

    @Generated
    public static abstract class BulkBuilder<C extends Bulk, B extends BulkBuilder<C, B>>
    extends AbstractLoad.AbstractLoadBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Bulk.BulkBuilder(super=" + super.toString() + ")";
        }
    }
}

