/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.elasticsearch;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.VersionProvider;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import java.util.List;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContextBuilder;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.RestHighLevelClient;

public class ElasticsearchConnection {
    @Schema(title="List of HTTP ElasticSearch servers.", description="Must be an URI like `https://elasticsearch.com:9200` with scheme and port.")
    @PluginProperty(dynamic=true)
    @NotNull
    @NotEmpty
    private List<String> hosts;
    @Schema(title="Basic auth configuration.")
    @PluginProperty(dynamic=false)
    private BasicAuth basicAuth;
    @Schema(title="List of HTTP headers to be send on every request.", description="Must be a string with key value separated with `:`, ex: `Authorization: Token XYZ`.")
    @PluginProperty(dynamic=true)
    private List<String> headers;
    @Schema(title="Sets the path's prefix for every request used by the HTTP client.", description="For example, if this is set to `/my/path`, then any client request will become `/my/path/` + endpoint.\nIn essence, every request's endpoint is prefixed by this `pathPrefix`.\nThe path prefix is useful for when ElasticSearch is behind a proxy that provides a base path or a proxy that requires all paths to start with '/'; it is not intended for other purposes and it should not be supplied in other scenarios.")
    @PluginProperty(dynamic=true)
    private String pathPrefix;
    @Schema(title="Whether the REST client should return any response containing at leas one warning header as a failure.")
    @PluginProperty(dynamic=false)
    private Boolean strictDeprecationMode;
    @Schema(title="Trust all SSL CA certificates.", description="Use this if the server is using a self signed SSL certificate.")
    @PluginProperty(dynamic=false)
    private Boolean trustAllSsl;

    RestHighLevelClient client(RunContext runContext) throws IllegalVariableEvaluationException {
        RestClientBuilder builder = RestClient.builder(this.httpHosts(runContext)).setHttpClientConfigCallback(httpClientBuilder -> {
            httpClientBuilder = this.httpAsyncClientBuilder(runContext);
            return httpClientBuilder;
        });
        if (this.getHeaders() != null) {
            builder.setDefaultHeaders(this.defaultHeaders(runContext));
        }
        if (this.getPathPrefix() != null) {
            builder.setPathPrefix(runContext.render(this.pathPrefix));
        }
        if (this.getStrictDeprecationMode() != null) {
            builder.setStrictDeprecationMode(this.getStrictDeprecationMode());
        }
        return new RestHighLevelClient(builder);
    }

    private HttpAsyncClientBuilder httpAsyncClientBuilder(RunContext runContext) {
        HttpAsyncClientBuilder builder = HttpAsyncClientBuilder.create();
        VersionProvider versionProvider = (VersionProvider)runContext.getApplicationContext().getBean(VersionProvider.class);
        builder.setUserAgent("Kestra/" + versionProvider.getVersion());
        if (this.basicAuth != null) {
            BasicCredentialsProvider basicCredential = new BasicCredentialsProvider();
            basicCredential.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(runContext.render(this.basicAuth.username), runContext.render(this.basicAuth.password)));
            builder.setDefaultCredentialsProvider(basicCredential);
        }
        if (this.trustAllSsl != null && this.trustAllSsl.booleanValue()) {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            sslContextBuilder.loadTrustMaterial(null, (chain, authType) -> true);
            SSLContext sslContext = sslContextBuilder.build();
            builder.setSSLContext(sslContext);
            builder.setSSLHostnameVerifier(new NoopHostnameVerifier());
        }
        return builder;
    }

    private HttpHost[] httpHosts(RunContext runContext) throws IllegalVariableEvaluationException {
        return (HttpHost[])runContext.render(this.hosts).stream().map(s -> {
            URI uri = URI.create(s);
            return new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        }).toArray(HttpHost[]::new);
    }

    private Header[] defaultHeaders(RunContext runContext) throws IllegalVariableEvaluationException {
        return (Header[])runContext.render(this.headers).stream().map(header -> {
            String[] nameAndValue = header.split(":");
            return new BasicHeader(nameAndValue[0], nameAndValue[1]);
        }).toArray(Header[]::new);
    }

    @Generated
    protected ElasticsearchConnection(ElasticsearchConnectionBuilder<?, ?> b) {
        this.hosts = b.hosts;
        this.basicAuth = b.basicAuth;
        this.headers = b.headers;
        this.pathPrefix = b.pathPrefix;
        this.strictDeprecationMode = b.strictDeprecationMode;
        this.trustAllSsl = b.trustAllSsl;
    }

    @Generated
    public static ElasticsearchConnectionBuilder<?, ?> builder() {
        return new ElasticsearchConnectionBuilderImpl();
    }

    @Generated
    public ElasticsearchConnection() {
    }

    @Generated
    public List<String> getHosts() {
        return this.hosts;
    }

    @Generated
    public BasicAuth getBasicAuth() {
        return this.basicAuth;
    }

    @Generated
    public List<String> getHeaders() {
        return this.headers;
    }

    @Generated
    public String getPathPrefix() {
        return this.pathPrefix;
    }

    @Generated
    public Boolean getStrictDeprecationMode() {
        return this.strictDeprecationMode;
    }

    @Generated
    public Boolean getTrustAllSsl() {
        return this.trustAllSsl;
    }

    public static class BasicAuth {
        @Schema(title="Basic auth username.")
        @PluginProperty(dynamic=true)
        private String username;
        @Schema(title="Basic auth password.")
        @PluginProperty(dynamic=true)
        private String password;

        @Generated
        protected BasicAuth(BasicAuthBuilder<?, ?> b) {
            this.username = b.username;
            this.password = b.password;
        }

        @Generated
        public static BasicAuthBuilder<?, ?> builder() {
            return new BasicAuthBuilderImpl();
        }

        @Generated
        public BasicAuth() {
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public static abstract class BasicAuthBuilder<C extends BasicAuth, B extends BasicAuthBuilder<C, B>> {
            @Generated
            private String username;
            @Generated
            private String password;

            @Generated
            public B username(String username) {
                this.username = username;
                return this.self();
            }

            @Generated
            public B password(String password) {
                this.password = password;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "ElasticsearchConnection.BasicAuth.BasicAuthBuilder(username=" + this.username + ", password=" + this.password + ")";
            }
        }

        @Generated
        private static final class BasicAuthBuilderImpl
        extends BasicAuthBuilder<BasicAuth, BasicAuthBuilderImpl> {
            @Generated
            private BasicAuthBuilderImpl() {
            }

            @Override
            @Generated
            protected BasicAuthBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public BasicAuth build() {
                return new BasicAuth(this);
            }
        }
    }

    @Generated
    public static abstract class ElasticsearchConnectionBuilder<C extends ElasticsearchConnection, B extends ElasticsearchConnectionBuilder<C, B>> {
        @Generated
        private List<String> hosts;
        @Generated
        private BasicAuth basicAuth;
        @Generated
        private List<String> headers;
        @Generated
        private String pathPrefix;
        @Generated
        private Boolean strictDeprecationMode;
        @Generated
        private Boolean trustAllSsl;

        @Generated
        public B hosts(List<String> hosts) {
            this.hosts = hosts;
            return this.self();
        }

        @Generated
        public B basicAuth(BasicAuth basicAuth) {
            this.basicAuth = basicAuth;
            return this.self();
        }

        @Generated
        public B headers(List<String> headers) {
            this.headers = headers;
            return this.self();
        }

        @Generated
        public B pathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
            return this.self();
        }

        @Generated
        public B strictDeprecationMode(Boolean strictDeprecationMode) {
            this.strictDeprecationMode = strictDeprecationMode;
            return this.self();
        }

        @Generated
        public B trustAllSsl(Boolean trustAllSsl) {
            this.trustAllSsl = trustAllSsl;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ElasticsearchConnection.ElasticsearchConnectionBuilder(hosts=" + String.valueOf(this.hosts) + ", basicAuth=" + String.valueOf(this.basicAuth) + ", headers=" + String.valueOf(this.headers) + ", pathPrefix=" + this.pathPrefix + ", strictDeprecationMode=" + this.strictDeprecationMode + ", trustAllSsl=" + this.trustAllSsl + ")";
        }
    }

    @Generated
    private static final class ElasticsearchConnectionBuilderImpl
    extends ElasticsearchConnectionBuilder<ElasticsearchConnection, ElasticsearchConnectionBuilderImpl> {
        @Generated
        private ElasticsearchConnectionBuilderImpl() {
        }

        @Override
        @Generated
        protected ElasticsearchConnectionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ElasticsearchConnection build() {
            return new ElasticsearchConnection(this);
        }
    }
}

