/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.elasticsearch;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.elasticsearch.AbstractTask;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.util.Map;
import lombok.Generated;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.slf4j.Logger;

@Schema(title="Get an ElasticSearch document.")
@Plugin(examples={@Example(code={"connection:", "  hosts: ", "   - \"http://localhost:9200\"", "index: \"my_index\"", "key: \"my_id\""})})
public class Get
extends AbstractTask
implements RunnableTask<Output> {
    @Schema(title="The ElasticSearch index.")
    @PluginProperty(dynamic=true)
    @NotNull
    private String index;
    @Schema(title="The ElasticSearch id.")
    @PluginProperty(dynamic=true)
    @NotNull
    private String key;
    @Schema(title="Sets the version", description="which will cause the get operation to only be performed if a matching version exists and no changes happened on the doc since then.")
    @PluginProperty(dynamic=false)
    @NotNull
    private Long version;

    public Output run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        try (RestHighLevelClient client = this.connection.client(runContext);){
            String index = runContext.render(this.index);
            String key = runContext.render(this.key);
            GetRequest request = new GetRequest(index, key);
            if (this.version != null) {
                request.version(this.version);
            }
            if (this.routing != null) {
                request.routing(this.routing);
            }
            if (this.routing != null) {
                request.routing(this.routing);
            }
            GetResponse response = client.get(request, RequestOptions.DEFAULT);
            logger.debug("Getting doc: {}", (Object)request);
            Output output = Output.builder().row(response.getSourceAsMap()).build();
            return output;
        }
    }

    @Generated
    protected Get(GetBuilder<?, ?> b) {
        super(b);
        this.index = b.index;
        this.key = b.key;
        this.version = b.version;
    }

    @Generated
    public static GetBuilder<?, ?> builder() {
        return new GetBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Get(super=" + super.toString() + ", index=" + this.getIndex() + ", key=" + this.getKey() + ", version=" + this.getVersion() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Get)) {
            return false;
        }
        Get other = (Get)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$index = this.getIndex();
        String other$index = other.getIndex();
        if (this$index == null ? other$index != null : !this$index.equals(other$index)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Get;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : $index.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    @Generated
    public String getIndex() {
        return this.index;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Generated
    public Get() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        private Map<String, Object> row;

        @ConstructorProperties(value={"row"})
        @Generated
        Output(Map<String, Object> row) {
            this.row = row;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Map<String, Object> getRow() {
            return this.row;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Map<String, Object> row;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder row(Map<String, Object> row) {
                this.row = row;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.row);
            }

            @Generated
            public String toString() {
                return "Get.Output.OutputBuilder(row=" + String.valueOf(this.row) + ")";
            }
        }
    }

    @Generated
    public static abstract class GetBuilder<C extends Get, B extends GetBuilder<C, B>>
    extends AbstractTask.AbstractTaskBuilder<C, B> {
        @Generated
        private String index;
        @Generated
        private String key;
        @Generated
        private Long version;

        @Generated
        public B index(String index) {
            this.index = index;
            return (B)((Object)this.self());
        }

        @Generated
        public B key(String key) {
            this.key = key;
            return (B)((Object)this.self());
        }

        @Generated
        public B version(Long version) {
            this.version = version;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Get.GetBuilder(super=" + super.toString() + ", index=" + this.index + ", key=" + this.key + ", version=" + this.version + ")";
        }
    }

    @Generated
    private static final class GetBuilderImpl
    extends GetBuilder<Get, GetBuilderImpl> {
        @Generated
        private GetBuilderImpl() {
        }

        @Override
        @Generated
        protected GetBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Get build() {
            return new Get(this);
        }
    }
}

