/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.elasticsearch;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.FileSerde;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.elasticsearch.AbstractLoad;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.io.BufferedReader;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.index.IndexRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

@Schema(title="Bulk load documents in ElasticSearch using Kestra Internal Storage file.")
@Plugin(examples={@Example(code={"connection:", "  hosts: ", "   - \"http://localhost:9200\"", "from: \"{{ inputs.file }}\"", "index: \"my_index\""})})
public class Load
extends AbstractLoad
implements RunnableTask<AbstractLoad.Output> {
    @Schema(title="The elasticsearch index.")
    @PluginProperty(dynamic=true)
    @NotNull
    private String index;
    @Schema(title="Sets the type of operation to perform.")
    @PluginProperty(dynamic=false)
    private DocWriteRequest.OpType opType;
    @Schema(title="Use this key as id.")
    @PluginProperty(dynamic=true)
    private String idKey;
    @Schema(title="Remove idKey from the final document.")
    @PluginProperty(dynamic=true)
    private Boolean removeIdKey;

    @Override
    protected Flux<DocWriteRequest<?>> source(RunContext runContext, BufferedReader inputStream) throws IllegalVariableEvaluationException {
        return Flux.create((Consumer)FileSerde.reader((BufferedReader)inputStream), (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER).map(Rethrow.throwFunction(o -> {
            Map values = (Map)o;
            IndexRequest indexRequest = new IndexRequest();
            if (this.index != null) {
                indexRequest.index(runContext.render(this.getIndex()));
            }
            if (this.opType != null) {
                indexRequest.opType(this.opType);
            }
            if (this.idKey != null) {
                String idKey = runContext.render(this.idKey);
                indexRequest.id(values.get(idKey).toString());
                if (this.removeIdKey.booleanValue()) {
                    values.remove(idKey);
                }
            }
            indexRequest.source(values);
            return indexRequest;
        }));
    }

    @Generated
    private static Boolean $default$removeIdKey() {
        return true;
    }

    @Generated
    protected Load(LoadBuilder<?, ?> b) {
        super((AbstractLoad.AbstractLoadBuilder<?, ?>)b);
        this.index = b.index;
        this.opType = b.opType;
        this.idKey = b.idKey;
        this.removeIdKey = b.removeIdKey$set ? b.removeIdKey$value : Load.$default$removeIdKey();
    }

    @Generated
    public static LoadBuilder<?, ?> builder() {
        return new LoadBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Load(super=" + super.toString() + ", index=" + this.getIndex() + ", opType=" + String.valueOf((Object)this.getOpType()) + ", idKey=" + this.getIdKey() + ", removeIdKey=" + this.getRemoveIdKey() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Load)) {
            return false;
        }
        Load other = (Load)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$removeIdKey = this.getRemoveIdKey();
        Boolean other$removeIdKey = other.getRemoveIdKey();
        if (this$removeIdKey == null ? other$removeIdKey != null : !((Object)this$removeIdKey).equals(other$removeIdKey)) {
            return false;
        }
        String this$index = this.getIndex();
        String other$index = other.getIndex();
        if (this$index == null ? other$index != null : !this$index.equals(other$index)) {
            return false;
        }
        DocWriteRequest.OpType this$opType = this.getOpType();
        DocWriteRequest.OpType other$opType = other.getOpType();
        if (this$opType == null ? other$opType != null : !((Object)((Object)this$opType)).equals((Object)other$opType)) {
            return false;
        }
        String this$idKey = this.getIdKey();
        String other$idKey = other.getIdKey();
        return !(this$idKey == null ? other$idKey != null : !this$idKey.equals(other$idKey));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Load;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $removeIdKey = this.getRemoveIdKey();
        result = result * 59 + ($removeIdKey == null ? 43 : ((Object)$removeIdKey).hashCode());
        String $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : $index.hashCode());
        DocWriteRequest.OpType $opType = this.getOpType();
        result = result * 59 + ($opType == null ? 43 : ((Object)((Object)$opType)).hashCode());
        String $idKey = this.getIdKey();
        result = result * 59 + ($idKey == null ? 43 : $idKey.hashCode());
        return result;
    }

    @Generated
    public String getIndex() {
        return this.index;
    }

    @Generated
    public DocWriteRequest.OpType getOpType() {
        return this.opType;
    }

    @Generated
    public String getIdKey() {
        return this.idKey;
    }

    @Generated
    public Boolean getRemoveIdKey() {
        return this.removeIdKey;
    }

    @Generated
    public Load() {
        this.removeIdKey = Load.$default$removeIdKey();
    }

    @Generated
    public static abstract class LoadBuilder<C extends Load, B extends LoadBuilder<C, B>>
    extends AbstractLoad.AbstractLoadBuilder<C, B> {
        @Generated
        private String index;
        @Generated
        private DocWriteRequest.OpType opType;
        @Generated
        private String idKey;
        @Generated
        private boolean removeIdKey$set;
        @Generated
        private Boolean removeIdKey$value;

        @Generated
        public B index(String index) {
            this.index = index;
            return (B)((Object)this.self());
        }

        @Generated
        public B opType(DocWriteRequest.OpType opType) {
            this.opType = opType;
            return (B)((Object)this.self());
        }

        @Generated
        public B idKey(String idKey) {
            this.idKey = idKey;
            return (B)((Object)this.self());
        }

        @Generated
        public B removeIdKey(Boolean removeIdKey) {
            this.removeIdKey$value = removeIdKey;
            this.removeIdKey$set = true;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Load.LoadBuilder(super=" + super.toString() + ", index=" + this.index + ", opType=" + String.valueOf((Object)this.opType) + ", idKey=" + this.idKey + ", removeIdKey$value=" + this.removeIdKey$value + ")";
        }
    }

    @Generated
    private static final class LoadBuilderImpl
    extends LoadBuilder<Load, LoadBuilderImpl> {
        @Generated
        private LoadBuilderImpl() {
        }

        @Override
        @Generated
        protected LoadBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Load build() {
            return new Load(this);
        }
    }
}

