/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.elasticsearch;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.elasticsearch.AbstractTask;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.util.Map;
import lombok.Generated;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.slf4j.Logger;

@Schema(title="Put an ElasticSearch document.")
@Plugin(examples={@Example(title="Put a document with a Map.", code={"connection:", "  hosts: ", "   - \"http://localhost:9200\"", "index: \"my_index\"", "key: \"my_id\"", "value:", "  name: \"John Doe\"", "  city: \"Paris\""}), @Example(title="Put a document from a JSON string.", code={"connection:", "  hosts: ", "   - \"http://localhost:9200\"", "index: \"my_index\"", "key: \"my_id\"", "value: \"{{ outputs.task_id.data | json }}\""})})
public class Put
extends AbstractTask
implements RunnableTask<Output> {
    @Schema(title="The elasticsearch index.")
    @PluginProperty(dynamic=true)
    @NotNull
    private String index;
    @Schema(title="Sets the type of operation to perform.")
    @PluginProperty(dynamic=false)
    private DocWriteRequest.OpType opType;
    @Schema(title="The elasticsearch id.")
    @PluginProperty(dynamic=true)
    private String key;
    @Schema(title="The elasticsearch value.", description="Can be a string. In this case, the contentType will be used or a raw Map.")
    @PluginProperty(dynamic=true)
    private Object value;
    @Schema(title="Should this request trigger a refresh.", description="an immediate refresh `IMMEDIATE`, wait for a refresh `WAIT_UNTIL`, or proceed ignore refreshes entirely `NONE`.")
    @PluginProperty(dynamic=false)
    private WriteRequest.RefreshPolicy refreshPolicy;
    @Schema(title="The content type of `value`.")
    @PluginProperty(dynamic=false)
    private XContentType contentType;

    public Output run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        try (RestHighLevelClient client = this.connection.client(runContext);){
            String index = runContext.render(this.index);
            String key = runContext.render(this.key);
            IndexRequest request = new IndexRequest();
            request.index(index);
            this.source(runContext, request);
            if (key != null) {
                request.id(key);
            }
            if (this.opType != null) {
                request.opType(this.opType);
            }
            if (this.refreshPolicy != null) {
                request.setRefreshPolicy(this.refreshPolicy);
            }
            if (this.routing != null) {
                request.routing(this.routing);
            }
            logger.debug("Putting doc: {}", (Object)request);
            IndexResponse response = client.index(request, RequestOptions.DEFAULT);
            Output output = Output.builder().id(response.getId()).result(response.getResult()).version(response.getVersion()).build();
            return output;
        }
    }

    private void source(RunContext runContext, IndexRequest request) throws IllegalVariableEvaluationException {
        if (this.value instanceof String) {
            request.source(runContext.render((String)this.value), this.contentType);
        } else if (this.value instanceof Map) {
            request.source(runContext.render((Map)this.value));
        } else {
            throw new IllegalVariableEvaluationException("Invalid value type '" + String.valueOf(this.value.getClass()) + "'");
        }
    }

    @Generated
    private static WriteRequest.RefreshPolicy $default$refreshPolicy() {
        return WriteRequest.RefreshPolicy.NONE;
    }

    @Generated
    private static XContentType $default$contentType() {
        return XContentType.JSON;
    }

    @Generated
    protected Put(PutBuilder<?, ?> b) {
        super(b);
        this.index = b.index;
        this.opType = b.opType;
        this.key = b.key;
        this.value = b.value;
        this.refreshPolicy = b.refreshPolicy$set ? b.refreshPolicy$value : Put.$default$refreshPolicy();
        this.contentType = b.contentType$set ? b.contentType$value : Put.$default$contentType();
    }

    @Generated
    public static PutBuilder<?, ?> builder() {
        return new PutBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Put(super=" + super.toString() + ", index=" + this.getIndex() + ", opType=" + String.valueOf((Object)this.getOpType()) + ", key=" + this.getKey() + ", value=" + String.valueOf(this.getValue()) + ", refreshPolicy=" + String.valueOf(this.getRefreshPolicy()) + ", contentType=" + String.valueOf(this.getContentType()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Put)) {
            return false;
        }
        Put other = (Put)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$index = this.getIndex();
        String other$index = other.getIndex();
        if (this$index == null ? other$index != null : !this$index.equals(other$index)) {
            return false;
        }
        DocWriteRequest.OpType this$opType = this.getOpType();
        DocWriteRequest.OpType other$opType = other.getOpType();
        if (this$opType == null ? other$opType != null : !((Object)((Object)this$opType)).equals((Object)other$opType)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        WriteRequest.RefreshPolicy this$refreshPolicy = this.getRefreshPolicy();
        WriteRequest.RefreshPolicy other$refreshPolicy = other.getRefreshPolicy();
        if (this$refreshPolicy == null ? other$refreshPolicy != null : !this$refreshPolicy.equals(other$refreshPolicy)) {
            return false;
        }
        XContentType this$contentType = this.getContentType();
        XContentType other$contentType = other.getContentType();
        return !(this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Put;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : $index.hashCode());
        DocWriteRequest.OpType $opType = this.getOpType();
        result = result * 59 + ($opType == null ? 43 : ((Object)((Object)$opType)).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        WriteRequest.RefreshPolicy $refreshPolicy = this.getRefreshPolicy();
        result = result * 59 + ($refreshPolicy == null ? 43 : $refreshPolicy.hashCode());
        XContentType $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        return result;
    }

    @Generated
    public String getIndex() {
        return this.index;
    }

    @Generated
    public DocWriteRequest.OpType getOpType() {
        return this.opType;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public Object getValue() {
        return this.value;
    }

    @Generated
    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    @Generated
    public XContentType getContentType() {
        return this.contentType;
    }

    @Generated
    public Put() {
        this.refreshPolicy = Put.$default$refreshPolicy();
        this.contentType = Put.$default$contentType();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The id of the document changed.")
        private String id;
        @Schema(title="The change that occurred to the document.")
        private DocWriteResponse.Result result;
        @Schema(title="The version of the updated document.")
        private Long version;

        @ConstructorProperties(value={"id", "result", "version"})
        @Generated
        Output(String id, DocWriteResponse.Result result, Long version) {
            this.id = id;
            this.result = result;
            this.version = version;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public DocWriteResponse.Result getResult() {
            return this.result;
        }

        @Generated
        public Long getVersion() {
            return this.version;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private String id;
            @Generated
            private DocWriteResponse.Result result;
            @Generated
            private Long version;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public OutputBuilder result(DocWriteResponse.Result result) {
                this.result = result;
                return this;
            }

            @Generated
            public OutputBuilder version(Long version) {
                this.version = version;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.id, this.result, this.version);
            }

            @Generated
            public String toString() {
                return "Put.Output.OutputBuilder(id=" + this.id + ", result=" + String.valueOf(this.result) + ", version=" + this.version + ")";
            }
        }
    }

    @Generated
    public static abstract class PutBuilder<C extends Put, B extends PutBuilder<C, B>>
    extends AbstractTask.AbstractTaskBuilder<C, B> {
        @Generated
        private String index;
        @Generated
        private DocWriteRequest.OpType opType;
        @Generated
        private String key;
        @Generated
        private Object value;
        @Generated
        private boolean refreshPolicy$set;
        @Generated
        private WriteRequest.RefreshPolicy refreshPolicy$value;
        @Generated
        private boolean contentType$set;
        @Generated
        private XContentType contentType$value;

        @Generated
        public B index(String index) {
            this.index = index;
            return (B)((Object)this.self());
        }

        @Generated
        public B opType(DocWriteRequest.OpType opType) {
            this.opType = opType;
            return (B)((Object)this.self());
        }

        @Generated
        public B key(String key) {
            this.key = key;
            return (B)((Object)this.self());
        }

        @Generated
        public B value(Object value) {
            this.value = value;
            return (B)((Object)this.self());
        }

        @Generated
        public B refreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
            this.refreshPolicy$value = refreshPolicy;
            this.refreshPolicy$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B contentType(XContentType contentType) {
            this.contentType$value = contentType;
            this.contentType$set = true;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Put.PutBuilder(super=" + super.toString() + ", index=" + this.index + ", opType=" + String.valueOf((Object)this.opType) + ", key=" + this.key + ", value=" + String.valueOf(this.value) + ", refreshPolicy$value=" + String.valueOf(this.refreshPolicy$value) + ", contentType$value=" + String.valueOf(this.contentType$value) + ")";
        }
    }

    @Generated
    private static final class PutBuilderImpl
    extends PutBuilder<Put, PutBuilderImpl> {
        @Generated
        private PutBuilderImpl() {
        }

        @Override
        @Generated
        protected PutBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Put build() {
            return new Put(this);
        }
    }
}

