/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.elasticsearch;

import com.google.common.base.Charsets;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.elasticsearch.AbstractTask;
import io.kestra.plugin.elasticsearch.ElasticsearchService;
import io.kestra.plugin.elasticsearch.model.HttpMethod;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.entity.ContentType;
import org.opensearch.client.Response;
import org.opensearch.client.RestHighLevelClient;
import org.slf4j.Logger;

@Schema(title="Send a generic ElasticSearch request.")
@Plugin(examples={@Example(title="Inserting a document in an index using POST request.", code={"connection:", "  hosts: ", "   - \"http://localhost:9200\"", "method: \"POST\"", "endpoint: \"my_index/_doc/john\"", "body:", "  name: \"john\""}), @Example(title="Searching for documents using GET request.", code={"connection:", "  hosts: ", "   - \"http://localhost:9200\"", "method: \"GET\"", "endpoint: \"my_index/_search\"", "parameters:", "  q: \"name:\\\"John Doe\\\""}), @Example(title="Deleting document using DELETE request.", code={"connection:", "  hosts: ", "   - \"http://localhost:9200\"", "method: \"DELETE\"", "endpoint: \"my_index/_doc/<_id>\""})})
public class Request
extends AbstractTask
implements RunnableTask<Output> {
    @Schema(title="The http method to use")
    @PluginProperty(dynamic=false)
    protected HttpMethod method;
    @Schema(title="The path of the request (without scheme, host, port, or prefix)")
    @PluginProperty(dynamic=true)
    protected String endpoint;
    @Schema(title="Query string parameters.")
    @PluginProperty(dynamic=true, additionalProperties=String.class)
    protected Map<String, String> parameters;
    @Schema(title="The full body", description="Can be a json string or raw Map that will be converted to json")
    @PluginProperty(dynamic=true)
    protected Object body;

    public Output run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        try (RestHighLevelClient client = this.connection.client(runContext);){
            org.opensearch.client.Request request = new org.opensearch.client.Request(this.method.name(), runContext.render(this.endpoint));
            if (this.parameters != null) {
                this.parameters.entrySet().forEach(Rethrow.throwConsumer(e -> request.addParameter(runContext.render((String)e.getKey()), runContext.render((String)e.getValue()))));
            }
            if (this.body != null) {
                request.setEntity(EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setText(ElasticsearchService.toBody(runContext, this.body)).build());
            }
            logger.debug("Starting request: {}", (Object)request);
            Response response = client.getLowLevelClient().performRequest(request);
            response.getWarnings().forEach(arg_0 -> ((Logger)logger).warn(arg_0));
            String contentType = response.getHeader("content-type");
            String content = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)Charsets.UTF_8);
            Output.OutputBuilder builder = Output.builder().status(response.getStatusLine().getStatusCode());
            builder.response = contentType.contains("application/json") ? JacksonMapper.toMap((String)content) : content;
            Output output = builder.build();
            return output;
        }
    }

    @Generated
    private static HttpMethod $default$method() {
        return HttpMethod.GET;
    }

    @Generated
    protected Request(RequestBuilder<?, ?> b) {
        super(b);
        this.method = b.method$set ? b.method$value : Request.$default$method();
        this.endpoint = b.endpoint;
        this.parameters = b.parameters;
        this.body = b.body;
    }

    @Generated
    public static RequestBuilder<?, ?> builder() {
        return new RequestBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Request(super=" + super.toString() + ", method=" + String.valueOf((Object)this.getMethod()) + ", endpoint=" + this.getEndpoint() + ", parameters=" + String.valueOf(this.getParameters()) + ", body=" + String.valueOf(this.getBody()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Request)) {
            return false;
        }
        Request other = (Request)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpMethod this$method = this.getMethod();
        HttpMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        Object this$body = this.getBody();
        Object other$body = other.getBody();
        return !(this$body == null ? other$body != null : !this$body.equals(other$body));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Request;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        HttpMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        Map<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        Object $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        return result;
    }

    @Generated
    public HttpMethod getMethod() {
        return this.method;
    }

    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public Object getBody() {
        return this.body;
    }

    @Generated
    public Request() {
        this.method = Request.$default$method();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        private Integer status;
        private Object response;

        @ConstructorProperties(value={"status", "response"})
        @Generated
        Output(Integer status, Object response) {
            this.status = status;
            this.response = response;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Integer getStatus() {
            return this.status;
        }

        @Generated
        public Object getResponse() {
            return this.response;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Integer status;
            @Generated
            private Object response;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder status(Integer status) {
                this.status = status;
                return this;
            }

            @Generated
            public OutputBuilder response(Object response) {
                this.response = response;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.status, this.response);
            }

            @Generated
            public String toString() {
                return "Request.Output.OutputBuilder(status=" + this.status + ", response=" + String.valueOf(this.response) + ")";
            }
        }
    }

    @Generated
    public static abstract class RequestBuilder<C extends Request, B extends RequestBuilder<C, B>>
    extends AbstractTask.AbstractTaskBuilder<C, B> {
        @Generated
        private boolean method$set;
        @Generated
        private HttpMethod method$value;
        @Generated
        private String endpoint;
        @Generated
        private Map<String, String> parameters;
        @Generated
        private Object body;

        @Generated
        public B method(HttpMethod method) {
            this.method$value = method;
            this.method$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B endpoint(String endpoint) {
            this.endpoint = endpoint;
            return (B)((Object)this.self());
        }

        @Generated
        public B parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return (B)((Object)this.self());
        }

        @Generated
        public B body(Object body) {
            this.body = body;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Request.RequestBuilder(super=" + super.toString() + ", method$value=" + String.valueOf((Object)this.method$value) + ", endpoint=" + this.endpoint + ", parameters=" + String.valueOf(this.parameters) + ", body=" + String.valueOf(this.body) + ")";
        }
    }

    @Generated
    private static final class RequestBuilderImpl
    extends RequestBuilder<Request, RequestBuilderImpl> {
        @Generated
        private RequestBuilderImpl() {
        }

        @Override
        @Generated
        protected RequestBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Request build() {
            return new Request(this);
        }
    }
}

