/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.elasticsearch;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.executions.metrics.Timer;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.FileSerde;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.elasticsearch.AbstractSearch;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.unit.TimeValue;
import org.slf4j.Logger;

@Schema(title="Scroll over search request.", description="Get all documents from a search request and store it as Kestra Internal Storage file.")
@Plugin(examples={@Example(code={"connection:", "  hosts: ", "   - \"http://localhost:9200\"", "indexes:", " - \"my_index\"", "request:", "  query: ", "    term:", "      name:", "        value: 'john'"})})
public class Scroll
extends AbstractSearch
implements RunnableTask<Output> {
    public Output run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        File tempFile = runContext.tempFile(".ion").toFile();
        try (RestHighLevelClient client = this.connection.client(runContext);){
            Output output;
            try (FileOutputStream output2 = new FileOutputStream(tempFile);){
                SearchRequest request = this.request(runContext);
                request.scroll(new TimeValue(60000L));
                logger.debug("Starting query: {}", (Object)request);
                AtomicLong recordsCount = new AtomicLong();
                AtomicLong requestsCount = new AtomicLong();
                AtomicLong requestsDuration = new AtomicLong();
                String scrollId = null;
                try {
                    SearchScrollRequest searchScrollRequest;
                    SearchResponse searchResponse = client.search(request, RequestOptions.DEFAULT);
                    scrollId = searchResponse.getScrollId();
                    do {
                        requestsDuration.addAndGet(searchResponse.getTook().nanos());
                        requestsCount.incrementAndGet();
                        Arrays.stream(searchResponse.getHits().getHits()).forEach(Rethrow.throwConsumer(documentFields -> {
                            recordsCount.incrementAndGet();
                            FileSerde.write((OutputStream)output2, documentFields.getSourceAsMap());
                        }));
                    } while ((searchResponse = client.scroll(searchScrollRequest = new SearchScrollRequest().scrollId(scrollId).scroll(new TimeValue(60000L)), RequestOptions.DEFAULT)).getHits().getHits().length != 0);
                    this.clearScrollId(logger, client, scrollId);
                }
                catch (IOException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        this.clearScrollId(logger, client, scrollId);
                        throw throwable;
                    }
                }
                runContext.metric((AbstractMetricEntry)Counter.of((String)"requests.count", (Long)requestsCount.get(), (String[])new String[0]));
                runContext.metric((AbstractMetricEntry)Counter.of((String)"records", (Long)recordsCount.get(), (String[])new String[0]));
                runContext.metric((AbstractMetricEntry)Timer.of((String)"requests.duration", (Duration)Duration.ofNanos(requestsDuration.get()), (String[])new String[0]));
                output = Output.builder().size(recordsCount.get()).uri(runContext.storage().putFile(tempFile)).build();
            }
            return output;
        }
    }

    private void clearScrollId(Logger logger, RestHighLevelClient client, String scrollId) {
        if (scrollId == null) {
            return;
        }
        ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
        clearScrollRequest.addScrollId(scrollId);
        try {
            client.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            logger.warn("Failed to clear scroll", (Throwable)e);
        }
    }

    @Generated
    protected Scroll(ScrollBuilder<?, ?> b) {
        super((AbstractSearch.AbstractSearchBuilder<?, ?>)b);
    }

    @Generated
    public static ScrollBuilder<?, ?> builder() {
        return new ScrollBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Scroll(super=" + super.toString() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Scroll)) {
            return false;
        }
        Scroll other = (Scroll)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Scroll;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public Scroll() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The size of the rows fetch")
        private Long size;
        @Schema(title="The uri of store result")
        private URI uri;

        @ConstructorProperties(value={"size", "uri"})
        @Generated
        Output(Long size, URI uri) {
            this.size = size;
            this.uri = uri;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Long getSize() {
            return this.size;
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Long size;
            @Generated
            private URI uri;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder size(Long size) {
                this.size = size;
                return this;
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.size, this.uri);
            }

            @Generated
            public String toString() {
                return "Scroll.Output.OutputBuilder(size=" + this.size + ", uri=" + String.valueOf(this.uri) + ")";
            }
        }
    }

    @Generated
    private static final class ScrollBuilderImpl
    extends ScrollBuilder<Scroll, ScrollBuilderImpl> {
        @Generated
        private ScrollBuilderImpl() {
        }

        @Override
        @Generated
        protected ScrollBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Scroll build() {
            return new Scroll(this);
        }
    }

    @Generated
    public static abstract class ScrollBuilder<C extends Scroll, B extends ScrollBuilder<C, B>>
    extends AbstractSearch.AbstractSearchBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Scroll.ScrollBuilder(super=" + super.toString() + ")";
        }
    }
}

