/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.elasticsearch;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.executions.metrics.Timer;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.common.FetchType;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.FileSerde;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.elasticsearch.AbstractSearch;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.slf4j.Logger;

@Schema(title="Send a search request.", description="Get all documents from a search request and store it as outputs.")
@Plugin(examples={@Example(code={"connection:", "  hosts: ", "   - \"http://localhost:9200\"", "indexes:", " - \"my_index\"", "request:", "  query: ", "    term:", "      name:", "        value: 'john'"})})
public class Search
extends AbstractSearch
implements RunnableTask<Output> {
    @Schema(title="The way you want to store the data.", description="FETCH_ONE output the first row, FETCH output all the rows, STORE store all rows in a file, NONE do nothing.")
    @PluginProperty
    private FetchType fetchType;

    public Output run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        try (RestHighLevelClient client = this.connection.client(runContext);){
            SearchRequest request = this.request(runContext);
            logger.debug("Starting query: {}", (Object)request);
            SearchResponse searchResponse = client.search(request, RequestOptions.DEFAULT);
            Output.OutputBuilder outputBuilder = Output.builder();
            switch (this.fetchType) {
                case FETCH: {
                    Pair<List<Map<String, Object>>, Integer> fetch = this.fetch(searchResponse);
                    outputBuilder.rows((List)fetch.getLeft()).size((Integer)fetch.getRight());
                    break;
                }
                case FETCH_ONE: {
                    Map<String, Object> o = this.fetchOne(searchResponse);
                    outputBuilder.row(o).size(o != null ? 1 : 0);
                    break;
                }
                case STORE: {
                    Pair<URI, Integer> store = this.store(runContext, searchResponse);
                    outputBuilder.uri((URI)store.getLeft()).size((Integer)store.getRight());
                }
            }
            runContext.metric((AbstractMetricEntry)Counter.of((String)"requests.count", (Integer)1, (String[])new String[0]));
            runContext.metric((AbstractMetricEntry)Counter.of((String)"records", (Integer)searchResponse.getHits().getHits().length, (String[])new String[0]));
            runContext.metric((AbstractMetricEntry)Timer.of((String)"requests.duration", (Duration)Duration.ofNanos(searchResponse.getTook().nanos()), (String[])new String[0]));
            Output output = outputBuilder.total(searchResponse.getHits().getTotalHits().value).build();
            return output;
        }
    }

    protected Pair<URI, Integer> store(RunContext runContext, SearchResponse searchResponse) throws IOException {
        File tempFile = runContext.tempFile(".ion").toFile();
        try (FileOutputStream output = new FileOutputStream(tempFile);){
            Arrays.stream(searchResponse.getHits().getHits()).forEach(Rethrow.throwConsumer(docs -> FileSerde.write((OutputStream)output, docs.getSourceAsMap())));
        }
        return Pair.of((Object)runContext.storage().putFile(tempFile), (Object)searchResponse.getHits().getHits().length);
    }

    protected Pair<List<Map<String, Object>>, Integer> fetch(SearchResponse searchResponse) {
        ArrayList result = new ArrayList();
        Arrays.stream(searchResponse.getHits().getHits()).forEach(Rethrow.throwConsumer(docs -> result.add(docs.getSourceAsMap())));
        return Pair.of(result, (Object)searchResponse.getHits().getHits().length);
    }

    protected Map<String, Object> fetchOne(SearchResponse searchResponse) {
        if (searchResponse.getHits().getHits().length == 0) {
            return null;
        }
        return searchResponse.getHits().getHits()[0].getSourceAsMap();
    }

    @Generated
    private static FetchType $default$fetchType() {
        return FetchType.FETCH;
    }

    @Generated
    protected Search(SearchBuilder<?, ?> b) {
        super((AbstractSearch.AbstractSearchBuilder<?, ?>)b);
        this.fetchType = b.fetchType$set ? b.fetchType$value : Search.$default$fetchType();
    }

    @Generated
    public static SearchBuilder<?, ?> builder() {
        return new SearchBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Search(super=" + super.toString() + ", fetchType=" + String.valueOf(this.getFetchType()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Search)) {
            return false;
        }
        Search other = (Search)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FetchType this$fetchType = this.getFetchType();
        FetchType other$fetchType = other.getFetchType();
        return !(this$fetchType == null ? other$fetchType != null : !this$fetchType.equals(other$fetchType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Search;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        FetchType $fetchType = this.getFetchType();
        result = result * 59 + ($fetchType == null ? 43 : $fetchType.hashCode());
        return result;
    }

    @Generated
    public FetchType getFetchType() {
        return this.fetchType;
    }

    @Generated
    public Search() {
        this.fetchType = Search.$default$fetchType();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The size of the rows fetched.")
        private Integer size;
        @Schema(title="The total of the rows fetched without pagination.")
        private Long total;
        @Schema(title="List containing the fetched data.", description="Only populated if using `fetchType=FETCH`.")
        private List<Map<String, Object>> rows;
        @Schema(title="Map containing the first row of fetched data.", description="Only populated if using `fetchType=FETCH_ONE`.")
        private Map<String, Object> row;
        @Schema(title="The URI of the stored data.", description="Only populated if using `fetchType=STORE`.")
        private URI uri;

        @ConstructorProperties(value={"size", "total", "rows", "row", "uri"})
        @Generated
        Output(Integer size, Long total, List<Map<String, Object>> rows, Map<String, Object> row, URI uri) {
            this.size = size;
            this.total = total;
            this.rows = rows;
            this.row = row;
            this.uri = uri;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Integer getSize() {
            return this.size;
        }

        @Generated
        public Long getTotal() {
            return this.total;
        }

        @Generated
        public List<Map<String, Object>> getRows() {
            return this.rows;
        }

        @Generated
        public Map<String, Object> getRow() {
            return this.row;
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Integer size;
            @Generated
            private Long total;
            @Generated
            private List<Map<String, Object>> rows;
            @Generated
            private Map<String, Object> row;
            @Generated
            private URI uri;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder size(Integer size) {
                this.size = size;
                return this;
            }

            @Generated
            public OutputBuilder total(Long total) {
                this.total = total;
                return this;
            }

            @Generated
            public OutputBuilder rows(List<Map<String, Object>> rows) {
                this.rows = rows;
                return this;
            }

            @Generated
            public OutputBuilder row(Map<String, Object> row) {
                this.row = row;
                return this;
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.size, this.total, this.rows, this.row, this.uri);
            }

            @Generated
            public String toString() {
                return "Search.Output.OutputBuilder(size=" + this.size + ", total=" + this.total + ", rows=" + String.valueOf(this.rows) + ", row=" + String.valueOf(this.row) + ", uri=" + String.valueOf(this.uri) + ")";
            }
        }
    }

    @Generated
    public static abstract class SearchBuilder<C extends Search, B extends SearchBuilder<C, B>>
    extends AbstractSearch.AbstractSearchBuilder<C, B> {
        @Generated
        private boolean fetchType$set;
        @Generated
        private FetchType fetchType$value;

        @Generated
        public B fetchType(FetchType fetchType) {
            this.fetchType$value = fetchType;
            this.fetchType$set = true;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Search.SearchBuilder(super=" + super.toString() + ", fetchType$value=" + String.valueOf(this.fetchType$value) + ")";
        }
    }

    @Generated
    private static final class SearchBuilderImpl
    extends SearchBuilder<Search, SearchBuilderImpl> {
        @Generated
        private SearchBuilderImpl() {
        }

        @Override
        @Generated
        protected SearchBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Search build() {
            return new Search(this);
        }
    }
}

