/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene80;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.FixedBitSet;

final class IndexedDISI
extends DocIdSetIterator {
    private static final int BLOCK_SIZE = 65536;
    private static final int DENSE_BLOCK_LONGS = 1024;
    public static final byte DEFAULT_DENSE_RANK_POWER = 9;
    static final int MAX_ARRAY_LENGTH = 4095;
    final IndexInput slice;
    final int jumpTableEntryCount;
    final byte denseRankPower;
    final RandomAccessInput jumpTable;
    final byte[] denseRankTable;
    final long cost;
    int block = -1;
    long blockEnd;
    long denseBitmapOffset = -1L;
    int nextBlockIndex = -1;
    Method method;
    int doc = -1;
    int index = -1;
    boolean exists;
    long word;
    int wordIndex = -1;
    int numberOfOnes;
    int denseOrigoIndex;
    int gap;

    private static void flush(int block, FixedBitSet buffer, int cardinality, byte denseRankPower, IndexOutput out) throws IOException {
        block6: {
            block5: {
                assert (block >= 0 && block < 65536);
                out.writeShort((short)block);
                assert (cardinality > 0 && cardinality <= 65536);
                out.writeShort((short)(cardinality - 1));
                if (cardinality <= 4095) break block5;
                if (cardinality == 65536) break block6;
                if (denseRankPower != -1) {
                    byte[] byArray = IndexedDISI.createRank(buffer, denseRankPower);
                    out.writeBytes(byArray, byArray.length);
                }
                for (long word : buffer.getBits()) {
                    out.writeLong(word);
                }
                break block6;
            }
            BitSetIterator bitSetIterator = new BitSetIterator(buffer, cardinality);
            int doc = bitSetIterator.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                out.writeShort((short)doc);
                doc = bitSetIterator.nextDoc();
            }
        }
    }

    private static byte[] createRank(FixedBitSet buffer, byte denseRankPower) {
        int longsPerRank = 1 << denseRankPower - 6;
        int rankMark = longsPerRank - 1;
        int rankIndexShift = denseRankPower - 7;
        byte[] rank = new byte[1024 >> rankIndexShift];
        long[] bits = buffer.getBits();
        int bitCount = 0;
        for (int word = 0; word < 1024; ++word) {
            if ((word & rankMark) == 0) {
                rank[word >> rankIndexShift] = (byte)(bitCount >> 8);
                rank[(word >> rankIndexShift) + 1] = (byte)(bitCount & 0xFF);
            }
            bitCount += Long.bitCount(bits[word]);
        }
        return rank;
    }

    static short writeBitSet(DocIdSetIterator it, IndexOutput out) throws IOException {
        return IndexedDISI.writeBitSet(it, out, (byte)9);
    }

    static short writeBitSet(DocIdSetIterator it, IndexOutput out, byte denseRankPower) throws IOException {
        long origo = out.getFilePointer();
        if ((denseRankPower < 7 || denseRankPower > 15) && denseRankPower != -1) {
            throw new IllegalArgumentException("Acceptable values for denseRankPower are 7-15 (every 128-32768 docIDs). The provided power was " + denseRankPower + " (every " + (int)Math.pow(2.0, denseRankPower) + " docIDs)");
        }
        int totalCardinality = 0;
        int blockCardinality = 0;
        FixedBitSet buffer = new FixedBitSet(65536);
        int[] jumps = new int[ArrayUtil.oversize(1, 8)];
        int prevBlock = -1;
        int jumpBlockIndex = 0;
        int doc = it.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            int block = doc >>> 16;
            if (prevBlock != -1 && block != prevBlock) {
                jumps = IndexedDISI.addJumps(jumps, out.getFilePointer() - origo, totalCardinality, jumpBlockIndex, prevBlock + 1);
                jumpBlockIndex = prevBlock + 1;
                IndexedDISI.flush(prevBlock, buffer, blockCardinality, denseRankPower, out);
                buffer.clear(0, buffer.length());
                totalCardinality += blockCardinality;
                blockCardinality = 0;
            }
            buffer.set(doc & 0xFFFF);
            ++blockCardinality;
            prevBlock = block;
            doc = it.nextDoc();
        }
        if (blockCardinality > 0) {
            jumps = IndexedDISI.addJumps(jumps, out.getFilePointer() - origo, totalCardinality, jumpBlockIndex, prevBlock + 1);
            totalCardinality += blockCardinality;
            IndexedDISI.flush(prevBlock, buffer, blockCardinality, denseRankPower, out);
            buffer.clear(0, buffer.length());
            ++prevBlock;
        }
        int lastBlock = prevBlock == -1 ? 0 : prevBlock;
        jumps = IndexedDISI.addJumps(jumps, out.getFilePointer() - origo, totalCardinality, lastBlock, lastBlock + 1);
        buffer.set(65535);
        IndexedDISI.flush(Short.MAX_VALUE, buffer, 1, denseRankPower, out);
        return IndexedDISI.flushBlockJumps(jumps, lastBlock + 1, out);
    }

    private static int[] addJumps(int[] jumps, long offset, int index, int startBlock, int endBlock) {
        assert (offset < Integer.MAX_VALUE) : "Logically the offset should not exceed 2^30 but was >= Integer.MAX_VALUE";
        jumps = ArrayUtil.grow(jumps, (endBlock + 1) * 2);
        for (int b = startBlock; b < endBlock; ++b) {
            jumps[b * 2] = index;
            jumps[b * 2 + 1] = (int)offset;
        }
        return jumps;
    }

    private static short flushBlockJumps(int[] jumps, int blockCount, IndexOutput out) throws IOException {
        if (blockCount == 2) {
            blockCount = 0;
        }
        for (int i = 0; i < blockCount; ++i) {
            out.writeInt(jumps[i * 2]);
            out.writeInt(jumps[i * 2 + 1]);
        }
        return (short)blockCount;
    }

    IndexedDISI(IndexInput in, long offset, long length, int jumpTableEntryCount, byte denseRankPower, long cost) throws IOException {
        this(IndexedDISI.createBlockSlice(in, "docs", offset, length, jumpTableEntryCount), IndexedDISI.createJumpTable(in, offset, length, jumpTableEntryCount), jumpTableEntryCount, denseRankPower, cost);
    }

    IndexedDISI(IndexInput blockSlice, RandomAccessInput jumpTable, int jumpTableEntryCount, byte denseRankPower, long cost) throws IOException {
        if ((denseRankPower < 7 || denseRankPower > 15) && denseRankPower != -1) {
            throw new IllegalArgumentException("Acceptable values for denseRankPower are 7-15 (every 128-32768 docIDs). The provided power was " + denseRankPower + " (every " + (int)Math.pow(2.0, denseRankPower) + " docIDs). ");
        }
        this.slice = blockSlice;
        this.jumpTable = jumpTable;
        this.jumpTableEntryCount = jumpTableEntryCount;
        this.denseRankPower = denseRankPower;
        int rankIndexShift = denseRankPower - 7;
        this.denseRankTable = denseRankPower == -1 ? null : new byte[1024 >> rankIndexShift];
        this.cost = cost;
    }

    public static IndexInput createBlockSlice(IndexInput slice, String sliceDescription, long offset, long length, int jumpTableEntryCount) throws IOException {
        long jumpTableBytes = jumpTableEntryCount < 0 ? 0L : (long)(jumpTableEntryCount * 4 * 2);
        return slice.slice(sliceDescription, offset, length - jumpTableBytes);
    }

    public static RandomAccessInput createJumpTable(IndexInput slice, long offset, long length, int jumpTableEntryCount) throws IOException {
        if (jumpTableEntryCount <= 0) {
            return null;
        }
        int jumpTableBytes = jumpTableEntryCount * 4 * 2;
        return slice.randomAccessSlice(offset + length - (long)jumpTableBytes, jumpTableBytes);
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int advance(int target) throws IOException {
        int targetBlock = target & 0xFFFF0000;
        if (this.block < targetBlock) {
            this.advanceBlock(targetBlock);
        }
        if (this.block == targetBlock) {
            if (this.method.advanceWithinBlock(this, target)) {
                return this.doc;
            }
            this.readBlockHeader();
        }
        boolean found = this.method.advanceWithinBlock(this, this.block);
        assert (found);
        return this.doc;
    }

    public boolean advanceExact(int target) throws IOException {
        int targetBlock = target & 0xFFFF0000;
        if (this.block < targetBlock) {
            this.advanceBlock(targetBlock);
        }
        boolean found = this.block == targetBlock && this.method.advanceExactWithinBlock(this, target);
        this.doc = target;
        return found;
    }

    private void advanceBlock(int targetBlock) throws IOException {
        int blockIndex = targetBlock >> 16;
        if (this.jumpTable != null && blockIndex >= (this.block >> 16) + 2) {
            int inRangeBlockIndex = blockIndex < this.jumpTableEntryCount ? blockIndex : this.jumpTableEntryCount - 1;
            int index = this.jumpTable.readInt((long)inRangeBlockIndex * 4L * 2L);
            int offset = this.jumpTable.readInt((long)inRangeBlockIndex * 4L * 2L + 4L);
            this.nextBlockIndex = index - 1;
            this.slice.seek(offset);
            this.readBlockHeader();
            return;
        }
        do {
            this.slice.seek(this.blockEnd);
            this.readBlockHeader();
        } while (this.block < targetBlock);
    }

    private void readBlockHeader() throws IOException {
        this.block = Short.toUnsignedInt(this.slice.readShort()) << 16;
        assert (this.block >= 0);
        int numValues = 1 + Short.toUnsignedInt(this.slice.readShort());
        this.index = this.nextBlockIndex;
        this.nextBlockIndex = this.index + numValues;
        if (numValues <= 4095) {
            this.method = Method.SPARSE;
            this.blockEnd = this.slice.getFilePointer() + (long)(numValues << 1);
        } else if (numValues == 65536) {
            this.method = Method.ALL;
            this.blockEnd = this.slice.getFilePointer();
            this.gap = this.block - this.index - 1;
        } else {
            this.method = Method.DENSE;
            this.denseBitmapOffset = this.slice.getFilePointer() + (long)(this.denseRankTable == null ? 0 : this.denseRankTable.length);
            this.blockEnd = this.denseBitmapOffset + 8192L;
            if (this.denseRankPower != -1) {
                this.slice.readBytes(this.denseRankTable, 0, this.denseRankTable.length);
            }
            this.wordIndex = -1;
            this.denseOrigoIndex = this.numberOfOnes = this.index + 1;
        }
    }

    @Override
    public int nextDoc() throws IOException {
        return this.advance(this.doc + 1);
    }

    public int index() {
        return this.index;
    }

    @Override
    public long cost() {
        return this.cost;
    }

    private static void rankSkip(IndexedDISI disi, int targetInBlock) throws IOException {
        assert (disi.denseRankPower >= 0) : disi.denseRankPower;
        int rankIndex = targetInBlock >> disi.denseRankPower;
        int rank = (disi.denseRankTable[rankIndex << 1] & 0xFF) << 8 | disi.denseRankTable[(rankIndex << 1) + 1] & 0xFF;
        int rankAlignedWordIndex = rankIndex << disi.denseRankPower >> 6;
        disi.slice.seek(disi.denseBitmapOffset + (long)rankAlignedWordIndex * 8L);
        long rankWord = disi.slice.readLong();
        int denseNOO = rank + Long.bitCount(rankWord);
        disi.wordIndex = rankAlignedWordIndex;
        disi.word = rankWord;
        disi.numberOfOnes = disi.denseOrigoIndex + denseNOO;
    }

    static enum Method {
        SPARSE{

            @Override
            boolean advanceWithinBlock(IndexedDISI disi, int target) throws IOException {
                int targetInBlock = target & 0xFFFF;
                while (disi.index < disi.nextBlockIndex) {
                    int doc = Short.toUnsignedInt(disi.slice.readShort());
                    ++disi.index;
                    if (doc < targetInBlock) continue;
                    disi.doc = disi.block | doc;
                    disi.exists = true;
                    return true;
                }
                return false;
            }

            @Override
            boolean advanceExactWithinBlock(IndexedDISI disi, int target) throws IOException {
                int targetInBlock = target & 0xFFFF;
                if (target == disi.doc) {
                    return disi.exists;
                }
                while (disi.index < disi.nextBlockIndex) {
                    int doc = Short.toUnsignedInt(disi.slice.readShort());
                    ++disi.index;
                    if (doc < targetInBlock) continue;
                    if (doc != targetInBlock) {
                        --disi.index;
                        disi.slice.seek(disi.slice.getFilePointer() - 2L);
                        break;
                    }
                    disi.exists = true;
                    return true;
                }
                disi.exists = false;
                return false;
            }
        }
        ,
        DENSE{

            @Override
            boolean advanceWithinBlock(IndexedDISI disi, int target) throws IOException {
                int targetInBlock = target & 0xFFFF;
                int targetWordIndex = targetInBlock >>> 6;
                if (disi.denseRankPower != -1 && targetWordIndex - disi.wordIndex >= 1 << disi.denseRankPower - 6) {
                    IndexedDISI.rankSkip(disi, targetInBlock);
                }
                for (int i = disi.wordIndex + 1; i <= targetWordIndex; ++i) {
                    disi.word = disi.slice.readLong();
                    disi.numberOfOnes += Long.bitCount(disi.word);
                }
                disi.wordIndex = targetWordIndex;
                long leftBits = disi.word >>> target;
                if (leftBits != 0L) {
                    disi.doc = target + Long.numberOfTrailingZeros(leftBits);
                    disi.index = disi.numberOfOnes - Long.bitCount(leftBits);
                    return true;
                }
                while (++disi.wordIndex < 1024) {
                    disi.word = disi.slice.readLong();
                    if (disi.word == 0L) continue;
                    disi.index = disi.numberOfOnes;
                    disi.numberOfOnes += Long.bitCount(disi.word);
                    disi.doc = disi.block | disi.wordIndex << 6 | Long.numberOfTrailingZeros(disi.word);
                    return true;
                }
                return false;
            }

            @Override
            boolean advanceExactWithinBlock(IndexedDISI disi, int target) throws IOException {
                int targetInBlock = target & 0xFFFF;
                int targetWordIndex = targetInBlock >>> 6;
                if (disi.denseRankPower != -1 && targetWordIndex - disi.wordIndex >= 1 << disi.denseRankPower - 6) {
                    IndexedDISI.rankSkip(disi, targetInBlock);
                }
                for (int i = disi.wordIndex + 1; i <= targetWordIndex; ++i) {
                    disi.word = disi.slice.readLong();
                    disi.numberOfOnes += Long.bitCount(disi.word);
                }
                disi.wordIndex = targetWordIndex;
                long leftBits = disi.word >>> target;
                disi.index = disi.numberOfOnes - Long.bitCount(leftBits);
                return (leftBits & 1L) != 0L;
            }
        }
        ,
        ALL{

            @Override
            boolean advanceWithinBlock(IndexedDISI disi, int target) {
                disi.doc = target;
                disi.index = target - disi.gap;
                return true;
            }

            @Override
            boolean advanceExactWithinBlock(IndexedDISI disi, int target) {
                disi.index = target - disi.gap;
                return true;
            }
        };


        abstract boolean advanceWithinBlock(IndexedDISI var1, int var2) throws IOException;

        abstract boolean advanceExactWithinBlock(IndexedDISI var1, int var2) throws IOException;
    }
}

