/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc.store;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.store.IndexOutput;

public class ByteTrackingIndexOutput
extends IndexOutput {
    private final IndexOutput output;
    private final AtomicLong byteTracker;
    private boolean closed = false;

    protected ByteTrackingIndexOutput(IndexOutput output, AtomicLong byteTracker) {
        super("Byte tracking wrapper for: " + output.getName(), "ByteTrackingIndexOutput{" + output.getName() + "}");
        this.output = output;
        this.byteTracker = byteTracker;
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.output.writeByte(b);
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        this.output.writeBytes(b, offset, length);
    }

    @Override
    public void writeShort(short i) throws IOException {
        this.output.writeShort(i);
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.output.writeInt(i);
    }

    @Override
    public void writeLong(long i) throws IOException {
        this.output.writeLong(i);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            this.output.close();
            return;
        }
        this.byteTracker.addAndGet(this.output.getFilePointer());
        this.closed = true;
        this.output.close();
    }

    @Override
    public long getFilePointer() {
        return this.output.getFilePointer();
    }

    @Override
    public long getChecksum() throws IOException {
        return this.output.getChecksum();
    }

    public String getWrappedName() {
        return this.output.getName();
    }

    public String getWrappedToString() {
        return this.output.toString();
    }
}

