/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import org.apache.lucene.spatial3d.geom.Bounds;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.LatLonBounds;
import org.apache.lucene.spatial3d.geom.Membership;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.spatial3d.geom.Vector;
import org.apache.lucene.spatial3d.geom.XYZBounds;

public class Plane
extends Vector {
    public static final GeoPoint[] NO_POINTS = new GeoPoint[0];
    public static final Membership[] NO_BOUNDS = new Membership[0];
    public static final Plane normalYPlane = new Plane(0.0, 1.0, 0.0, 0.0);
    public static final Plane normalXPlane = new Plane(1.0, 0.0, 0.0, 0.0);
    public static final Plane normalZPlane = new Plane(0.0, 0.0, 1.0, 0.0);
    public final double D;

    public Plane(double A, double B, double C2, double D) {
        super(A, B, C2);
        this.D = D;
    }

    public Plane(Vector A, double BX, double BY, double BZ) {
        super(A, BX, BY, BZ);
        this.D = 0.0;
    }

    public Plane(Vector A, Vector B) {
        super(A, B);
        this.D = 0.0;
    }

    public Plane(PlanetModel planetModel, double sinLat) {
        super(0.0, 0.0, 1.0);
        this.D = -sinLat * Plane.computeDesiredEllipsoidMagnitude(planetModel, sinLat);
    }

    public Plane(double x, double y) {
        super(y, -x, 0.0);
        this.D = 0.0;
    }

    public Plane(Vector v, double D) {
        super(v.x, v.y, v.z);
        this.D = D;
    }

    public Plane(Plane basePlane, boolean above) {
        this(basePlane.x, basePlane.y, basePlane.z, above ? Math.nextUp(basePlane.D + 1.0E-12) : Math.nextDown(basePlane.D - 1.0E-12));
    }

    public static Plane constructPerpendicularCenterPlaneOnePoint(Plane plane, Vector M) {
        double B1;
        double C1;
        double A1;
        assert (plane.evaluateIsZero(M));
        double A0 = plane.x;
        double B0 = plane.y;
        double C0 = plane.z;
        double a1Denom = C0 * M.y - B0 * M.z;
        double b1Denom = C0 * M.x - A0 * M.z;
        double c1Denom = B0 * M.x - A0 * M.y;
        if (Math.abs(a1Denom) >= Math.abs(b1Denom) && Math.abs(a1Denom) >= Math.abs(c1Denom)) {
            A1 = 1.0;
            if (Math.abs(M.y) >= Math.abs(M.z)) {
                C1 = (B0 * M.x - A0 * M.y) / a1Denom;
                B1 = (-M.x - C1 * M.z) / M.y;
            } else {
                B1 = (A0 * M.z - C0 * M.x) / a1Denom;
                C1 = (-M.x - B1 * M.y) / M.z;
            }
        } else if (Math.abs(b1Denom) >= Math.abs(a1Denom) && Math.abs(b1Denom) >= Math.abs(c1Denom)) {
            B1 = 1.0;
            if (Math.abs(M.x) >= Math.abs(M.z)) {
                C1 = (A0 * M.y - B0 * M.x) / b1Denom;
                A1 = (-M.y - C1 * M.z) / M.x;
            } else {
                A1 = (B0 * M.z - C0 * M.y) / b1Denom;
                C1 = (-M.y - A1 * M.x) / M.z;
            }
        } else if (Math.abs(c1Denom) >= Math.abs(a1Denom) && Math.abs(c1Denom) >= Math.abs(b1Denom)) {
            C1 = 1.0;
            if (Math.abs(M.x) >= Math.abs(M.y)) {
                B1 = (A0 * M.z - C0 * M.x) / c1Denom;
                A1 = (-M.z - B1 * M.y) / M.x;
            } else {
                A1 = (C0 * M.y - B0 * M.z) / c1Denom;
                B1 = (-M.z - A1 * M.x) / M.y;
            }
        } else {
            throw new IllegalArgumentException("Cannot find perpendicular plane as requested");
        }
        double normFactor = 1.0 / Math.sqrt(A1 * A1 + B1 * B1 + C1 * C1);
        Vector v = new Vector(A1 * normFactor, B1 * normFactor, C1 * normFactor);
        Plane rval = new Plane(v, -(v.x * M.x + v.y * M.y + v.z * M.z));
        return rval;
    }

    public static Plane constructPerpendicularCenterPlaneTwoPoints(Vector M, Vector N) {
        double B1;
        double C1;
        double A1;
        Plane centerPlane = new Plane(M, N);
        double A0 = centerPlane.x;
        double B0 = centerPlane.y;
        double C0 = centerPlane.z;
        double xDiff = M.x - N.x;
        double yDiff = M.y - N.y;
        double zDiff = M.z - N.z;
        if (xDiff * xDiff + yDiff * yDiff + zDiff * zDiff < 1.0E-24) {
            throw new IllegalArgumentException("Chosen points are numerically identical");
        }
        double A1choice = C0 * yDiff - B0 * zDiff;
        double B1choice = C0 * xDiff - A0 * zDiff;
        double C1choice = B0 * xDiff - A0 * yDiff;
        if (Math.abs(A1choice) >= Math.abs(B1choice) && Math.abs(A1choice) >= Math.abs(C1choice)) {
            A1 = 1.0;
            if (Math.abs(yDiff) >= Math.abs(zDiff)) {
                C1 = (B0 * xDiff - A0 * yDiff) / A1choice;
                B1 = (-C1 * zDiff - xDiff) / yDiff;
            } else {
                B1 = (A0 * zDiff - C0 * xDiff) / A1choice;
                C1 = (-B1 * yDiff - xDiff) / zDiff;
            }
        } else if (Math.abs(B1choice) >= Math.abs(A1choice) && Math.abs(B1choice) >= Math.abs(C1choice)) {
            B1 = 1.0;
            if (Math.abs(xDiff) >= Math.abs(zDiff)) {
                C1 = (A0 * yDiff - B0 * xDiff) / B1choice;
                A1 = (-C1 * zDiff - yDiff) / xDiff;
            } else {
                A1 = (B0 * zDiff - C0 * yDiff) / B1choice;
                C1 = (-A1 * xDiff - yDiff) / zDiff;
            }
        } else if (Math.abs(C1choice) >= Math.abs(A1choice) && Math.abs(C1choice) >= Math.abs(B1choice)) {
            C1 = 1.0;
            if (Math.abs(xDiff) >= Math.abs(yDiff)) {
                B1 = (A0 * zDiff - C0 * xDiff) / C1choice;
                A1 = (-B1 * yDiff - zDiff) / xDiff;
            } else {
                A1 = (C0 * yDiff - B0 * zDiff) / C1choice;
                B1 = (-A1 * xDiff - zDiff) / yDiff;
            }
        } else {
            throw new IllegalArgumentException("Equation appears to be unsolveable");
        }
        double normFactor = 1.0 / Math.sqrt(A1 * A1 + B1 * B1 + C1 * C1);
        Vector v = new Vector(A1 * normFactor, B1 * normFactor, C1 * normFactor);
        Plane rval = new Plane(v, -(v.x * M.x + v.y * M.y + v.z * M.z));
        assert (rval.evaluateIsZero(N));
        assert (Math.abs(rval.x * centerPlane.x + rval.y * centerPlane.y + rval.z * centerPlane.z) < 1.0E-12);
        return rval;
    }

    public static Plane constructNormalizedZPlane(Vector ... planePoints) {
        double bestDistance = 0.0;
        Vector bestPoint = null;
        for (Vector point : planePoints) {
            double pointDist = point.x * point.x + point.y * point.y;
            if (!(pointDist > bestDistance)) continue;
            bestDistance = pointDist;
            bestPoint = point;
        }
        return Plane.constructNormalizedZPlane(bestPoint.x, bestPoint.y);
    }

    public static Plane constructNormalizedYPlane(Vector ... planePoints) {
        double bestDistance = 0.0;
        Vector bestPoint = null;
        for (Vector point : planePoints) {
            double pointDist = point.x * point.x + point.z * point.z;
            if (!(pointDist > bestDistance)) continue;
            bestDistance = pointDist;
            bestPoint = point;
        }
        return Plane.constructNormalizedYPlane(bestPoint.x, bestPoint.z, 0.0);
    }

    public static Plane constructNormalizedXPlane(Vector ... planePoints) {
        double bestDistance = 0.0;
        Vector bestPoint = null;
        for (Vector point : planePoints) {
            double pointDist = point.y * point.y + point.z * point.z;
            if (!(pointDist > bestDistance)) continue;
            bestDistance = pointDist;
            bestPoint = point;
        }
        return Plane.constructNormalizedXPlane(bestPoint.y, bestPoint.z, 0.0);
    }

    public static Plane constructNormalizedZPlane(double x, double y) {
        if (Math.abs(x) < 1.0E-12 && Math.abs(y) < 1.0E-12) {
            return null;
        }
        double denom = 1.0 / Math.sqrt(x * x + y * y);
        return new Plane(y * denom, -x * denom, 0.0, 0.0);
    }

    public static Plane constructNormalizedYPlane(double x, double z, double DValue) {
        if (Math.abs(x) < 1.0E-12 && Math.abs(z) < 1.0E-12) {
            return null;
        }
        double denom = 1.0 / Math.sqrt(x * x + z * z);
        return new Plane(z * denom, 0.0, -x * denom, DValue);
    }

    public static Plane constructNormalizedXPlane(double y, double z, double DValue) {
        if (Math.abs(y) < 1.0E-12 && Math.abs(z) < 1.0E-12) {
            return null;
        }
        double denom = 1.0 / Math.sqrt(y * y + z * z);
        return new Plane(0.0, z * denom, -y * denom, DValue);
    }

    public double evaluate(Vector v) {
        return this.dotProduct(v) + this.D;
    }

    public double evaluate(double x, double y, double z) {
        return this.dotProduct(x, y, z) + this.D;
    }

    public boolean evaluateIsZero(Vector v) {
        return Math.abs(this.evaluate(v)) < 1.0E-12;
    }

    public boolean evaluateIsZero(double x, double y, double z) {
        return Math.abs(this.evaluate(x, y, z)) < 1.0E-12;
    }

    @Override
    public Plane normalize() {
        Vector normVect = super.normalize();
        if (normVect == null) {
            return null;
        }
        return new Plane(normVect, this.D);
    }

    public double arcDistance(PlanetModel planetModel, GeoPoint v, Membership ... bounds) {
        return this.arcDistance(planetModel, v.x, v.y, v.z, bounds);
    }

    public double arcDistance(PlanetModel planetModel, double x, double y, double z, Membership ... bounds) {
        if (this.evaluateIsZero(x, y, z)) {
            if (Plane.meetsAllBounds(x, y, z, bounds)) {
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }
        Plane perpPlane = new Plane(this.y * z - this.z * y, this.z * x - this.x * z, this.x * y - this.y * x, 0.0);
        GeoPoint[] intersectionPoints = this.findIntersections(planetModel, perpPlane, new Membership[0]);
        double minDistance = Double.POSITIVE_INFINITY;
        for (GeoPoint intersectionPoint : intersectionPoints) {
            double theDistance;
            if (!Plane.meetsAllBounds(intersectionPoint, bounds) || !((theDistance = intersectionPoint.arcDistance(x, y, z)) < minDistance)) continue;
            minDistance = theDistance;
        }
        return minDistance;
    }

    public double normalDistance(Vector v, Membership ... bounds) {
        return this.normalDistance(v.x, v.y, v.z, bounds);
    }

    public double normalDistance(double x, double y, double z, Membership ... bounds) {
        double perpZ;
        double perpY;
        double dist = this.evaluate(x, y, z);
        double perpX = x - dist * this.x;
        if (!Plane.meetsAllBounds(perpX, perpY = y - dist * this.y, perpZ = z - dist * this.z, bounds)) {
            return Double.POSITIVE_INFINITY;
        }
        return Math.abs(dist);
    }

    public double normalDistanceSquared(Vector v, Membership ... bounds) {
        return this.normalDistanceSquared(v.x, v.y, v.z, bounds);
    }

    public double normalDistanceSquared(double x, double y, double z, Membership ... bounds) {
        double normal = this.normalDistance(x, y, z, bounds);
        if (normal == Double.POSITIVE_INFINITY) {
            return normal;
        }
        return normal * normal;
    }

    public double linearDistance(PlanetModel planetModel, GeoPoint v, Membership ... bounds) {
        return this.linearDistance(planetModel, v.x, v.y, v.z, bounds);
    }

    public double linearDistance(PlanetModel planetModel, double x, double y, double z, Membership ... bounds) {
        if (this.evaluateIsZero(x, y, z)) {
            if (Plane.meetsAllBounds(x, y, z, bounds)) {
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }
        Plane perpPlane = new Plane(this.y * z - this.z * y, this.z * x - this.x * z, this.x * y - this.y * x, 0.0);
        GeoPoint[] intersectionPoints = this.findIntersections(planetModel, perpPlane, new Membership[0]);
        double minDistance = Double.POSITIVE_INFINITY;
        for (GeoPoint intersectionPoint : intersectionPoints) {
            double theDistance;
            if (!Plane.meetsAllBounds(intersectionPoint, bounds) || !((theDistance = intersectionPoint.linearDistance(x, y, z)) < minDistance)) continue;
            minDistance = theDistance;
        }
        return minDistance;
    }

    public double linearDistanceSquared(PlanetModel planetModel, GeoPoint v, Membership ... bounds) {
        return this.linearDistanceSquared(planetModel, v.x, v.y, v.z, bounds);
    }

    public double linearDistanceSquared(PlanetModel planetModel, double x, double y, double z, Membership ... bounds) {
        double linearDistance = this.linearDistance(planetModel, x, y, z, bounds);
        return linearDistance * linearDistance;
    }

    public GeoPoint[] interpolate(PlanetModel planetModel, GeoPoint start, GeoPoint end, double[] proportions) {
        double delta;
        double newEndAngle;
        double cosHA;
        double sinHA;
        double sinRA;
        double cosRA;
        double A = this.x;
        double B = this.y;
        double C2 = this.z;
        double transX = -this.D * A;
        double transY = -this.D * B;
        double transZ = -this.D * C2;
        double magnitude = this.magnitude();
        if (magnitude >= 1.0E-12) {
            double denom = 1.0 / magnitude;
            A *= denom;
            B *= denom;
            C2 *= denom;
            double xyMagnitude = Math.sqrt(A * A + B * B);
            if (xyMagnitude >= 1.0E-12) {
                double xyDenom = 1.0 / xyMagnitude;
                cosRA = A * xyDenom;
                sinRA = -B * xyDenom;
            } else {
                cosRA = 1.0;
                sinRA = 0.0;
            }
            sinHA = xyMagnitude;
            cosHA = C2;
        } else {
            cosRA = 1.0;
            sinRA = 0.0;
            cosHA = 1.0;
            sinHA = 0.0;
        }
        Vector modifiedStart = Plane.modify(start, transX, transY, transZ, sinRA, cosRA, sinHA, cosHA);
        Vector modifiedEnd = Plane.modify(end, transX, transY, transZ, sinRA, cosRA, sinHA, cosHA);
        if (Math.abs(modifiedStart.z) >= 1.0E-12) {
            throw new IllegalArgumentException("Start point was not on plane: " + modifiedStart.z);
        }
        if (Math.abs(modifiedEnd.z) >= 1.0E-12) {
            throw new IllegalArgumentException("End point was not on plane: " + modifiedEnd.z);
        }
        double startAngle = Math.atan2(modifiedStart.y, modifiedStart.x);
        double endAngle = Math.atan2(modifiedEnd.y, modifiedEnd.x);
        double startMagnitude = Math.sqrt(modifiedStart.x * modifiedStart.x + modifiedStart.y * modifiedStart.y);
        for (newEndAngle = endAngle; newEndAngle < startAngle; newEndAngle += Math.PI * 2) {
        }
        if (newEndAngle - startAngle <= Math.PI) {
            delta = newEndAngle - startAngle;
        } else {
            double newStartAngle;
            for (newStartAngle = startAngle; newStartAngle < endAngle; newStartAngle += Math.PI * 2) {
            }
            delta = newStartAngle - endAngle;
        }
        GeoPoint[] returnValues = new GeoPoint[proportions.length];
        for (int i = 0; i < returnValues.length; ++i) {
            double newAngle = startAngle + proportions[i] * delta;
            double sinNewAngle = Math.sin(newAngle);
            double cosNewAngle = Math.cos(newAngle);
            Vector newVector = new Vector(cosNewAngle * startMagnitude, sinNewAngle * startMagnitude, 0.0);
            returnValues[i] = Plane.reverseModify(planetModel, newVector, transX, transY, transZ, sinRA, cosRA, sinHA, cosHA);
        }
        return returnValues;
    }

    protected static Vector modify(GeoPoint start, double transX, double transY, double transZ, double sinRA, double cosRA, double sinHA, double cosHA) {
        return start.translate(transX, transY, transZ).rotateXY(sinRA, cosRA).rotateXZ(sinHA, cosHA);
    }

    protected static GeoPoint reverseModify(PlanetModel planetModel, Vector point, double transX, double transY, double transZ, double sinRA, double cosRA, double sinHA, double cosHA) {
        Vector result = point.rotateXZ(-sinHA, cosHA).rotateXY(-sinRA, cosRA).translate(-transX, -transY, -transZ);
        return planetModel.createSurfacePoint(result.x, result.y, result.z);
    }

    public GeoPoint[] findIntersections(PlanetModel planetModel, Plane q, Membership ... bounds) {
        if (this.isNumericallyIdentical(q)) {
            return null;
        }
        return this.findIntersections(planetModel, q, bounds, NO_BOUNDS);
    }

    public GeoPoint[] findCrossings(PlanetModel planetModel, Plane q, Membership ... bounds) {
        if (this.isNumericallyIdentical(q)) {
            return null;
        }
        return this.findCrossings(planetModel, q, bounds, NO_BOUNDS);
    }

    public static boolean arePointsCoplanar(GeoPoint A, GeoPoint B, GeoPoint C2) {
        return Vector.crossProductEvaluateIsZero(A, B, C2) || Vector.crossProductEvaluateIsZero(A, C2, B) || Vector.crossProductEvaluateIsZero(B, C2, A);
    }

    protected GeoPoint[] findIntersections(PlanetModel planetModel, Plane q, Membership[] bounds, Membership[] moreBounds) {
        double z0;
        double y0;
        double x0;
        double denom;
        double lineVectorX = this.y * q.z - this.z * q.y;
        double lineVectorY = this.z * q.x - this.x * q.z;
        double lineVectorZ = this.x * q.y - this.y * q.x;
        if (Math.abs(lineVectorX) < 1.0E-12 && Math.abs(lineVectorY) < 1.0E-12 && Math.abs(lineVectorZ) < 1.0E-12) {
            return NO_POINTS;
        }
        double denomYZ = this.y * q.z - this.z * q.y;
        double denomXZ = this.x * q.z - this.z * q.x;
        double denomXY = this.x * q.y - this.y * q.x;
        if (Math.abs(denomYZ) >= Math.abs(denomXZ) && Math.abs(denomYZ) >= Math.abs(denomXY)) {
            if (Math.abs(denomYZ) < 1.0E-24) {
                return NO_POINTS;
            }
            denom = 1.0 / denomYZ;
            x0 = 0.0;
            y0 = (-this.D * q.z - this.z * -q.D) * denom;
            z0 = (this.y * -q.D + this.D * q.y) * denom;
        } else if (Math.abs(denomXZ) >= Math.abs(denomXY) && Math.abs(denomXZ) >= Math.abs(denomYZ)) {
            if (Math.abs(denomXZ) < 1.0E-24) {
                return NO_POINTS;
            }
            denom = 1.0 / denomXZ;
            x0 = (-this.D * q.z - this.z * -q.D) * denom;
            y0 = 0.0;
            z0 = (this.x * -q.D + this.D * q.x) * denom;
        } else {
            if (Math.abs(denomXY) < 1.0E-24) {
                return NO_POINTS;
            }
            denom = 1.0 / denomXY;
            x0 = (-this.D * q.y - this.y * -q.D) * denom;
            y0 = (this.x * -q.D + this.D * q.x) * denom;
            z0 = 0.0;
        }
        double A = lineVectorX * lineVectorX * planetModel.inverseXYScalingSquared + lineVectorY * lineVectorY * planetModel.inverseXYScalingSquared + lineVectorZ * lineVectorZ * planetModel.inverseZScalingSquared;
        double B = 2.0 * (lineVectorX * x0 * planetModel.inverseXYScalingSquared + lineVectorY * y0 * planetModel.inverseXYScalingSquared + lineVectorZ * z0 * planetModel.inverseZScalingSquared);
        double C2 = x0 * x0 * planetModel.inverseXYScalingSquared + y0 * y0 * planetModel.inverseXYScalingSquared + z0 * z0 * planetModel.inverseZScalingSquared - 1.0;
        double BsquaredMinus = B * B - 4.0 * A * C2;
        if (Math.abs(BsquaredMinus) < 1.0E-24) {
            double inverse2A = 1.0 / (2.0 * A);
            double t = -B * inverse2A;
            double pointX = lineVectorX * t + x0;
            double pointY = lineVectorY * t + y0;
            double pointZ = lineVectorZ * t + z0;
            for (Membership bound : bounds) {
                if (bound.isWithin(pointX, pointY, pointZ)) continue;
                return NO_POINTS;
            }
            for (Membership bound : moreBounds) {
                if (bound.isWithin(pointX, pointY, pointZ)) continue;
                return NO_POINTS;
            }
            return new GeoPoint[]{new GeoPoint(pointX, pointY, pointZ)};
        }
        if (BsquaredMinus > 0.0) {
            double inverse2A = 1.0 / (2.0 * A);
            double sqrtTerm = Math.sqrt(BsquaredMinus);
            double t1 = (-B + sqrtTerm) * inverse2A;
            double t2 = (-B - sqrtTerm) * inverse2A;
            double point1X = lineVectorX * t1 + x0;
            double point1Y = lineVectorY * t1 + y0;
            double point1Z = lineVectorZ * t1 + z0;
            double point2X = lineVectorX * t2 + x0;
            double point2Y = lineVectorY * t2 + y0;
            double point2Z = lineVectorZ * t2 + z0;
            boolean point1Valid = true;
            boolean point2Valid = true;
            for (Membership bound : bounds) {
                if (bound.isWithin(point1X, point1Y, point1Z)) continue;
                point1Valid = false;
                break;
            }
            if (point1Valid) {
                for (Membership bound : moreBounds) {
                    if (bound.isWithin(point1X, point1Y, point1Z)) continue;
                    point1Valid = false;
                    break;
                }
            }
            for (Membership bound : bounds) {
                if (bound.isWithin(point2X, point2Y, point2Z)) continue;
                point2Valid = false;
                break;
            }
            if (point2Valid) {
                for (Membership bound : moreBounds) {
                    if (bound.isWithin(point2X, point2Y, point2Z)) continue;
                    point2Valid = false;
                    break;
                }
            }
            if (point1Valid && point2Valid) {
                return new GeoPoint[]{new GeoPoint(point1X, point1Y, point1Z), new GeoPoint(point2X, point2Y, point2Z)};
            }
            if (point1Valid) {
                return new GeoPoint[]{new GeoPoint(point1X, point1Y, point1Z)};
            }
            if (point2Valid) {
                return new GeoPoint[]{new GeoPoint(point2X, point2Y, point2Z)};
            }
            return NO_POINTS;
        }
        return NO_POINTS;
    }

    protected GeoPoint[] findCrossings(PlanetModel planetModel, Plane q, Membership[] bounds, Membership[] moreBounds) {
        double z0;
        double y0;
        double x0;
        double denom;
        double lineVectorX = this.y * q.z - this.z * q.y;
        double lineVectorY = this.z * q.x - this.x * q.z;
        double lineVectorZ = this.x * q.y - this.y * q.x;
        if (Math.abs(lineVectorX) < 1.0E-12 && Math.abs(lineVectorY) < 1.0E-12 && Math.abs(lineVectorZ) < 1.0E-12) {
            return NO_POINTS;
        }
        double denomYZ = this.y * q.z - this.z * q.y;
        double denomXZ = this.x * q.z - this.z * q.x;
        double denomXY = this.x * q.y - this.y * q.x;
        if (Math.abs(denomYZ) >= Math.abs(denomXZ) && Math.abs(denomYZ) >= Math.abs(denomXY)) {
            if (Math.abs(denomYZ) < 1.0E-24) {
                return NO_POINTS;
            }
            denom = 1.0 / denomYZ;
            x0 = 0.0;
            y0 = (-this.D * q.z - this.z * -q.D) * denom;
            z0 = (this.y * -q.D + this.D * q.y) * denom;
        } else if (Math.abs(denomXZ) >= Math.abs(denomXY) && Math.abs(denomXZ) >= Math.abs(denomYZ)) {
            if (Math.abs(denomXZ) < 1.0E-24) {
                return NO_POINTS;
            }
            denom = 1.0 / denomXZ;
            x0 = (-this.D * q.z - this.z * -q.D) * denom;
            y0 = 0.0;
            z0 = (this.x * -q.D + this.D * q.x) * denom;
        } else {
            if (Math.abs(denomXY) < 1.0E-24) {
                return NO_POINTS;
            }
            denom = 1.0 / denomXY;
            x0 = (-this.D * q.y - this.y * -q.D) * denom;
            y0 = (this.x * -q.D + this.D * q.x) * denom;
            z0 = 0.0;
        }
        double A = lineVectorX * lineVectorX * planetModel.inverseXYScalingSquared + lineVectorY * lineVectorY * planetModel.inverseXYScalingSquared + lineVectorZ * lineVectorZ * planetModel.inverseZScalingSquared;
        double B = 2.0 * (lineVectorX * x0 * planetModel.inverseXYScalingSquared + lineVectorY * y0 * planetModel.inverseXYScalingSquared + lineVectorZ * z0 * planetModel.inverseZScalingSquared);
        double C2 = x0 * x0 * planetModel.inverseXYScalingSquared + y0 * y0 * planetModel.inverseXYScalingSquared + z0 * z0 * planetModel.inverseZScalingSquared - 1.0;
        double BsquaredMinus = B * B - 4.0 * A * C2;
        if (Math.abs(BsquaredMinus) < 1.0E-24) {
            return NO_POINTS;
        }
        if (BsquaredMinus > 0.0) {
            double inverse2A = 1.0 / (2.0 * A);
            double sqrtTerm = Math.sqrt(BsquaredMinus);
            double t1 = (-B + sqrtTerm) * inverse2A;
            double t2 = (-B - sqrtTerm) * inverse2A;
            double point1X = lineVectorX * t1 + x0;
            double point1Y = lineVectorY * t1 + y0;
            double point1Z = lineVectorZ * t1 + z0;
            double point2X = lineVectorX * t2 + x0;
            double point2Y = lineVectorY * t2 + y0;
            double point2Z = lineVectorZ * t2 + z0;
            boolean point1Valid = true;
            boolean point2Valid = true;
            for (Membership bound : bounds) {
                if (bound.isWithin(point1X, point1Y, point1Z)) continue;
                point1Valid = false;
                break;
            }
            if (point1Valid) {
                for (Membership bound : moreBounds) {
                    if (bound.isWithin(point1X, point1Y, point1Z)) continue;
                    point1Valid = false;
                    break;
                }
            }
            for (Membership bound : bounds) {
                if (bound.isWithin(point2X, point2Y, point2Z)) continue;
                point2Valid = false;
                break;
            }
            if (point2Valid) {
                for (Membership bound : moreBounds) {
                    if (bound.isWithin(point2X, point2Y, point2Z)) continue;
                    point2Valid = false;
                    break;
                }
            }
            if (point1Valid && point2Valid) {
                return new GeoPoint[]{new GeoPoint(point1X, point1Y, point1Z), new GeoPoint(point2X, point2Y, point2Z)};
            }
            if (point1Valid) {
                return new GeoPoint[]{new GeoPoint(point1X, point1Y, point1Z)};
            }
            if (point2Valid) {
                return new GeoPoint[]{new GeoPoint(point2X, point2Y, point2Z)};
            }
            return NO_POINTS;
        }
        return NO_POINTS;
    }

    protected void findIntersectionBounds(PlanetModel planetModel, Bounds boundsInfo, Plane q, Membership ... bounds) {
        double lineVectorX = this.y * q.z - this.z * q.y;
        double lineVectorY = this.z * q.x - this.x * q.z;
        double lineVectorZ = this.x * q.y - this.y * q.x;
        if (Math.abs(lineVectorX) < 1.0E-12 && Math.abs(lineVectorY) < 1.0E-12 && Math.abs(lineVectorZ) < 1.0E-12) {
            return;
        }
        double denomYZ = this.y * q.z - this.z * q.y;
        double denomXZ = this.x * q.z - this.z * q.x;
        double denomXY = this.x * q.y - this.y * q.x;
        if (Math.abs(denomYZ) >= Math.abs(denomXZ) && Math.abs(denomYZ) >= Math.abs(denomXY)) {
            if (Math.abs(denomYZ) < 1.0E-24) {
                return;
            }
            double denom = 1.0 / denomYZ;
            Plane.recordLineBounds(planetModel, boundsInfo, lineVectorX, lineVectorY, lineVectorZ, 0.0, (-(this.D + 1.0E-12) * q.z - this.z * -(q.D + 1.0E-12)) * denom, (this.y * -(q.D + 1.0E-12) + (this.D + 1.0E-12) * q.y) * denom, bounds);
            Plane.recordLineBounds(planetModel, boundsInfo, lineVectorX, lineVectorY, lineVectorZ, 0.0, (-(this.D - 1.0E-12) * q.z - this.z * -(q.D + 1.0E-12)) * denom, (this.y * -(q.D + 1.0E-12) + (this.D - 1.0E-12) * q.y) * denom, bounds);
            Plane.recordLineBounds(planetModel, boundsInfo, lineVectorX, lineVectorY, lineVectorZ, 0.0, (-(this.D + 1.0E-12) * q.z - this.z * -(q.D - 1.0E-12)) * denom, (this.y * -(q.D - 1.0E-12) + (this.D + 1.0E-12) * q.y) * denom, bounds);
            Plane.recordLineBounds(planetModel, boundsInfo, lineVectorX, lineVectorY, lineVectorZ, 0.0, (-(this.D - 1.0E-12) * q.z - this.z * -(q.D - 1.0E-12)) * denom, (this.y * -(q.D - 1.0E-12) + (this.D - 1.0E-12) * q.y) * denom, bounds);
        } else if (Math.abs(denomXZ) >= Math.abs(denomXY) && Math.abs(denomXZ) >= Math.abs(denomYZ)) {
            if (Math.abs(denomXZ) < 1.0E-24) {
                return;
            }
            double denom = 1.0 / denomXZ;
            Plane.recordLineBounds(planetModel, boundsInfo, lineVectorX, lineVectorY, lineVectorZ, (-(this.D + 1.0E-12) * q.z - this.z * -(q.D + 1.0E-12)) * denom, 0.0, (this.x * -(q.D + 1.0E-12) + (this.D + 1.0E-12) * q.x) * denom, bounds);
            Plane.recordLineBounds(planetModel, boundsInfo, lineVectorX, lineVectorY, lineVectorZ, (-(this.D - 1.0E-12) * q.z - this.z * -(q.D + 1.0E-12)) * denom, 0.0, (this.x * -(q.D + 1.0E-12) + (this.D - 1.0E-12) * q.x) * denom, bounds);
            Plane.recordLineBounds(planetModel, boundsInfo, lineVectorX, lineVectorY, lineVectorZ, (-(this.D + 1.0E-12) * q.z - this.z * -(q.D - 1.0E-12)) * denom, 0.0, (this.x * -(q.D - 1.0E-12) + (this.D + 1.0E-12) * q.x) * denom, bounds);
            Plane.recordLineBounds(planetModel, boundsInfo, lineVectorX, lineVectorY, lineVectorZ, (-(this.D - 1.0E-12) * q.z - this.z * -(q.D - 1.0E-12)) * denom, 0.0, (this.x * -(q.D - 1.0E-12) + (this.D - 1.0E-12) * q.x) * denom, bounds);
        } else {
            if (Math.abs(denomXY) < 1.0E-24) {
                return;
            }
            double denom = 1.0 / denomXY;
            Plane.recordLineBounds(planetModel, boundsInfo, lineVectorX, lineVectorY, lineVectorZ, (-(this.D + 1.0E-12) * q.y - this.y * -(q.D + 1.0E-12)) * denom, (this.x * -(q.D + 1.0E-12) + (this.D + 1.0E-12) * q.x) * denom, 0.0, bounds);
            Plane.recordLineBounds(planetModel, boundsInfo, lineVectorX, lineVectorY, lineVectorZ, (-(this.D - 1.0E-12) * q.y - this.y * -(q.D + 1.0E-12)) * denom, (this.x * -(q.D + 1.0E-12) + (this.D - 1.0E-12) * q.x) * denom, 0.0, bounds);
            Plane.recordLineBounds(planetModel, boundsInfo, lineVectorX, lineVectorY, lineVectorZ, (-(this.D + 1.0E-12) * q.y - this.y * -(q.D - 1.0E-12)) * denom, (this.x * -(q.D - 1.0E-12) + (this.D + 1.0E-12) * q.x) * denom, 0.0, bounds);
            Plane.recordLineBounds(planetModel, boundsInfo, lineVectorX, lineVectorY, lineVectorZ, (-(this.D - 1.0E-12) * q.y - this.y * -(q.D - 1.0E-12)) * denom, (this.x * -(q.D - 1.0E-12) + (this.D - 1.0E-12) * q.x) * denom, 0.0, bounds);
        }
    }

    private static void recordLineBounds(PlanetModel planetModel, Bounds boundsInfo, double lineVectorX, double lineVectorY, double lineVectorZ, double x0, double y0, double z0, Membership ... bounds) {
        double B = 2.0 * (lineVectorX * x0 * planetModel.inverseXYScalingSquared + lineVectorY * y0 * planetModel.inverseXYScalingSquared + lineVectorZ * z0 * planetModel.inverseZScalingSquared);
        double A = lineVectorX * lineVectorX * planetModel.inverseXYScalingSquared + lineVectorY * lineVectorY * planetModel.inverseXYScalingSquared + lineVectorZ * lineVectorZ * planetModel.inverseZScalingSquared;
        double C2 = x0 * x0 * planetModel.inverseXYScalingSquared + y0 * y0 * planetModel.inverseXYScalingSquared + z0 * z0 * planetModel.inverseZScalingSquared - 1.0;
        double BsquaredMinus = B * B - 4.0 * A * C2;
        if (Math.abs(BsquaredMinus) < 1.0E-24) {
            double inverse2A = 1.0 / (2.0 * A);
            double t = -B * inverse2A;
            double pointX = lineVectorX * t + x0;
            double pointY = lineVectorY * t + y0;
            double pointZ = lineVectorZ * t + z0;
            for (Membership bound : bounds) {
                if (bound.isWithin(pointX, pointY, pointZ)) continue;
                return;
            }
            boundsInfo.addPoint(new GeoPoint(pointX, pointY, pointZ));
        } else if (BsquaredMinus > 0.0) {
            double inverse2A = 1.0 / (2.0 * A);
            double sqrtTerm = Math.sqrt(BsquaredMinus);
            double t1 = (-B + sqrtTerm) * inverse2A;
            double t2 = (-B - sqrtTerm) * inverse2A;
            double point1X = lineVectorX * t1 + x0;
            double point1Y = lineVectorY * t1 + y0;
            double point1Z = lineVectorZ * t1 + z0;
            double point2X = lineVectorX * t2 + x0;
            double point2Y = lineVectorY * t2 + y0;
            double point2Z = lineVectorZ * t2 + z0;
            boolean point1Valid = true;
            boolean point2Valid = true;
            for (Membership bound : bounds) {
                if (bound.isWithin(point1X, point1Y, point1Z)) continue;
                point1Valid = false;
                break;
            }
            for (Membership bound : bounds) {
                if (bound.isWithin(point2X, point2Y, point2Z)) continue;
                point2Valid = false;
                break;
            }
            if (point1Valid) {
                boundsInfo.addPoint(new GeoPoint(point1X, point1Y, point1Z));
            }
            if (point2Valid) {
                boundsInfo.addPoint(new GeoPoint(point2X, point2Y, point2Z));
            }
        } else {
            boundsInfo.noBound(planetModel);
        }
    }

    public void recordBounds(PlanetModel planetModel, XYZBounds boundsInfo, Plane p, Membership ... bounds) {
        this.findIntersectionBounds(planetModel, boundsInfo, p, bounds);
    }

    public void recordBounds(PlanetModel planetModel, XYZBounds boundsInfo, Membership ... bounds) {
        double denom0;
        double l;
        double m;
        GeoPoint thePoint2;
        GeoPoint thePoint1;
        double denom2;
        double denom1;
        double l2;
        double l1;
        double commonDenom;
        double sqrtResult;
        GeoPoint thePoint;
        double l3;
        double m2;
        double sqrtTerm;
        double c;
        double b;
        double a;
        double qSquared;
        double q;
        double A = this.x;
        double B = this.y;
        double C2 = this.z;
        if (!boundsInfo.isSmallestMinZ(planetModel) || !boundsInfo.isLargestMaxZ(planetModel)) {
            if (Math.abs(A) >= 1.0E-12 || Math.abs(B) >= 1.0E-12) {
                GeoPoint[] points;
                Plane normalizedZPlane = Plane.constructNormalizedZPlane(A, B);
                for (GeoPoint point : points = this.findIntersections(planetModel, normalizedZPlane, bounds, NO_BOUNDS)) {
                    assert (planetModel.pointOnSurface(point));
                    Plane.addPoint(boundsInfo, bounds, point);
                }
            } else {
                GeoPoint[] points = this.findIntersections(planetModel, normalYPlane, NO_BOUNDS, NO_BOUNDS);
                if (points.length == 0) {
                    points = this.findIntersections(planetModel, normalXPlane, NO_BOUNDS, NO_BOUNDS);
                }
                if (points.length == 0) {
                    boundsInfo.addZValue(new GeoPoint(0.0, 0.0, -this.z));
                } else {
                    boundsInfo.addZValue(points[0]);
                }
            }
        }
        double k = 1.0 / ((this.x * this.x + this.y * this.y) * planetModel.xyScaling * planetModel.xyScaling + this.z * this.z * planetModel.zScaling * planetModel.zScaling);
        double abSquared = planetModel.xyScaling * planetModel.xyScaling;
        double cSquared = planetModel.zScaling * planetModel.zScaling;
        double ASquared = A * A;
        double BSquared = B * B;
        double CSquared = C2 * C2;
        double r = 2.0 * this.D * k;
        double rSquared = r * r;
        if (!boundsInfo.isSmallestMinX(planetModel) || !boundsInfo.isLargestMaxX(planetModel)) {
            q = A * abSquared * k;
            qSquared = q * q;
            a = ASquared * abSquared * rSquared + BSquared * abSquared * rSquared + CSquared * cSquared * rSquared - 4.0;
            b = -2.0 * A * abSquared * r + 2.0 * ASquared * abSquared * r * q + 2.0 * BSquared * abSquared * r * q + 2.0 * CSquared * cSquared * r * q;
            c = abSquared - 2.0 * A * abSquared * q + ASquared * abSquared * qSquared + BSquared * abSquared * qSquared + CSquared * cSquared * qSquared;
            if (Math.abs(a) >= 1.0E-24) {
                sqrtTerm = b * b - 4.0 * a * c;
                if (Math.abs(sqrtTerm) < 1.0E-24) {
                    m2 = -b / (2.0 * a);
                    if (Math.abs(m2) >= 1.0E-12) {
                        l3 = r * m2 + q;
                        double denom02 = 0.5 / m2;
                        thePoint = new GeoPoint((1.0 - l3 * A) * abSquared * denom02, -l3 * B * abSquared * denom02, -l3 * C2 * cSquared * denom02);
                        Plane.addPoint(boundsInfo, bounds, thePoint);
                    } else {
                        boundsInfo.addXValue(-this.D / A);
                    }
                } else if (sqrtTerm > 0.0) {
                    sqrtResult = Math.sqrt(sqrtTerm);
                    commonDenom = 0.5 / a;
                    double m1 = (-b + sqrtResult) * commonDenom;
                    assert (Math.abs(a * m1 * m1 + b * m1 + c) < 1.0E-12);
                    double m22 = (-b - sqrtResult) * commonDenom;
                    assert (Math.abs(a * m22 * m22 + b * m22 + c) < 1.0E-12);
                    if (Math.abs(m1) >= 1.0E-12 || Math.abs(m22) >= 1.0E-12) {
                        l1 = r * m1 + q;
                        l2 = r * m22 + q;
                        denom1 = 0.5 / m1;
                        denom2 = 0.5 / m22;
                        thePoint1 = new GeoPoint((1.0 - l1 * A) * abSquared * denom1, -l1 * B * abSquared * denom1, -l1 * C2 * cSquared * denom1);
                        thePoint2 = new GeoPoint((1.0 - l2 * A) * abSquared * denom2, -l2 * B * abSquared * denom2, -l2 * C2 * cSquared * denom2);
                        Plane.addPoint(boundsInfo, bounds, thePoint1);
                        Plane.addPoint(boundsInfo, bounds, thePoint2);
                    } else {
                        boundsInfo.addXValue(-this.D / A);
                    }
                }
            } else if (Math.abs(b) > 1.0E-24) {
                m = -c / b;
                l = r * m + q;
                denom0 = 0.5 / m;
                GeoPoint thePoint3 = new GeoPoint((1.0 - l * A) * abSquared * denom0, -l * B * abSquared * denom0, -l * C2 * cSquared * denom0);
                Plane.addPoint(boundsInfo, bounds, thePoint3);
            }
        }
        if (!boundsInfo.isSmallestMinY(planetModel) || !boundsInfo.isLargestMaxY(planetModel)) {
            q = B * abSquared * k;
            qSquared = q * q;
            a = ASquared * abSquared * rSquared + BSquared * abSquared * rSquared + CSquared * cSquared * rSquared - 4.0;
            b = 2.0 * ASquared * abSquared * r * q - 2.0 * B * abSquared * r + 2.0 * BSquared * abSquared * r * q + 2.0 * CSquared * cSquared * r * q;
            c = ASquared * abSquared * qSquared + abSquared - 2.0 * B * abSquared * q + BSquared * abSquared * qSquared + CSquared * cSquared * qSquared;
            if (Math.abs(a) >= 1.0E-24) {
                sqrtTerm = b * b - 4.0 * a * c;
                if (Math.abs(sqrtTerm) < 1.0E-24) {
                    m2 = -b / (2.0 * a);
                    if (Math.abs(m2) >= 1.0E-12) {
                        l3 = r * m2 + q;
                        double denom03 = 0.5 / m2;
                        thePoint = new GeoPoint(-l3 * A * abSquared * denom03, (1.0 - l3 * B) * abSquared * denom03, -l3 * C2 * cSquared * denom03);
                        Plane.addPoint(boundsInfo, bounds, thePoint);
                    } else {
                        boundsInfo.addYValue(-this.D / B);
                    }
                } else if (sqrtTerm > 0.0) {
                    sqrtResult = Math.sqrt(sqrtTerm);
                    commonDenom = 0.5 / a;
                    double m1 = (-b + sqrtResult) * commonDenom;
                    assert (Math.abs(a * m1 * m1 + b * m1 + c) < 1.0E-12);
                    double m23 = (-b - sqrtResult) * commonDenom;
                    assert (Math.abs(a * m23 * m23 + b * m23 + c) < 1.0E-12);
                    if (Math.abs(m1) >= 1.0E-12 || Math.abs(m23) >= 1.0E-12) {
                        l1 = r * m1 + q;
                        l2 = r * m23 + q;
                        denom1 = 0.5 / m1;
                        denom2 = 0.5 / m23;
                        thePoint1 = new GeoPoint(-l1 * A * abSquared * denom1, (1.0 - l1 * B) * abSquared * denom1, -l1 * C2 * cSquared * denom1);
                        thePoint2 = new GeoPoint(-l2 * A * abSquared * denom2, (1.0 - l2 * B) * abSquared * denom2, -l2 * C2 * cSquared * denom2);
                        Plane.addPoint(boundsInfo, bounds, thePoint1);
                        Plane.addPoint(boundsInfo, bounds, thePoint2);
                    } else {
                        boundsInfo.addYValue(-this.D / B);
                    }
                }
            } else if (Math.abs(b) > 1.0E-24) {
                m = -c / b;
                l = r * m + q;
                denom0 = 0.5 / m;
                GeoPoint thePoint4 = new GeoPoint(-l * A * abSquared * denom0, (1.0 - l * B) * abSquared * denom0, -l * C2 * cSquared * denom0);
                Plane.addPoint(boundsInfo, bounds, thePoint4);
            }
        }
    }

    public void recordBounds(PlanetModel planetModel, LatLonBounds boundsInfo, Plane p, Membership ... bounds) {
        this.findIntersectionBounds(planetModel, boundsInfo, p, bounds);
    }

    public void recordBounds(PlanetModel planetModel, LatLonBounds boundsInfo, Membership ... bounds) {
        double A = this.x;
        double B = this.y;
        double C2 = this.z;
        if (!boundsInfo.checkNoTopLatitudeBound() || !boundsInfo.checkNoBottomLatitudeBound()) {
            if (Math.abs(A) >= 1.0E-12 || Math.abs(B) >= 1.0E-12) {
                GeoPoint[] points;
                Plane verticalPlane = Plane.constructNormalizedZPlane(A, B);
                for (GeoPoint point : points = this.findIntersections(planetModel, verticalPlane, bounds, NO_BOUNDS)) {
                    Plane.addPoint(boundsInfo, bounds, point);
                }
            } else {
                GeoPoint[] points = this.findIntersections(planetModel, normalXPlane, NO_BOUNDS, NO_BOUNDS);
                if (points.length == 0) {
                    points = this.findIntersections(planetModel, normalYPlane, NO_BOUNDS, NO_BOUNDS);
                }
                if (points.length == 0) {
                    boundsInfo.addZValue(new GeoPoint(0.0, 0.0, -this.z));
                } else {
                    boundsInfo.addZValue(points[0]);
                }
            }
        }
        if (!boundsInfo.checkNoLongitudeBound()) {
            if (Math.abs(C2) < 1.0E-12) {
                if (Math.abs(this.D) >= 1.0E-12) {
                    if (Math.abs(A) > Math.abs(B)) {
                        double b = 2.0 * B * this.D * planetModel.inverseXYScalingSquared;
                        double a = B * B * planetModel.inverseXYScalingSquared + A * A * planetModel.inverseXYScalingSquared;
                        double c = this.D * this.D * planetModel.inverseXYScalingSquared - A * A;
                        double sqrtClause = b * b - 4.0 * a * c;
                        if (Math.abs(sqrtClause) < 1.0E-24) {
                            double y0 = -b / (2.0 * a);
                            double x0 = (-this.D - B * y0) / A;
                            double z0 = 0.0;
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0, y0, z0));
                        } else if (sqrtClause > 0.0) {
                            double sqrtResult = Math.sqrt(sqrtClause);
                            double denom = 1.0 / (2.0 * a);
                            double Hdenom = 1.0 / A;
                            double y0a = (-b + sqrtResult) * denom;
                            double y0b = (-b - sqrtResult) * denom;
                            double x0a = (-this.D - B * y0a) * Hdenom;
                            double x0b = (-this.D - B * y0b) * Hdenom;
                            double z0a = 0.0;
                            double z0b = 0.0;
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0a, y0a, z0a));
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0b, y0b, z0b));
                        }
                    } else {
                        double b = 2.0 * A * this.D * planetModel.inverseXYScalingSquared;
                        double a = B * B * planetModel.inverseXYScalingSquared + A * A * planetModel.inverseXYScalingSquared;
                        double c = this.D * this.D * planetModel.inverseXYScalingSquared - B * B;
                        double sqrtClause = b * b - 4.0 * a * c;
                        if (Math.abs(sqrtClause) < 1.0E-24) {
                            double x0 = -b / (2.0 * a);
                            double y0 = (-this.D - A * x0) / B;
                            double z0 = 0.0;
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0, y0, z0));
                        } else if (sqrtClause > 0.0) {
                            double sqrtResult = Math.sqrt(sqrtClause);
                            double denom = 1.0 / (2.0 * a);
                            double Idenom = 1.0 / B;
                            double x0a = (-b + sqrtResult) * denom;
                            double x0b = (-b - sqrtResult) * denom;
                            double y0a = (-this.D - A * x0a) * Idenom;
                            double y0b = (-this.D - A * x0b) * Idenom;
                            double z0a = 0.0;
                            double z0b = 0.0;
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0a, y0a, z0a));
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0b, y0b, z0b));
                        }
                    }
                }
            } else {
                double E = A * A * planetModel.inverseZScalingSquared + C2 * C2 * planetModel.inverseXYScalingSquared;
                double F = B * B * planetModel.inverseZScalingSquared + C2 * C2 * planetModel.inverseXYScalingSquared;
                double G = 2.0 * A * B * planetModel.inverseZScalingSquared;
                double H = 2.0 * A * this.D * planetModel.inverseZScalingSquared;
                double I = 2.0 * B * this.D * planetModel.inverseZScalingSquared;
                double J = this.D * this.D * planetModel.inverseZScalingSquared - C2 * C2;
                if (Math.abs(J) >= 1.0E-12 && J > 0.0) {
                    if (Math.abs(H) > Math.abs(I)) {
                        double b = 4.0 * E * I * J - 2.0 * G * H * J;
                        double a = E * I * I - G * H * I + F * H * H;
                        double c = 4.0 * E * J * J - J * H * H;
                        double sqrtClause = b * b - 4.0 * a * c;
                        if (Math.abs(sqrtClause) < 1.0E-36) {
                            double y0 = -b / (2.0 * a);
                            double x0 = (-2.0 * J - I * y0) / H;
                            double z0 = (-A * x0 - B * y0 - this.D) / C2;
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0, y0, z0));
                        } else if (sqrtClause > 0.0) {
                            double sqrtResult = Math.sqrt(sqrtClause);
                            double denom = 1.0 / (2.0 * a);
                            double Hdenom = 1.0 / H;
                            double Cdenom = 1.0 / C2;
                            double y0a = (-b + sqrtResult) * denom;
                            double y0b = (-b - sqrtResult) * denom;
                            double x0a = (-2.0 * J - I * y0a) * Hdenom;
                            double x0b = (-2.0 * J - I * y0b) * Hdenom;
                            double z0a = (-A * x0a - B * y0a - this.D) * Cdenom;
                            double z0b = (-A * x0b - B * y0b - this.D) * Cdenom;
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0a, y0a, z0a));
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0b, y0b, z0b));
                        }
                    } else {
                        double b = 4.0 * F * H * J - 2.0 * G * I * J;
                        double a = E * I * I - G * H * I + F * H * H;
                        double c = 4.0 * F * J * J - J * I * I;
                        double sqrtClause = b * b - 4.0 * a * c;
                        if (Math.abs(sqrtClause) < 1.0E-36) {
                            double x0 = -b / (2.0 * a);
                            double y0 = (-2.0 * J - H * x0) / I;
                            double z0 = (-A * x0 - B * y0 - this.D) / C2;
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0, y0, z0));
                        } else if (sqrtClause > 0.0) {
                            double sqrtResult = Math.sqrt(sqrtClause);
                            double denom = 1.0 / (2.0 * a);
                            double Idenom = 1.0 / I;
                            double Cdenom = 1.0 / C2;
                            double x0a = (-b + sqrtResult) * denom;
                            double x0b = (-b - sqrtResult) * denom;
                            double y0a = (-2.0 * J - H * x0a) * Idenom;
                            double y0b = (-2.0 * J - H * x0b) * Idenom;
                            double z0a = (-A * x0a - B * y0a - this.D) * Cdenom;
                            double z0b = (-A * x0b - B * y0b - this.D) * Cdenom;
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0a, y0a, z0a));
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0b, y0b, z0b));
                        }
                    }
                }
            }
        }
    }

    private static void addPoint(Bounds boundsInfo, Membership[] bounds, GeoPoint point) {
        for (Membership bound : bounds) {
            if (bound.isWithin(point)) continue;
            return;
        }
        boundsInfo.addPoint(point);
    }

    public boolean intersects(PlanetModel planetModel, Plane q, GeoPoint[] notablePoints, GeoPoint[] moreNotablePoints, Membership[] bounds, Membership ... moreBounds) {
        double z0;
        double y0;
        double x0;
        double denom;
        if (this.isNumericallyIdentical(q)) {
            for (GeoPoint p : notablePoints) {
                if (!Plane.meetsAllBounds(p, bounds, moreBounds)) continue;
                return true;
            }
            for (GeoPoint p : moreNotablePoints) {
                if (!Plane.meetsAllBounds(p, bounds, moreBounds)) continue;
                return true;
            }
            return false;
        }
        double lineVectorX = this.y * q.z - this.z * q.y;
        double lineVectorY = this.z * q.x - this.x * q.z;
        double lineVectorZ = this.x * q.y - this.y * q.x;
        if (Math.abs(lineVectorX) < 1.0E-12 && Math.abs(lineVectorY) < 1.0E-12 && Math.abs(lineVectorZ) < 1.0E-12) {
            return false;
        }
        double denomYZ = this.y * q.z - this.z * q.y;
        double denomXZ = this.x * q.z - this.z * q.x;
        double denomXY = this.x * q.y - this.y * q.x;
        if (Math.abs(denomYZ) >= Math.abs(denomXZ) && Math.abs(denomYZ) >= Math.abs(denomXY)) {
            if (Math.abs(denomYZ) < 1.0E-24) {
                return false;
            }
            denom = 1.0 / denomYZ;
            x0 = 0.0;
            y0 = (-this.D * q.z - this.z * -q.D) * denom;
            z0 = (this.y * -q.D + this.D * q.y) * denom;
        } else if (Math.abs(denomXZ) >= Math.abs(denomXY) && Math.abs(denomXZ) >= Math.abs(denomYZ)) {
            if (Math.abs(denomXZ) < 1.0E-24) {
                return false;
            }
            denom = 1.0 / denomXZ;
            x0 = (-this.D * q.z - this.z * -q.D) * denom;
            y0 = 0.0;
            z0 = (this.x * -q.D + this.D * q.x) * denom;
        } else {
            if (Math.abs(denomXY) < 1.0E-24) {
                return false;
            }
            denom = 1.0 / denomXY;
            x0 = (-this.D * q.y - this.y * -q.D) * denom;
            y0 = (this.x * -q.D + this.D * q.x) * denom;
            z0 = 0.0;
        }
        double A = lineVectorX * lineVectorX * planetModel.inverseXYScalingSquared + lineVectorY * lineVectorY * planetModel.inverseXYScalingSquared + lineVectorZ * lineVectorZ * planetModel.inverseZScalingSquared;
        double B = 2.0 * (lineVectorX * x0 * planetModel.inverseXYScalingSquared + lineVectorY * y0 * planetModel.inverseXYScalingSquared + lineVectorZ * z0 * planetModel.inverseZScalingSquared);
        double C2 = x0 * x0 * planetModel.inverseXYScalingSquared + y0 * y0 * planetModel.inverseXYScalingSquared + z0 * z0 * planetModel.inverseZScalingSquared - 1.0;
        double BsquaredMinus = B * B - 4.0 * A * C2;
        if (Math.abs(BsquaredMinus) < 1.0E-24) {
            double inverse2A = 1.0 / (2.0 * A);
            double t = -B * inverse2A;
            double pointX = lineVectorX * t + x0;
            double pointY = lineVectorY * t + y0;
            double pointZ = lineVectorZ * t + z0;
            for (Membership bound : bounds) {
                if (bound.isWithin(pointX, pointY, pointZ)) continue;
                return false;
            }
            for (Membership bound : moreBounds) {
                if (bound.isWithin(pointX, pointY, pointZ)) continue;
                return false;
            }
            return true;
        }
        if (BsquaredMinus > 0.0) {
            double inverse2A = 1.0 / (2.0 * A);
            double sqrtTerm = Math.sqrt(BsquaredMinus);
            double t1 = (-B + sqrtTerm) * inverse2A;
            double t2 = (-B - sqrtTerm) * inverse2A;
            double point1X = lineVectorX * t1 + x0;
            double point1Y = lineVectorY * t1 + y0;
            double point1Z = lineVectorZ * t1 + z0;
            boolean point1Valid = true;
            for (Membership bound : bounds) {
                if (bound.isWithin(point1X, point1Y, point1Z)) continue;
                point1Valid = false;
                break;
            }
            if (point1Valid) {
                for (Membership bound : moreBounds) {
                    if (bound.isWithin(point1X, point1Y, point1Z)) continue;
                    point1Valid = false;
                    break;
                }
            }
            if (point1Valid) {
                return true;
            }
            double point2X = lineVectorX * t2 + x0;
            double point2Y = lineVectorY * t2 + y0;
            double point2Z = lineVectorZ * t2 + z0;
            for (Membership bound : bounds) {
                if (bound.isWithin(point2X, point2Y, point2Z)) continue;
                return false;
            }
            for (Membership bound : moreBounds) {
                if (bound.isWithin(point2X, point2Y, point2Z)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean crosses(PlanetModel planetModel, Plane q, GeoPoint[] notablePoints, GeoPoint[] moreNotablePoints, Membership[] bounds, Membership ... moreBounds) {
        double z0;
        double y0;
        double x0;
        double denom;
        if (this.isNumericallyIdentical(q)) {
            for (GeoPoint p : notablePoints) {
                if (!Plane.meetsAllBounds(p, bounds, moreBounds)) continue;
                return true;
            }
            for (GeoPoint p : moreNotablePoints) {
                if (!Plane.meetsAllBounds(p, bounds, moreBounds)) continue;
                return true;
            }
            return false;
        }
        double lineVectorX = this.y * q.z - this.z * q.y;
        double lineVectorY = this.z * q.x - this.x * q.z;
        double lineVectorZ = this.x * q.y - this.y * q.x;
        if (Math.abs(lineVectorX) < 1.0E-12 && Math.abs(lineVectorY) < 1.0E-12 && Math.abs(lineVectorZ) < 1.0E-12) {
            return false;
        }
        double denomYZ = this.y * q.z - this.z * q.y;
        double denomXZ = this.x * q.z - this.z * q.x;
        double denomXY = this.x * q.y - this.y * q.x;
        if (Math.abs(denomYZ) >= Math.abs(denomXZ) && Math.abs(denomYZ) >= Math.abs(denomXY)) {
            if (Math.abs(denomYZ) < 1.0E-24) {
                return false;
            }
            denom = 1.0 / denomYZ;
            x0 = 0.0;
            y0 = (-this.D * q.z - this.z * -q.D) * denom;
            z0 = (this.y * -q.D + this.D * q.y) * denom;
        } else if (Math.abs(denomXZ) >= Math.abs(denomXY) && Math.abs(denomXZ) >= Math.abs(denomYZ)) {
            if (Math.abs(denomXZ) < 1.0E-24) {
                return false;
            }
            denom = 1.0 / denomXZ;
            x0 = (-this.D * q.z - this.z * -q.D) * denom;
            y0 = 0.0;
            z0 = (this.x * -q.D + this.D * q.x) * denom;
        } else {
            if (Math.abs(denomXY) < 1.0E-24) {
                return false;
            }
            denom = 1.0 / denomXY;
            x0 = (-this.D * q.y - this.y * -q.D) * denom;
            y0 = (this.x * -q.D + this.D * q.x) * denom;
            z0 = 0.0;
        }
        double A = lineVectorX * lineVectorX * planetModel.inverseXYScalingSquared + lineVectorY * lineVectorY * planetModel.inverseXYScalingSquared + lineVectorZ * lineVectorZ * planetModel.inverseZScalingSquared;
        double B = 2.0 * (lineVectorX * x0 * planetModel.inverseXYScalingSquared + lineVectorY * y0 * planetModel.inverseXYScalingSquared + lineVectorZ * z0 * planetModel.inverseZScalingSquared);
        double C2 = x0 * x0 * planetModel.inverseXYScalingSquared + y0 * y0 * planetModel.inverseXYScalingSquared + z0 * z0 * planetModel.inverseZScalingSquared - 1.0;
        double BsquaredMinus = B * B - 4.0 * A * C2;
        if (Math.abs(BsquaredMinus) < 1.0E-24) {
            return false;
        }
        if (BsquaredMinus > 0.0) {
            double inverse2A = 1.0 / (2.0 * A);
            double sqrtTerm = Math.sqrt(BsquaredMinus);
            double t1 = (-B + sqrtTerm) * inverse2A;
            double t2 = (-B - sqrtTerm) * inverse2A;
            double point1X = lineVectorX * t1 + x0;
            double point1Y = lineVectorY * t1 + y0;
            double point1Z = lineVectorZ * t1 + z0;
            boolean point1Valid = true;
            for (Membership bound : bounds) {
                if (bound.isWithin(point1X, point1Y, point1Z)) continue;
                point1Valid = false;
                break;
            }
            if (point1Valid) {
                for (Membership bound : moreBounds) {
                    if (bound.isWithin(point1X, point1Y, point1Z)) continue;
                    point1Valid = false;
                    break;
                }
            }
            if (point1Valid) {
                return true;
            }
            double point2X = lineVectorX * t2 + x0;
            double point2Y = lineVectorY * t2 + y0;
            double point2Z = lineVectorZ * t2 + z0;
            for (Membership bound : bounds) {
                if (bound.isWithin(point2X, point2Y, point2Z)) continue;
                return false;
            }
            for (Membership bound : moreBounds) {
                if (bound.isWithin(point2X, point2Y, point2Z)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isFunctionallyIdentical(Plane p) {
        double cross1 = this.y * p.z - this.z * p.y;
        double cross2 = this.z * p.x - this.x * p.z;
        double cross3 = this.x * p.y - this.y * p.x;
        if (cross1 * cross1 + cross2 * cross2 + cross3 * cross3 >= 5.0E-12) {
            return false;
        }
        double denom = 1.0 / (p.x * p.x + p.y * p.y + p.z * p.z);
        return this.evaluateIsZero(-p.x * p.D * denom, -p.y * p.D * denom, -p.z * p.D * denom);
    }

    public boolean isNumericallyIdentical(Plane p) {
        double cross1 = this.y * p.z - this.z * p.y;
        double cross2 = this.z * p.x - this.x * p.z;
        double cross3 = this.x * p.y - this.y * p.x;
        if (cross1 * cross1 + cross2 * cross2 + cross3 * cross3 >= 1.0E-24) {
            return false;
        }
        double denom = 1.0 / (p.x * p.x + p.y * p.y + p.z * p.z);
        return this.evaluateIsZero(-p.x * p.D * denom, -p.y * p.D * denom, -p.z * p.D * denom);
    }

    public GeoPoint[] findArcDistancePoints(PlanetModel planetModel, double arcDistanceValue, GeoPoint startPoint, Membership ... bounds) {
        if (Math.abs(this.D) >= 1.0E-12) {
            throw new IllegalStateException("Can't find arc distance using plane that doesn't go through origin");
        }
        if (!this.evaluateIsZero(startPoint)) {
            throw new IllegalArgumentException("Start point is not on plane");
        }
        double azimuthMagnitude = Math.sqrt(this.x * this.x + this.y * this.y);
        double cosPlaneAltitude = this.z;
        double sinPlaneAltitude = azimuthMagnitude;
        double cosPlaneAzimuth = this.x / azimuthMagnitude;
        double sinPlaneAzimuth = this.y / azimuthMagnitude;
        assert (Math.abs(sinPlaneAltitude * sinPlaneAltitude + cosPlaneAltitude * cosPlaneAltitude - 1.0) < 1.0E-12) : "Improper sin/cos of altitude: " + (sinPlaneAltitude * sinPlaneAltitude + cosPlaneAltitude * cosPlaneAltitude);
        assert (Math.abs(sinPlaneAzimuth * sinPlaneAzimuth + cosPlaneAzimuth * cosPlaneAzimuth - 1.0) < 1.0E-12) : "Improper sin/cos of azimuth: " + (sinPlaneAzimuth * sinPlaneAzimuth + cosPlaneAzimuth * cosPlaneAzimuth);
        double x0 = startPoint.x;
        double y0 = startPoint.y;
        double z0 = startPoint.z;
        double x1 = x0 * cosPlaneAzimuth + y0 * sinPlaneAzimuth;
        double y1 = -x0 * sinPlaneAzimuth + y0 * cosPlaneAzimuth;
        double z1 = z0;
        double x2 = x1 * cosPlaneAltitude - z1 * sinPlaneAltitude;
        double y2 = y1;
        double z2 = x1 * sinPlaneAltitude + z1 * cosPlaneAltitude;
        assert (Math.abs(z2) < 1.0E-12) : "Rotation should have put startpoint on x-y plane, instead has value " + z2;
        double startAngle = Math.atan2(y2, x2);
        double point1Angle = startAngle + arcDistanceValue;
        double point2Angle = startAngle - arcDistanceValue;
        double point1x2 = Math.cos(point1Angle);
        double point1y2 = Math.sin(point1Angle);
        double point1z2 = 0.0;
        double point2x2 = Math.cos(point2Angle);
        double point2y2 = Math.sin(point2Angle);
        double point2z2 = 0.0;
        double point1x1 = point1x2 * cosPlaneAltitude + 0.0 * sinPlaneAltitude;
        double point1y1 = point1y2;
        double point1z1 = -point1x2 * sinPlaneAltitude + 0.0 * cosPlaneAltitude;
        double point2x1 = point2x2 * cosPlaneAltitude + 0.0 * sinPlaneAltitude;
        double point2y1 = point2y2;
        double point2z1 = -point2x2 * sinPlaneAltitude + 0.0 * cosPlaneAltitude;
        double point1x0 = point1x1 * cosPlaneAzimuth - point1y1 * sinPlaneAzimuth;
        double point1y0 = point1x1 * sinPlaneAzimuth + point1y1 * cosPlaneAzimuth;
        double point1z0 = point1z1;
        double point2x0 = point2x1 * cosPlaneAzimuth - point2y1 * sinPlaneAzimuth;
        double point2y0 = point2x1 * sinPlaneAzimuth + point2y1 * cosPlaneAzimuth;
        double point2z0 = point2z1;
        GeoPoint point1 = planetModel.createSurfacePoint(point1x0, point1y0, point1z0);
        GeoPoint point2 = planetModel.createSurfacePoint(point2x0, point2y0, point2z0);
        boolean isPoint1Inside = Plane.meetsAllBounds(point1, bounds);
        boolean isPoint2Inside = Plane.meetsAllBounds(point2, bounds);
        if (isPoint1Inside) {
            if (isPoint2Inside) {
                return new GeoPoint[]{point1, point2};
            }
            return new GeoPoint[]{point1};
        }
        if (isPoint2Inside) {
            return new GeoPoint[]{point2};
        }
        return new GeoPoint[0];
    }

    private static boolean meetsAllBounds(Vector p, Membership[] bounds) {
        return Plane.meetsAllBounds(p.x, p.y, p.z, bounds);
    }

    private static boolean meetsAllBounds(double x, double y, double z, Membership[] bounds) {
        for (Membership bound : bounds) {
            if (bound.isWithin(x, y, z)) continue;
            return false;
        }
        return true;
    }

    private static boolean meetsAllBounds(Vector p, Membership[] bounds, Membership[] moreBounds) {
        return Plane.meetsAllBounds(p.x, p.y, p.z, bounds, moreBounds);
    }

    private static boolean meetsAllBounds(double x, double y, double z, Membership[] bounds, Membership[] moreBounds) {
        return Plane.meetsAllBounds(x, y, z, bounds) && Plane.meetsAllBounds(x, y, z, moreBounds);
    }

    public GeoPoint getSampleIntersectionPoint(PlanetModel planetModel, Plane q) {
        GeoPoint[] intersections = this.findIntersections(planetModel, q, NO_BOUNDS, NO_BOUNDS);
        if (intersections.length == 0) {
            return null;
        }
        return intersections[0];
    }

    @Override
    public String toString() {
        return "[A=" + this.x + ", B=" + this.y + "; C=" + this.z + "; D=" + this.D + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof Plane)) {
            return false;
        }
        Plane other = (Plane)o;
        return other.D == this.D;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.D);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

