/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.math.Vector3D;

public class CGAlgorithms3D {
    private CGAlgorithms3D() {
    }

    public static double distance(Coordinate p0, Coordinate p1) {
        if (Double.isNaN(p0.z) || Double.isNaN(p1.z)) {
            return p0.distance(p1);
        }
        double dx = p0.x - p1.x;
        double dy = p0.y - p1.y;
        double dz = p0.z - p1.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double distancePointSegment(Coordinate p, Coordinate A, Coordinate B) {
        if (A.equals3D(B)) {
            return CGAlgorithms3D.distance(p, A);
        }
        double len2 = (B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y) + (B.z - A.z) * (B.z - A.z);
        if (Double.isNaN(len2)) {
            throw new IllegalArgumentException("Ordinates must not be NaN");
        }
        double r = ((p.x - A.x) * (B.x - A.x) + (p.y - A.y) * (B.y - A.y) + (p.z - A.z) * (B.z - A.z)) / len2;
        if (r <= 0.0) {
            return CGAlgorithms3D.distance(p, A);
        }
        if (r >= 1.0) {
            return CGAlgorithms3D.distance(p, B);
        }
        double qx = A.x + r * (B.x - A.x);
        double qy = A.y + r * (B.y - A.y);
        double qz = A.z + r * (B.z - A.z);
        double dx = p.x - qx;
        double dy = p.y - qy;
        double dz = p.z - qz;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double distanceSegmentSegment(Coordinate A, Coordinate B, Coordinate C2, Coordinate D) {
        double t;
        double s;
        if (A.equals3D(B)) {
            return CGAlgorithms3D.distancePointSegment(A, C2, D);
        }
        if (C2.equals3D(B)) {
            return CGAlgorithms3D.distancePointSegment(C2, A, B);
        }
        double a = Vector3D.dot(A, B, A, B);
        double b = Vector3D.dot(A, B, C2, D);
        double c = Vector3D.dot(C2, D, C2, D);
        double d = Vector3D.dot(A, B, C2, A);
        double e = Vector3D.dot(C2, D, C2, A);
        double denom = a * c - b * b;
        if (Double.isNaN(denom)) {
            throw new IllegalArgumentException("Ordinates must not be NaN");
        }
        if (denom <= 0.0) {
            s = 0.0;
            t = b > c ? d / b : e / c;
        } else {
            s = (b * e - c * d) / denom;
            t = (a * e - b * d) / denom;
        }
        if (s < 0.0) {
            return CGAlgorithms3D.distancePointSegment(A, C2, D);
        }
        if (s > 1.0) {
            return CGAlgorithms3D.distancePointSegment(B, C2, D);
        }
        if (t < 0.0) {
            return CGAlgorithms3D.distancePointSegment(C2, A, B);
        }
        if (t > 1.0) {
            return CGAlgorithms3D.distancePointSegment(D, A, B);
        }
        double x1 = A.x + s * (B.x - A.x);
        double y1 = A.y + s * (B.y - A.y);
        double z1 = A.z + s * (B.z - A.z);
        double x2 = C2.x + t * (D.x - C2.x);
        double y2 = C2.y + t * (D.y - C2.y);
        double z2 = C2.z + t * (D.z - C2.z);
        return CGAlgorithms3D.distance(new Coordinate(x1, y1, z1), new Coordinate(x2, y2, z2));
    }
}

