/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io.jts;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.OutStream;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.io.BinaryCodec;
import org.locationtech.spatial4j.shape.Shape;

public class JtsBinaryCodec
extends BinaryCodec {
    protected final boolean useFloat;

    public JtsBinaryCodec(JtsSpatialContext ctx, JtsSpatialContextFactory factory) {
        super(ctx, factory);
        this.useFloat = factory.precisionModel.getType() == PrecisionModel.FLOATING_SINGLE;
    }

    @Override
    protected double readDim(DataInput dataInput) throws IOException {
        if (this.useFloat) {
            return dataInput.readFloat();
        }
        return super.readDim(dataInput);
    }

    @Override
    protected void writeDim(DataOutput dataOutput, double v) throws IOException {
        if (this.useFloat) {
            dataOutput.writeFloat((float)v);
        } else {
            super.writeDim(dataOutput, v);
        }
    }

    @Override
    protected byte typeForShape(Shape s) {
        byte type = super.typeForShape(s);
        if (type == 0) {
            type = 5;
        }
        return (byte)type;
    }

    @Override
    protected Shape readShapeByTypeIfSupported(DataInput dataInput, byte type) throws IOException {
        if (type != 5) {
            return super.readShapeByTypeIfSupported(dataInput, type);
        }
        return this.readJtsGeom(dataInput);
    }

    @Override
    protected boolean writeShapeByTypeIfSupported(DataOutput dataOutput, Shape s, byte type) throws IOException {
        if (type != 5) {
            return super.writeShapeByTypeIfSupported(dataOutput, s, type);
        }
        this.writeJtsGeom(dataOutput, s);
        return true;
    }

    public Shape readJtsGeom(final DataInput dataInput) throws IOException {
        JtsSpatialContext ctx = (JtsSpatialContext)this.ctx;
        WKBReader reader = new WKBReader(ctx.getGeometryFactory());
        try {
            InStream inStream = new InStream(){
                boolean first = true;

                @Override
                public void read(byte[] buf) throws IOException {
                    if (this.first) {
                        if (buf.length != 1) {
                            throw new IllegalStateException("Expected initial read of one byte, not: " + buf.length);
                        }
                        buf[0] = 0;
                        this.first = false;
                    } else {
                        dataInput.readFully(buf);
                    }
                }
            };
            Geometry geom = reader.read(inStream);
            return ctx.makeShape(geom, false, false);
        }
        catch (ParseException ex) {
            throw new InvalidShapeException("error reading WKT", ex);
        }
    }

    public void writeJtsGeom(final DataOutput dataOutput, Shape s) throws IOException {
        JtsSpatialContext ctx = (JtsSpatialContext)this.ctx;
        Geometry geom = ctx.getGeometryFrom(s);
        new WKBWriter().write(geom, new OutStream(){
            boolean first = true;

            @Override
            public void write(byte[] buf, int len) throws IOException {
                if (this.first) {
                    this.first = false;
                    if (len != 1 || buf[0] != 0) {
                        throw new IllegalStateException("Unexpected WKB byte order mark");
                    }
                    return;
                }
                dataOutput.write(buf, 0, len);
            }
        });
    }
}

