/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;

public class ClearScrollRequest
extends ActionRequest
implements ToXContentObject {
    private List<String> scrollIds;

    public ClearScrollRequest() {
    }

    public ClearScrollRequest(StreamInput in) throws IOException {
        super(in);
        this.scrollIds = Arrays.asList(in.readStringArray());
    }

    public List<String> getScrollIds() {
        return this.scrollIds;
    }

    public void setScrollIds(List<String> scrollIds) {
        this.scrollIds = scrollIds;
    }

    public void addScrollId(String scrollId) {
        if (this.scrollIds == null) {
            this.scrollIds = new ArrayList<String>();
        }
        this.scrollIds.add(scrollId);
    }

    public List<String> scrollIds() {
        return this.scrollIds;
    }

    public void scrollIds(List<String> scrollIds) {
        this.scrollIds = scrollIds;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.scrollIds == null || this.scrollIds.isEmpty()) {
            validationException = ValidateActions.addValidationError("no scroll ids specified", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.scrollIds == null) {
            out.writeVInt(0);
        } else {
            out.writeStringArray(this.scrollIds.toArray(new String[this.scrollIds.size()]));
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("scroll_id");
        for (String scrollId : this.scrollIds) {
            builder.value(scrollId);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public void fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        this.scrollIds = null;
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("Malformed content, must start with an object");
        }
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if ("scroll_id".equals(currentFieldName)) {
                if (token == XContentParser.Token.START_ARRAY) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (!token.isValue()) {
                            throw new IllegalArgumentException("scroll_id array element should only contain scroll_id");
                        }
                        this.addScrollId(parser.text());
                    }
                    continue;
                }
                if (!token.isValue()) {
                    throw new IllegalArgumentException("scroll_id element should only contain scroll_id");
                }
                this.addScrollId(parser.text());
                continue;
            }
            throw new IllegalArgumentException("Unknown parameter [" + currentFieldName + "] in request body or parameter is of the wrong type[" + token + "] ");
        }
    }
}

