/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.search.ArraySearchPhaseResults;
import org.opensearch.action.search.CountedCollector;
import org.opensearch.action.search.QueryPhaseResultConsumer;
import org.opensearch.action.search.SearchActionListener;
import org.opensearch.action.search.SearchPhase;
import org.opensearch.action.search.SearchPhaseContext;
import org.opensearch.action.search.SearchProgressListener;
import org.opensearch.action.search.SearchTransportService;
import org.opensearch.search.SearchPhaseResult;
import org.opensearch.search.SearchShardTarget;
import org.opensearch.search.dfs.AggregatedDfs;
import org.opensearch.search.dfs.DfsSearchResult;
import org.opensearch.search.query.QuerySearchRequest;
import org.opensearch.search.query.QuerySearchResult;
import org.opensearch.transport.Transport;

final class DfsQueryPhase
extends SearchPhase {
    private final ArraySearchPhaseResults<SearchPhaseResult> queryResult;
    private final List<DfsSearchResult> searchResults;
    private final AggregatedDfs dfs;
    private final Function<ArraySearchPhaseResults<SearchPhaseResult>, SearchPhase> nextPhaseFactory;
    private final SearchPhaseContext context;
    private final SearchTransportService searchTransportService;
    private final SearchProgressListener progressListener;

    DfsQueryPhase(List<DfsSearchResult> searchResults, AggregatedDfs dfs, QueryPhaseResultConsumer queryResult, Function<ArraySearchPhaseResults<SearchPhaseResult>, SearchPhase> nextPhaseFactory, SearchPhaseContext context) {
        super("dfs_query");
        this.progressListener = context.getTask().getProgressListener();
        this.queryResult = queryResult;
        this.searchResults = searchResults;
        this.dfs = dfs;
        this.nextPhaseFactory = nextPhaseFactory;
        this.context = context;
        this.searchTransportService = context.getSearchTransport();
        context.addReleasable(queryResult);
    }

    @Override
    public void run() throws IOException {
        final CountedCollector<SearchPhaseResult> counter = new CountedCollector<SearchPhaseResult>(this.queryResult, this.searchResults.size(), () -> this.context.executeNextPhase(this, this.nextPhaseFactory.apply(this.queryResult)), this.context);
        for (DfsSearchResult dfsResult : this.searchResults) {
            final SearchShardTarget searchShardTarget = dfsResult.getSearchShardTarget();
            final Transport.Connection connection = this.context.getConnection(searchShardTarget.getClusterAlias(), searchShardTarget.getNodeId());
            final QuerySearchRequest querySearchRequest = new QuerySearchRequest(searchShardTarget.getOriginalIndices(), dfsResult.getContextId(), dfsResult.getShardSearchRequest(), this.dfs);
            final int shardIndex = dfsResult.getShardIndex();
            this.searchTransportService.sendExecuteQuery(connection, querySearchRequest, this.context.getTask(), new SearchActionListener<QuerySearchResult>(searchShardTarget, shardIndex){

                @Override
                protected void innerOnResponse(QuerySearchResult response) {
                    try {
                        counter.onResult(response);
                    }
                    catch (Exception e) {
                        DfsQueryPhase.this.context.onPhaseFailure(DfsQueryPhase.this, "", e);
                    }
                }

                @Override
                public void onFailure(Exception exception) {
                    try {
                        DfsQueryPhase.this.context.getLogger().debug(() -> new ParameterizedMessage("[{}] Failed to execute query phase", (Object)querySearchRequest.contextId()), (Throwable)exception);
                        DfsQueryPhase.this.progressListener.notifyQueryFailure(shardIndex, searchShardTarget, exception);
                        counter.onFailure(shardIndex, searchShardTarget, exception);
                    }
                    finally {
                        if (DfsQueryPhase.this.context.getRequest().pointInTimeBuilder() == null) {
                            DfsQueryPhase.this.context.sendReleaseSearchContext(querySearchRequest.contextId(), connection, searchShardTarget.getOriginalIndices());
                        }
                    }
                }
            });
        }
    }
}

