/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import com.carrotsearch.hppc.IntArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.search.ScoreDoc;
import org.opensearch.action.OriginalIndices;
import org.opensearch.action.search.ArraySearchPhaseResults;
import org.opensearch.action.search.CountedCollector;
import org.opensearch.action.search.ExpandSearchPhase;
import org.opensearch.action.search.SearchActionListener;
import org.opensearch.action.search.SearchPhase;
import org.opensearch.action.search.SearchPhaseContext;
import org.opensearch.action.search.SearchPhaseController;
import org.opensearch.action.search.SearchPhaseResults;
import org.opensearch.action.search.SearchProgressListener;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.common.util.concurrent.AtomicArray;
import org.opensearch.search.RescoreDocIds;
import org.opensearch.search.SearchPhaseResult;
import org.opensearch.search.SearchShardTarget;
import org.opensearch.search.dfs.AggregatedDfs;
import org.opensearch.search.fetch.FetchSearchResult;
import org.opensearch.search.fetch.ShardFetchSearchRequest;
import org.opensearch.search.internal.InternalSearchResponse;
import org.opensearch.search.internal.ShardSearchContextId;
import org.opensearch.search.internal.ShardSearchRequest;
import org.opensearch.search.query.QuerySearchResult;
import org.opensearch.transport.Transport;

final class FetchSearchPhase
extends SearchPhase {
    private final ArraySearchPhaseResults<FetchSearchResult> fetchResults;
    private final SearchPhaseController searchPhaseController;
    private final AtomicArray<SearchPhaseResult> queryResults;
    private final BiFunction<InternalSearchResponse, AtomicArray<SearchPhaseResult>, SearchPhase> nextPhaseFactory;
    private final SearchPhaseContext context;
    private final Logger logger;
    private final SearchPhaseResults<SearchPhaseResult> resultConsumer;
    private final SearchProgressListener progressListener;
    private final AggregatedDfs aggregatedDfs;

    FetchSearchPhase(SearchPhaseResults<SearchPhaseResult> resultConsumer, SearchPhaseController searchPhaseController, AggregatedDfs aggregatedDfs, SearchPhaseContext context) {
        this(resultConsumer, searchPhaseController, aggregatedDfs, context, (response, queryPhaseResults) -> new ExpandSearchPhase(context, (InternalSearchResponse)response, (AtomicArray<SearchPhaseResult>)queryPhaseResults));
    }

    FetchSearchPhase(SearchPhaseResults<SearchPhaseResult> resultConsumer, SearchPhaseController searchPhaseController, AggregatedDfs aggregatedDfs, SearchPhaseContext context, BiFunction<InternalSearchResponse, AtomicArray<SearchPhaseResult>, SearchPhase> nextPhaseFactory) {
        super("fetch");
        if (context.getNumShards() != resultConsumer.getNumShards()) {
            throw new IllegalStateException("number of shards must match the length of the query results but doesn't:" + context.getNumShards() + "!=" + resultConsumer.getNumShards());
        }
        this.fetchResults = new ArraySearchPhaseResults(resultConsumer.getNumShards());
        this.searchPhaseController = searchPhaseController;
        this.queryResults = resultConsumer.getAtomicArray();
        this.aggregatedDfs = aggregatedDfs;
        this.nextPhaseFactory = nextPhaseFactory;
        this.context = context;
        this.logger = context.getLogger();
        this.resultConsumer = resultConsumer;
        this.progressListener = context.getTask().getProgressListener();
    }

    @Override
    public void run() {
        this.context.execute(new AbstractRunnable(){

            @Override
            protected void doRun() throws Exception {
                FetchSearchPhase.this.innerRun();
            }

            @Override
            public void onFailure(Exception e) {
                FetchSearchPhase.this.context.onPhaseFailure(FetchSearchPhase.this, "", e);
            }
        });
    }

    private void innerRun() throws Exception {
        int numShards = this.context.getNumShards();
        boolean isScrollSearch = this.context.getRequest().scroll() != null;
        List<SearchPhaseResult> phaseResults = this.queryResults.asList();
        SearchPhaseController.ReducedQueryPhase reducedQueryPhase = this.resultConsumer.reduce();
        boolean queryAndFetchOptimization = this.queryResults.length() == 1;
        Runnable finishPhase = () -> this.moveToNextPhase(this.searchPhaseController, this.queryResults, reducedQueryPhase, queryAndFetchOptimization ? this.queryResults : this.fetchResults.getAtomicArray());
        if (queryAndFetchOptimization) {
            assert (phaseResults.isEmpty() || phaseResults.get(0).fetchResult() != null) : "phaseResults empty [" + phaseResults.isEmpty() + "], single result: " + phaseResults.get(0).fetchResult();
            finishPhase.run();
        } else {
            ScoreDoc[] scoreDocs = reducedQueryPhase.sortedTopDocs.scoreDocs;
            IntArrayList[] docIdsToLoad = this.searchPhaseController.fillDocIdsToLoad(numShards, scoreDocs);
            if (scoreDocs.length == 0) {
                phaseResults.stream().map(SearchPhaseResult::queryResult).forEach(this::releaseIrrelevantSearchContext);
                finishPhase.run();
            } else {
                ScoreDoc[] lastEmittedDocPerShard = isScrollSearch ? this.searchPhaseController.getLastEmittedDocPerShard(reducedQueryPhase, numShards) : null;
                CountedCollector<FetchSearchResult> counter = new CountedCollector<FetchSearchResult>(this.fetchResults, docIdsToLoad.length, finishPhase, this.context);
                for (int i = 0; i < docIdsToLoad.length; ++i) {
                    IntArrayList entry = docIdsToLoad[i];
                    SearchPhaseResult queryResult = this.queryResults.get(i);
                    if (entry == null) {
                        if (queryResult != null) {
                            this.releaseIrrelevantSearchContext(queryResult.queryResult());
                            this.progressListener.notifyFetchResult(i);
                        }
                        counter.countDown();
                        continue;
                    }
                    SearchShardTarget searchShardTarget = queryResult.getSearchShardTarget();
                    Transport.Connection connection = this.context.getConnection(searchShardTarget.getClusterAlias(), searchShardTarget.getNodeId());
                    ShardFetchSearchRequest fetchSearchRequest = this.createFetchRequest(queryResult.queryResult().getContextId(), i, entry, lastEmittedDocPerShard, searchShardTarget.getOriginalIndices(), queryResult.getShardSearchRequest(), queryResult.getRescoreDocIds());
                    this.executeFetch(i, searchShardTarget, counter, fetchSearchRequest, queryResult.queryResult(), connection);
                }
            }
        }
    }

    protected ShardFetchSearchRequest createFetchRequest(ShardSearchContextId contextId, int index, IntArrayList entry, ScoreDoc[] lastEmittedDocPerShard, OriginalIndices originalIndices, ShardSearchRequest shardSearchRequest, RescoreDocIds rescoreDocIds) {
        ScoreDoc lastEmittedDoc = lastEmittedDocPerShard != null ? lastEmittedDocPerShard[index] : null;
        return new ShardFetchSearchRequest(originalIndices, contextId, shardSearchRequest, entry, lastEmittedDoc, rescoreDocIds, this.aggregatedDfs);
    }

    private void executeFetch(final int shardIndex, final SearchShardTarget shardTarget, final CountedCollector<FetchSearchResult> counter, final ShardFetchSearchRequest fetchSearchRequest, final QuerySearchResult querySearchResult, Transport.Connection connection) {
        this.context.getSearchTransport().sendExecuteFetch(connection, fetchSearchRequest, this.context.getTask(), new SearchActionListener<FetchSearchResult>(shardTarget, shardIndex){

            @Override
            public void innerOnResponse(FetchSearchResult result) {
                try {
                    FetchSearchPhase.this.progressListener.notifyFetchResult(shardIndex);
                    counter.onResult(result);
                }
                catch (Exception e) {
                    FetchSearchPhase.this.context.onPhaseFailure(FetchSearchPhase.this, "", e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    FetchSearchPhase.this.logger.debug(() -> new ParameterizedMessage("[{}] Failed to execute fetch phase", (Object)fetchSearchRequest.contextId()), (Throwable)e);
                    FetchSearchPhase.this.progressListener.notifyFetchFailure(shardIndex, shardTarget, e);
                    counter.onFailure(shardIndex, shardTarget, e);
                }
                finally {
                    FetchSearchPhase.this.releaseIrrelevantSearchContext(querySearchResult);
                }
            }
        });
    }

    private void releaseIrrelevantSearchContext(QuerySearchResult queryResult) {
        if (queryResult.hasSearchContext() && this.context.getRequest().scroll() == null && this.context.getRequest().pointInTimeBuilder() == null) {
            try {
                SearchShardTarget searchShardTarget = queryResult.getSearchShardTarget();
                Transport.Connection connection = this.context.getConnection(searchShardTarget.getClusterAlias(), searchShardTarget.getNodeId());
                this.context.sendReleaseSearchContext(queryResult.getContextId(), connection, searchShardTarget.getOriginalIndices());
            }
            catch (Exception e) {
                this.context.getLogger().trace("failed to release context", (Throwable)e);
            }
        }
    }

    private void moveToNextPhase(SearchPhaseController searchPhaseController, AtomicArray<SearchPhaseResult> queryPhaseResults, SearchPhaseController.ReducedQueryPhase reducedQueryPhase, AtomicArray<? extends SearchPhaseResult> fetchResultsArr) {
        InternalSearchResponse internalResponse = searchPhaseController.merge(this.context.getRequest().scroll() != null, reducedQueryPhase, fetchResultsArr.asList(), fetchResultsArr::get);
        this.context.executeNextPhase(this, this.nextPhaseFactory.apply(internalResponse, queryPhaseResults));
    }
}

