/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.search.SearchHits;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.profile.ProfileShardResult;
import org.opensearch.search.profile.SearchProfileShardResults;
import org.opensearch.search.suggest.Suggest;

public class SearchResponseSections
implements ToXContentFragment {
    protected final SearchHits hits;
    protected final Aggregations aggregations;
    protected final Suggest suggest;
    protected final SearchProfileShardResults profileResults;
    protected final boolean timedOut;
    protected final Boolean terminatedEarly;
    protected final int numReducePhases;

    public SearchResponseSections(SearchHits hits, Aggregations aggregations, Suggest suggest, boolean timedOut, Boolean terminatedEarly, SearchProfileShardResults profileResults, int numReducePhases) {
        this.hits = hits;
        this.aggregations = aggregations;
        this.suggest = suggest;
        this.profileResults = profileResults;
        this.timedOut = timedOut;
        this.terminatedEarly = terminatedEarly;
        this.numReducePhases = numReducePhases;
    }

    public final boolean timedOut() {
        return this.timedOut;
    }

    public final Boolean terminatedEarly() {
        return this.terminatedEarly;
    }

    public final SearchHits hits() {
        return this.hits;
    }

    public final Aggregations aggregations() {
        return this.aggregations;
    }

    public final Suggest suggest() {
        return this.suggest;
    }

    public final int getNumReducePhases() {
        return this.numReducePhases;
    }

    public final Map<String, ProfileShardResult> profile() {
        if (this.profileResults == null) {
            return Collections.emptyMap();
        }
        return this.profileResults.getShardResults();
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.hits.toXContent(builder, params);
        if (this.aggregations != null) {
            this.aggregations.toXContent(builder, params);
        }
        if (this.suggest != null) {
            this.suggest.toXContent(builder, params);
        }
        if (this.profileResults != null) {
            this.profileResults.toXContent(builder, params);
        }
        return builder;
    }

    protected void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }
}

