/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.opensearch.OpenSearchParseException;
import org.opensearch.Version;
import org.opensearch.cluster.AbstractNamedDiffable;
import org.opensearch.cluster.NamedDiff;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.common.Nullable;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;

public class RepositoriesMetadata
extends AbstractNamedDiffable<Metadata.Custom>
implements Metadata.Custom {
    public static final String TYPE = "repositories";
    public static final String HIDE_GENERATIONS_PARAM = "hide_generations";
    private final List<RepositoryMetadata> repositories;

    public RepositoriesMetadata(List<RepositoryMetadata> repositories) {
        this.repositories = Collections.unmodifiableList(repositories);
    }

    public RepositoriesMetadata withUpdatedGeneration(String repoName, long safeGeneration, long pendingGeneration) {
        int indexOfRepo = -1;
        for (int i = 0; i < this.repositories.size(); ++i) {
            if (!this.repositories.get(i).name().equals(repoName)) continue;
            indexOfRepo = i;
            break;
        }
        if (indexOfRepo < 0) {
            throw new IllegalArgumentException("Unknown repository [" + repoName + "]");
        }
        ArrayList<RepositoryMetadata> updatedRepos = new ArrayList<RepositoryMetadata>(this.repositories);
        updatedRepos.set(indexOfRepo, new RepositoryMetadata(this.repositories.get(indexOfRepo), safeGeneration, pendingGeneration));
        return new RepositoriesMetadata(updatedRepos);
    }

    public List<RepositoryMetadata> repositories() {
        return this.repositories;
    }

    public RepositoryMetadata repository(String name) {
        for (RepositoryMetadata repository : this.repositories) {
            if (!name.equals(repository.name())) continue;
            return repository;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoriesMetadata that = (RepositoriesMetadata)o;
        return this.repositories.equals(that.repositories);
    }

    public boolean equalsIgnoreGenerations(@Nullable RepositoriesMetadata other) {
        if (other == null) {
            return false;
        }
        if (other.repositories.size() != this.repositories.size()) {
            return false;
        }
        for (int i = 0; i < this.repositories.size(); ++i) {
            if (this.repositories.get(i).equalsIgnoreGenerations(other.repositories.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.repositories.hashCode();
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    public RepositoriesMetadata(StreamInput in) throws IOException {
        this.repositories = in.readList(RepositoryMetadata::new);
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput in) throws IOException {
        return RepositoriesMetadata.readDiffFrom(Metadata.Custom.class, TYPE, in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.repositories);
    }

    public static RepositoriesMetadata fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        ArrayList<RepositoryMetadata> repository = new ArrayList<RepositoryMetadata>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                String name = parser.currentName();
                if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                    throw new OpenSearchParseException("failed to parse repository [{}], expected object", name);
                }
                String type = null;
                Settings settings = Settings.EMPTY;
                long generation = -2L;
                long pendingGeneration = -1L;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        String currentFieldName = parser.currentName();
                        if ("type".equals(currentFieldName)) {
                            if (parser.nextToken() != XContentParser.Token.VALUE_STRING) {
                                throw new OpenSearchParseException("failed to parse repository [{}], unknown type", name);
                            }
                            type = parser.text();
                            continue;
                        }
                        if ("settings".equals(currentFieldName)) {
                            if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                                throw new OpenSearchParseException("failed to parse repository [{}], incompatible params", name);
                            }
                            settings = Settings.fromXContent(parser);
                            continue;
                        }
                        if ("generation".equals(currentFieldName)) {
                            if (parser.nextToken() != XContentParser.Token.VALUE_NUMBER) {
                                throw new OpenSearchParseException("failed to parse repository [{}], unknown type", name);
                            }
                            generation = parser.longValue();
                            continue;
                        }
                        if ("pending_generation".equals(currentFieldName)) {
                            if (parser.nextToken() != XContentParser.Token.VALUE_NUMBER) {
                                throw new OpenSearchParseException("failed to parse repository [{}], unknown type", name);
                            }
                            pendingGeneration = parser.longValue();
                            continue;
                        }
                        throw new OpenSearchParseException("failed to parse repository [{}], unknown field [{}]", name, currentFieldName);
                    }
                    throw new OpenSearchParseException("failed to parse repository [{}]", name);
                }
                if (type == null) {
                    throw new OpenSearchParseException("failed to parse repository [{}], missing repository type", name);
                }
                repository.add(new RepositoryMetadata(name, type, settings, generation, pendingGeneration));
                continue;
            }
            throw new OpenSearchParseException("failed to parse repositories", new Object[0]);
        }
        return new RepositoriesMetadata(repository);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (RepositoryMetadata repository : this.repositories) {
            RepositoriesMetadata.toXContent(repository, builder, params);
        }
        return builder;
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.API_AND_GATEWAY;
    }

    public static void toXContent(RepositoryMetadata repository, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(repository.name());
        builder.field("type", repository.type());
        builder.startObject("settings");
        repository.settings().toXContent(builder, params);
        builder.endObject();
        if (!params.paramAsBoolean(HIDE_GENERATIONS_PARAM, false)) {
            builder.field("generation", repository.generation());
            builder.field("pending_generation", repository.pendingGeneration());
        }
        builder.endObject();
    }

    public String toString() {
        return Strings.toString(this);
    }
}

