/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.io;

import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.opensearch.common.io.IndexIOStreamHandler;

public class VersionedCodecStreamWrapper<T> {
    private final IndexIOStreamHandler<T> indexIOStreamHandler;
    private final int currentVersion;
    private final String codec;

    public VersionedCodecStreamWrapper(IndexIOStreamHandler<T> indexIOStreamHandler, int currentVersion, String codec) {
        this.indexIOStreamHandler = indexIOStreamHandler;
        this.currentVersion = currentVersion;
        this.codec = codec;
    }

    public T readStream(IndexInput indexInput) throws IOException {
        BufferedChecksumIndexInput checksumIndexInput = new BufferedChecksumIndexInput(indexInput);
        int readStreamVersion = this.checkHeader(checksumIndexInput);
        T content = this.getHandlerForVersion(readStreamVersion).readContent(checksumIndexInput);
        this.checkFooter(checksumIndexInput);
        return content;
    }

    public void writeStream(IndexOutput indexOutput, T content) throws IOException {
        this.writeHeader(indexOutput);
        this.getHandlerForVersion(this.currentVersion).writeContent(indexOutput, content);
        this.writeFooter(indexOutput);
    }

    private int checkHeader(IndexInput indexInput) throws IOException {
        return CodecUtil.checkHeader(indexInput, this.codec, this.currentVersion, this.currentVersion);
    }

    private void checkFooter(ChecksumIndexInput indexInput) throws IOException {
        CodecUtil.checkFooter(indexInput);
    }

    private void writeHeader(IndexOutput indexOutput) throws IOException {
        CodecUtil.writeHeader(indexOutput, this.codec, this.currentVersion);
    }

    private void writeFooter(IndexOutput indexOutput) throws IOException {
        CodecUtil.writeFooter(indexOutput);
    }

    private IndexIOStreamHandler<T> getHandlerForVersion(int version) {
        return this.indexIOStreamHandler;
    }
}

