/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.lucene.store;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;

public class ByteArrayIndexInput
extends IndexInput
implements RandomAccessInput {
    private final byte[] bytes;
    private final int offset;
    private final int length;
    private int pos;

    public ByteArrayIndexInput(String resourceDesc, byte[] bytes) {
        this(resourceDesc, bytes, 0, bytes.length);
    }

    public ByteArrayIndexInput(String resourceDesc, byte[] bytes, int offset, int length) {
        super(resourceDesc);
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public long getFilePointer() {
        return this.pos;
    }

    @Override
    public void seek(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("Seeking to negative position: " + this.pos);
        }
        if (l > (long)this.length) {
            throw new EOFException("seek past EOF");
        }
        this.pos = (int)l;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        if (offset >= 0L && length >= 0L && offset + length <= (long)this.length) {
            return new ByteArrayIndexInput(sliceDescription, this.bytes, this.offset + (int)offset, (int)length);
        }
        throw new IllegalArgumentException("slice() " + sliceDescription + " out of bounds: offset=" + offset + ",length=" + length + ",fileLength=" + this.length + ": " + this);
    }

    @Override
    public byte readByte() throws IOException {
        this.validatePos(this.pos, 1);
        return this.bytes[this.offset + this.pos++];
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.validatePos(this.pos, len);
        System.arraycopy(this.bytes, this.offset + this.pos, b, offset, len);
        this.pos += len;
    }

    @Override
    public byte readByte(long pos) throws IOException {
        this.validatePos(pos, 1);
        return this.internalReadByte(pos);
    }

    @Override
    public short readShort(long pos) throws IOException {
        this.validatePos(pos, 2);
        return this.internalReadShort(pos);
    }

    @Override
    public int readInt(long pos) throws IOException {
        this.validatePos(pos, 4);
        return this.internalReadInt(pos);
    }

    @Override
    public long readLong(long pos) throws IOException {
        this.validatePos(pos, 8);
        return this.internalReadLong(pos);
    }

    private byte internalReadByte(long pos) {
        return this.bytes[this.offset + (int)pos];
    }

    private short internalReadShort(long pos) {
        byte p1 = this.internalReadByte(pos);
        byte p2 = this.internalReadByte(pos + 1L);
        return (short)((p2 & 0xFF) << 8 | p1 & 0xFF);
    }

    private int internalReadInt(long pos) {
        short p1 = this.internalReadShort(pos);
        short p2 = this.internalReadShort(pos + 2L);
        return (p2 & 0xFFFF) << 16 | p1 & 0xFFFF;
    }

    public long internalReadLong(long pos) {
        int p1 = this.internalReadInt(pos);
        int p2 = this.internalReadInt(pos + 4L);
        return (long)p2 << 32 | (long)p1 & 0xFFFFFFFFL;
    }

    private void validatePos(long pos, int len) throws EOFException {
        if (pos < 0L || pos + (long)len > (long)(this.length + this.offset)) {
            throw new EOFException("seek past EOF");
        }
    }
}

