/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.common.util.AbstractBigArray;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.LongArray;

final class BigLongArray
extends AbstractBigArray
implements LongArray {
    private static final BigLongArray ESTIMATOR = new BigLongArray(0L, BigArrays.NON_RECYCLING_INSTANCE, false);
    private long[][] pages;

    BigLongArray(long size, BigArrays bigArrays, boolean clearOnResize) {
        super(2048, bigArrays, clearOnResize);
        this.size = size;
        this.pages = new long[this.numPages(size)][];
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i] = this.newLongPage(i);
        }
    }

    @Override
    public long get(long index) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return this.pages[pageIndex][indexInPage];
    }

    @Override
    public long set(long index, long value) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        long[] page = this.pages[pageIndex];
        long ret = page[indexInPage];
        page[indexInPage] = value;
        return ret;
    }

    @Override
    public long increment(long index, long inc) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        long[] lArray = this.pages[pageIndex];
        int n = indexInPage;
        long l = lArray[n] + inc;
        lArray[n] = l;
        return l;
    }

    @Override
    protected int numBytesPerElement() {
        return 8;
    }

    @Override
    public void resize(long newSize) {
        int i;
        int numPages = this.numPages(newSize);
        if (numPages > this.pages.length) {
            this.pages = (long[][])Arrays.copyOf(this.pages, ArrayUtil.oversize(numPages, RamUsageEstimator.NUM_BYTES_OBJECT_REF));
        }
        for (i = numPages - 1; i >= 0 && this.pages[i] == null; --i) {
            this.pages[i] = this.newLongPage(i);
        }
        for (i = numPages; i < this.pages.length && this.pages[i] != null; ++i) {
            this.pages[i] = null;
            this.releasePage(i);
        }
        this.size = newSize;
    }

    @Override
    public void fill(long fromIndex, long toIndex, long value) {
        int toPage;
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex == toIndex) {
            return;
        }
        int fromPage = this.pageIndex(fromIndex);
        if (fromPage == (toPage = this.pageIndex(toIndex - 1L))) {
            Arrays.fill(this.pages[fromPage], this.indexInPage(fromIndex), this.indexInPage(toIndex - 1L) + 1, value);
        } else {
            Arrays.fill(this.pages[fromPage], this.indexInPage(fromIndex), this.pages[fromPage].length, value);
            for (int i = fromPage + 1; i < toPage; ++i) {
                Arrays.fill(this.pages[i], value);
            }
            Arrays.fill(this.pages[toPage], 0, this.indexInPage(toIndex - 1L) + 1, value);
        }
    }

    public static long estimateRamBytes(long size) {
        return ESTIMATOR.ramBytesEstimated(size);
    }
}

