/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util.concurrent;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.opensearch.ExceptionsHelper;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.opensearch.common.util.concurrent.OpenSearchAbortPolicy;
import org.opensearch.common.util.concurrent.OpenSearchThreadPoolExecutor;
import org.opensearch.common.util.concurrent.PrioritizedOpenSearchThreadPoolExecutor;
import org.opensearch.common.util.concurrent.QueueResizingOpenSearchThreadPoolExecutor;
import org.opensearch.common.util.concurrent.ResizableBlockingQueue;
import org.opensearch.common.util.concurrent.SizeBlockingQueue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.util.concurrent.TimedRunnable;
import org.opensearch.common.util.concurrent.WrappedRunnable;
import org.opensearch.common.util.concurrent.XRejectedExecutionHandler;
import org.opensearch.node.Node;
import org.opensearch.threadpool.RunnableTaskExecutionListener;
import org.opensearch.threadpool.TaskAwareRunnable;

public class OpenSearchExecutors {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(OpenSearchExecutors.class);
    public static final Setting<Integer> PROCESSORS_SETTING = new Setting<Integer>("processors", s -> Integer.toString(Runtime.getRuntime().availableProcessors()), OpenSearchExecutors.processorsParser("processors"), Setting.Property.Deprecated, Setting.Property.NodeScope);
    public static final Setting<Integer> NODE_PROCESSORS_SETTING = new Setting<Integer>("node.processors", PROCESSORS_SETTING, OpenSearchExecutors.processorsParser("node.processors"), Setting.Property.NodeScope);
    private static final ExecutorService DIRECT_EXECUTOR_SERVICE = new DirectExecutorService();

    private static Function<String, Integer> processorsParser(String name) {
        return s -> {
            int availableProcessors;
            int value = Setting.parseInt(s, 1, name);
            if (value > (availableProcessors = Runtime.getRuntime().availableProcessors())) {
                deprecationLogger.deprecate("processors_" + name, "setting [{}] to value [{}] which is more than available processors [{}] is deprecated", name, value, availableProcessors);
            }
            return value;
        };
    }

    public static int allocatedProcessors(Settings settings) {
        return NODE_PROCESSORS_SETTING.get(settings);
    }

    public static PrioritizedOpenSearchThreadPoolExecutor newSinglePrioritizing(String name, ThreadFactory threadFactory, ThreadContext contextHolder, ScheduledExecutorService timer) {
        return new PrioritizedOpenSearchThreadPoolExecutor(name, 1, 1, 0L, TimeUnit.MILLISECONDS, threadFactory, contextHolder, timer);
    }

    public static OpenSearchThreadPoolExecutor newScaling(String name, int min, int max, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory, ThreadContext contextHolder) {
        ExecutorScalingQueue<Runnable> queue = new ExecutorScalingQueue<Runnable>();
        OpenSearchThreadPoolExecutor executor = new OpenSearchThreadPoolExecutor(name, min, max, keepAliveTime, unit, queue, threadFactory, new ForceQueuePolicy(), contextHolder);
        queue.executor = executor;
        return executor;
    }

    public static OpenSearchThreadPoolExecutor newFixed(String name, int size, int queueCapacity, ThreadFactory threadFactory, ThreadContext contextHolder) {
        BlockingQueue<Runnable> queue = queueCapacity < 0 ? ConcurrentCollections.newBlockingQueue() : new SizeBlockingQueue(ConcurrentCollections.newBlockingQueue(), queueCapacity);
        return new OpenSearchThreadPoolExecutor(name, size, size, 0L, TimeUnit.MILLISECONDS, queue, threadFactory, new OpenSearchAbortPolicy(), contextHolder);
    }

    public static OpenSearchThreadPoolExecutor newAutoQueueFixed(String name, int size, int initialQueueCapacity, int minQueueSize, int maxQueueSize, int frameSize, TimeValue targetedResponseTime, ThreadFactory threadFactory, ThreadContext contextHolder) {
        return OpenSearchExecutors.newAutoQueueFixed(name, size, initialQueueCapacity, minQueueSize, maxQueueSize, frameSize, targetedResponseTime, threadFactory, contextHolder, null);
    }

    public static OpenSearchThreadPoolExecutor newAutoQueueFixed(String name, int size, int initialQueueCapacity, int minQueueSize, int maxQueueSize, int frameSize, TimeValue targetedResponseTime, ThreadFactory threadFactory, ThreadContext contextHolder, AtomicReference<RunnableTaskExecutionListener> runnableTaskListener) {
        if (initialQueueCapacity <= 0) {
            throw new IllegalArgumentException("initial queue capacity for [" + name + "] executor must be positive, got: " + initialQueueCapacity);
        }
        ResizableBlockingQueue<Runnable> queue = new ResizableBlockingQueue<Runnable>(ConcurrentCollections.newBlockingQueue(), initialQueueCapacity);
        Function<Runnable, WrappedRunnable> runnableWrapper = runnableTaskListener != null ? runnable -> {
            TaskAwareRunnable taskAwareRunnable = new TaskAwareRunnable(contextHolder, (Runnable)runnable, runnableTaskListener);
            return new TimedRunnable(taskAwareRunnable);
        } : TimedRunnable::new;
        return new QueueResizingOpenSearchThreadPoolExecutor(name, size, size, 0L, TimeUnit.MILLISECONDS, queue, minQueueSize, maxQueueSize, runnableWrapper, frameSize, targetedResponseTime, threadFactory, new OpenSearchAbortPolicy(), contextHolder);
    }

    public static Throwable rethrowErrors(Runnable runnable) {
        block7: {
            if (runnable instanceof RunnableFuture) {
                assert (((RunnableFuture)runnable).isDone());
                try {
                    ((RunnableFuture)runnable).get();
                }
                catch (Exception e) {
                    assert (e instanceof CancellationException || e instanceof InterruptedException || e instanceof ExecutionException) : e;
                    Optional<Error> maybeError = ExceptionsHelper.maybeError(e);
                    if (maybeError.isPresent()) {
                        throw maybeError.get();
                    }
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!(e instanceof ExecutionException)) break block7;
                    return e.getCause();
                }
            }
        }
        return null;
    }

    public static ExecutorService newDirectExecutorService() {
        return DIRECT_EXECUTOR_SERVICE;
    }

    public static String threadName(Settings settings, String namePrefix) {
        if (Node.NODE_NAME_SETTING.exists(settings)) {
            return OpenSearchExecutors.threadName(Node.NODE_NAME_SETTING.get(settings), namePrefix);
        }
        return OpenSearchExecutors.threadName("", namePrefix);
    }

    public static String threadName(String nodeName, String namePrefix) {
        return "opensearch" + (nodeName.isEmpty() ? "" : "[") + nodeName + (nodeName.isEmpty() ? "" : "]") + "[" + namePrefix + "]";
    }

    public static ThreadFactory daemonThreadFactory(Settings settings, String namePrefix) {
        return OpenSearchExecutors.daemonThreadFactory(OpenSearchExecutors.threadName(settings, namePrefix));
    }

    public static ThreadFactory daemonThreadFactory(String nodeName, String namePrefix) {
        assert (nodeName != null && !nodeName.isEmpty());
        return OpenSearchExecutors.daemonThreadFactory(OpenSearchExecutors.threadName(nodeName, namePrefix));
    }

    public static ThreadFactory daemonThreadFactory(String namePrefix) {
        return new OpenSearchThreadFactory(namePrefix);
    }

    private OpenSearchExecutors() {
    }

    static class ExecutorScalingQueue<E>
    extends LinkedTransferQueue<E> {
        ThreadPoolExecutor executor;

        ExecutorScalingQueue() {
        }

        @Override
        public boolean offer(E e) {
            if (!this.tryTransfer(e)) {
                int left = this.executor.getMaximumPoolSize() - this.executor.getCorePoolSize();
                if (left > 0) {
                    return false;
                }
                return super.offer(e);
            }
            return true;
        }
    }

    static class ForceQueuePolicy
    implements XRejectedExecutionHandler {
        ForceQueuePolicy() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                assert (executor.getQueue() instanceof ExecutorScalingQueue);
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public long rejected() {
            return 0L;
        }
    }

    static class OpenSearchThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        OpenSearchThreadFactory(String namePrefix) {
            this.namePrefix = namePrefix;
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + "[T#" + this.threadNumber.getAndIncrement() + "]", 0L);
            t.setDaemon(true);
            return t;
        }
    }

    private static final class DirectExecutorService
    extends AbstractExecutorService {
        @SuppressForbidden(reason="properly rethrowing errors, see OpenSearchExecutors.rethrowErrors")
        DirectExecutorService() {
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void execute(Runnable command) {
            command.run();
            OpenSearchExecutors.rethrowErrors(command);
        }
    }
}

