/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.OpenSearchException;
import org.opensearch.Version;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.ClusterSettingsResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.io.FileSystemUtils;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsModule;
import org.opensearch.common.transport.TransportAddress;
import org.opensearch.discovery.InitializeExtensionRequest;
import org.opensearch.discovery.InitializeExtensionResponse;
import org.opensearch.env.EnvironmentSettingsResponse;
import org.opensearch.extensions.AcknowledgedResponse;
import org.opensearch.extensions.AddSettingsUpdateConsumerRequest;
import org.opensearch.extensions.AddSettingsUpdateConsumerRequestHandler;
import org.opensearch.extensions.DiscoveryExtensionNode;
import org.opensearch.extensions.ExtensionDependency;
import org.opensearch.extensions.ExtensionDependencyResponse;
import org.opensearch.extensions.ExtensionRequest;
import org.opensearch.extensions.ExtensionsSettings;
import org.opensearch.extensions.RegisterTransportActionsRequest;
import org.opensearch.extensions.action.ExtensionActionRequest;
import org.opensearch.extensions.action.ExtensionActionResponse;
import org.opensearch.extensions.action.ExtensionTransportActionsHandler;
import org.opensearch.extensions.action.TransportActionRequestFromExtension;
import org.opensearch.extensions.rest.RegisterRestActionsRequest;
import org.opensearch.extensions.rest.RestActionsRequestHandler;
import org.opensearch.extensions.settings.CustomSettingsRequestHandler;
import org.opensearch.extensions.settings.RegisterCustomSettingsRequest;
import org.opensearch.index.IndexModule;
import org.opensearch.index.IndexService;
import org.opensearch.index.IndicesModuleRequest;
import org.opensearch.index.IndicesModuleResponse;
import org.opensearch.index.shard.IndexEventListener;
import org.opensearch.indices.cluster.IndicesClusterStateService;
import org.opensearch.rest.RestController;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportResponse;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class ExtensionsManager {
    public static final String REQUEST_EXTENSION_ACTION_NAME = "internal:discovery/extensions";
    public static final String INDICES_EXTENSION_POINT_ACTION_NAME = "indices:internal/extensions";
    public static final String INDICES_EXTENSION_NAME_ACTION_NAME = "indices:internal/name";
    public static final String REQUEST_EXTENSION_CLUSTER_STATE = "internal:discovery/clusterstate";
    public static final String REQUEST_EXTENSION_CLUSTER_SETTINGS = "internal:discovery/clustersettings";
    public static final String REQUEST_EXTENSION_ENVIRONMENT_SETTINGS = "internal:discovery/enviornmentsettings";
    public static final String REQUEST_EXTENSION_ADD_SETTINGS_UPDATE_CONSUMER = "internal:discovery/addsettingsupdateconsumer";
    public static final String REQUEST_EXTENSION_UPDATE_SETTINGS = "internal:discovery/updatesettings";
    public static final String REQUEST_EXTENSION_DEPENDENCY_INFORMATION = "internal:discovery/dependencyinformation";
    public static final String REQUEST_EXTENSION_REGISTER_CUSTOM_SETTINGS = "internal:discovery/registercustomsettings";
    public static final String REQUEST_EXTENSION_REGISTER_REST_ACTIONS = "internal:discovery/registerrestactions";
    public static final String REQUEST_EXTENSION_REGISTER_TRANSPORT_ACTIONS = "internal:discovery/registertransportactions";
    public static final String REQUEST_OPENSEARCH_PARSE_NAMED_WRITEABLE = "internal:discovery/parsenamedwriteable";
    public static final String REQUEST_REST_EXECUTE_ON_EXTENSION_ACTION = "internal:extensions/restexecuteonextensiontaction";
    public static final String REQUEST_EXTENSION_HANDLE_TRANSPORT_ACTION = "internal:extensions/handle-transportaction";
    public static final String TRANSPORT_ACTION_REQUEST_FROM_EXTENSION = "internal:extensions/request-transportaction-from-extension";
    public static final int EXTENSION_REQUEST_WAIT_TIMEOUT = 10;
    private static final Logger logger = LogManager.getLogger(ExtensionsManager.class);
    private final Path extensionsPath;
    private ExtensionTransportActionsHandler extensionTransportActionsHandler;
    private List<DiscoveryExtensionNode> extensions;
    private Map<String, DiscoveryExtensionNode> extensionIdMap;
    private RestActionsRequestHandler restActionsRequestHandler;
    private CustomSettingsRequestHandler customSettingsRequestHandler;
    private TransportService transportService;
    private ClusterService clusterService;
    private Settings environmentSettings;
    private AddSettingsUpdateConsumerRequestHandler addSettingsUpdateConsumerRequestHandler;
    private NodeClient client;

    public ExtensionsManager() {
        this.extensionsPath = Path.of("", new String[0]);
    }

    public ExtensionsManager(Settings settings, Path extensionsPath) throws IOException {
        logger.info("ExtensionsManager initialized");
        this.extensionsPath = extensionsPath;
        this.extensions = new ArrayList<DiscoveryExtensionNode>();
        this.extensionIdMap = new HashMap<String, DiscoveryExtensionNode>();
        this.transportService = null;
        this.clusterService = null;
        this.client = null;
        this.extensionTransportActionsHandler = null;
        this.discover();
    }

    public void initializeServicesAndRestHandler(RestController restController, SettingsModule settingsModule, TransportService transportService, ClusterService clusterService, Settings initialEnvironmentSettings, NodeClient client) {
        this.restActionsRequestHandler = new RestActionsRequestHandler(restController, this.extensionIdMap, transportService);
        this.customSettingsRequestHandler = new CustomSettingsRequestHandler(settingsModule);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.environmentSettings = initialEnvironmentSettings;
        this.addSettingsUpdateConsumerRequestHandler = new AddSettingsUpdateConsumerRequestHandler(clusterService, transportService, REQUEST_EXTENSION_UPDATE_SETTINGS);
        this.client = client;
        this.extensionTransportActionsHandler = new ExtensionTransportActionsHandler(this.extensionIdMap, transportService, client);
        this.registerRequestHandler();
    }

    public ExtensionActionResponse handleTransportRequest(ExtensionActionRequest request) throws Exception {
        return this.extensionTransportActionsHandler.sendTransportRequestToExtension(request);
    }

    private void registerRequestHandler() {
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_REGISTER_REST_ACTIONS, "generic", false, false, RegisterRestActionsRequest::new, (request, channel, task) -> channel.sendResponse(this.restActionsRequestHandler.handleRegisterRestActionsRequest((RegisterRestActionsRequest)request)));
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_REGISTER_CUSTOM_SETTINGS, "generic", false, false, RegisterCustomSettingsRequest::new, (request, channel, task) -> channel.sendResponse(this.customSettingsRequestHandler.handleRegisterCustomSettingsRequest((RegisterCustomSettingsRequest)request)));
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_CLUSTER_STATE, "generic", false, false, ExtensionRequest::new, (request, channel, task) -> channel.sendResponse(this.handleExtensionRequest((ExtensionRequest)request)));
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_CLUSTER_SETTINGS, "generic", false, false, ExtensionRequest::new, (request, channel, task) -> channel.sendResponse(this.handleExtensionRequest((ExtensionRequest)request)));
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_ENVIRONMENT_SETTINGS, "generic", false, false, ExtensionRequest::new, (request, channel, task) -> channel.sendResponse(this.handleExtensionRequest((ExtensionRequest)request)));
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_DEPENDENCY_INFORMATION, "generic", false, false, ExtensionRequest::new, (request, channel, task) -> channel.sendResponse(this.handleExtensionRequest((ExtensionRequest)request)));
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_ADD_SETTINGS_UPDATE_CONSUMER, "generic", false, false, AddSettingsUpdateConsumerRequest::new, (request, channel, task) -> channel.sendResponse(this.addSettingsUpdateConsumerRequestHandler.handleAddSettingsUpdateConsumerRequest((AddSettingsUpdateConsumerRequest)request)));
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_REGISTER_TRANSPORT_ACTIONS, "generic", false, false, RegisterTransportActionsRequest::new, (request, channel, task) -> channel.sendResponse(this.extensionTransportActionsHandler.handleRegisterTransportActionsRequest((RegisterTransportActionsRequest)request)));
        this.transportService.registerRequestHandler(TRANSPORT_ACTION_REQUEST_FROM_EXTENSION, "generic", false, false, TransportActionRequestFromExtension::new, (request, channel, task) -> channel.sendResponse(this.extensionTransportActionsHandler.handleTransportActionRequestFromExtension((TransportActionRequestFromExtension)request)));
    }

    private void discover() throws IOException {
        logger.info("Loading extensions : {}", (Object)this.extensionsPath);
        if (!FileSystemUtils.isAccessibleDirectory(this.extensionsPath, logger)) {
            return;
        }
        List<Object> extensions = new ArrayList();
        if (Files.exists(this.extensionsPath.resolve("extensions.yml"), new LinkOption[0])) {
            try {
                extensions = this.readFromExtensionsYml(this.extensionsPath.resolve("extensions.yml")).getExtensions();
            }
            catch (IOException e) {
                throw new IOException("Could not read from extensions.yml", e);
            }
            for (ExtensionsSettings.Extension extension : extensions) {
                this.loadExtension(extension);
            }
            if (!this.extensionIdMap.isEmpty()) {
                logger.info("Loaded all extensions");
            }
        } else {
            logger.warn("Extensions.yml file is not present.  No extensions will be loaded.");
        }
    }

    private void loadExtension(ExtensionsSettings.Extension extension) throws IOException {
        if (this.extensionIdMap.containsKey(extension.getUniqueId())) {
            logger.info("Duplicate uniqueId " + extension.getUniqueId() + ". Did not load extension: " + extension);
        } else {
            try {
                DiscoveryExtensionNode discoveryExtensionNode = new DiscoveryExtensionNode(extension.getName(), extension.getUniqueId(), new TransportAddress(InetAddress.getByName(extension.getHostAddress()), Integer.parseInt(extension.getPort())), new HashMap<String, String>(), Version.fromString(extension.getOpensearchVersion()), Version.fromString(extension.getMinimumCompatibleVersion()), extension.getDependencies());
                this.extensionIdMap.put(extension.getUniqueId(), discoveryExtensionNode);
                logger.info("Loaded extension with uniqueId " + extension.getUniqueId() + ": " + extension);
            }
            catch (OpenSearchException e) {
                logger.error("Could not load extension with uniqueId " + extension.getUniqueId() + " due to " + e);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
        }
    }

    public void initialize() {
        for (DiscoveryExtensionNode extension : this.extensionIdMap.values()) {
            this.initializeExtension(extension);
        }
    }

    private void initializeExtension(DiscoveryExtensionNode extension) {
        final CompletableFuture inProgressFuture = new CompletableFuture();
        TransportResponseHandler<InitializeExtensionResponse> initializeExtensionResponseHandler = new TransportResponseHandler<InitializeExtensionResponse>(){

            @Override
            public InitializeExtensionResponse read(StreamInput in) throws IOException {
                return new InitializeExtensionResponse(in);
            }

            @Override
            public void handleResponse(InitializeExtensionResponse response) {
                for (DiscoveryExtensionNode extension : ExtensionsManager.this.extensionIdMap.values()) {
                    if (!extension.getName().equals(response.getName())) continue;
                    ExtensionsManager.this.extensions.add(extension);
                    logger.info("Initialized extension: " + extension.getName());
                    break;
                }
                inProgressFuture.complete(response);
            }

            @Override
            public void handleException(TransportException exp) {
                logger.error((Message)new ParameterizedMessage("Extension initialization failed", new Object[0]), (Throwable)exp);
                inProgressFuture.completeExceptionally(exp);
            }

            @Override
            public String executor() {
                return "generic";
            }
        };
        try {
            logger.info("Sending extension request type: internal:discovery/extensions");
            this.transportService.connectToExtensionNode(extension);
            this.transportService.sendRequest(extension, REQUEST_EXTENSION_ACTION_NAME, new InitializeExtensionRequest(this.transportService.getLocalNode(), extension), initializeExtensionResponseHandler);
            inProgressFuture.orTimeout(10L, TimeUnit.SECONDS).join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof TimeoutException) {
                logger.info("No response from extension to request.");
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    TransportResponse handleExtensionRequest(ExtensionRequest extensionRequest) throws Exception {
        switch (extensionRequest.getRequestType()) {
            case REQUEST_EXTENSION_CLUSTER_STATE: {
                return new ClusterStateResponse(this.clusterService.getClusterName(), this.clusterService.state(), false);
            }
            case REQUEST_EXTENSION_CLUSTER_SETTINGS: {
                return new ClusterSettingsResponse(this.clusterService);
            }
            case REQUEST_EXTENSION_ENVIRONMENT_SETTINGS: {
                return new EnvironmentSettingsResponse(this.environmentSettings);
            }
            case REQUEST_EXTENSION_DEPENDENCY_INFORMATION: {
                String uniqueId = extensionRequest.getUniqueId().orElse(null);
                if (uniqueId == null) {
                    return new ExtensionDependencyResponse(this.extensions);
                }
                ExtensionDependency matchingId = new ExtensionDependency(uniqueId, Version.CURRENT);
                return new ExtensionDependencyResponse(this.extensions.stream().filter(e -> e.dependenciesContain(matchingId)).collect(Collectors.toList()));
            }
        }
        throw new IllegalArgumentException("Handler not present for the provided request");
    }

    public void onIndexModule(IndexModule indexModule) throws UnknownHostException {
        for (DiscoveryNode discoveryNode : this.extensionIdMap.values()) {
            this.onIndexModule(indexModule, discoveryNode);
        }
    }

    private void onIndexModule(final IndexModule indexModule, final DiscoveryNode extensionNode) throws UnknownHostException {
        logger.info("onIndexModule index:" + indexModule.getIndex());
        final CompletableFuture inProgressFuture = new CompletableFuture();
        final CompletableFuture inProgressIndexNameFuture = new CompletableFuture();
        final TransportResponseHandler<AcknowledgedResponse> acknowledgedResponseHandler = new TransportResponseHandler<AcknowledgedResponse>(){

            @Override
            public void handleResponse(AcknowledgedResponse response) {
                logger.info("ACK Response" + response);
                inProgressIndexNameFuture.complete(response);
            }

            @Override
            public void handleException(TransportException exp) {
                inProgressIndexNameFuture.completeExceptionally(exp);
            }

            @Override
            public String executor() {
                return "generic";
            }

            @Override
            public AcknowledgedResponse read(StreamInput in) throws IOException {
                return new AcknowledgedResponse(in);
            }
        };
        TransportResponseHandler<IndicesModuleResponse> indicesModuleResponseHandler = new TransportResponseHandler<IndicesModuleResponse>(){

            @Override
            public IndicesModuleResponse read(StreamInput in) throws IOException {
                return new IndicesModuleResponse(in);
            }

            @Override
            public void handleResponse(IndicesModuleResponse response) {
                logger.info("received {}", (Object)response);
                if (response.getIndexEventListener()) {
                    indexModule.addIndexEventListener(new IndexEventListener(){

                        @Override
                        public void beforeIndexRemoved(IndexService indexService, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
                            logger.info("Index Event Listener is called");
                            String indexName = indexService.index().getName();
                            logger.info("Index Name" + indexName.toString());
                            try {
                                logger.info("Sending extension request type: indices:internal/name");
                                ExtensionsManager.this.transportService.sendRequest(extensionNode, ExtensionsManager.INDICES_EXTENSION_NAME_ACTION_NAME, new IndicesModuleRequest(indexModule), acknowledgedResponseHandler);
                                inProgressIndexNameFuture.orTimeout(10L, TimeUnit.SECONDS).join();
                            }
                            catch (CompletionException e) {
                                if (e.getCause() instanceof TimeoutException) {
                                    logger.info("No response from extension to request.");
                                }
                                if (e.getCause() instanceof RuntimeException) {
                                    throw (RuntimeException)e.getCause();
                                }
                                if (e.getCause() instanceof Error) {
                                    throw (Error)e.getCause();
                                }
                                throw new RuntimeException(e.getCause());
                            }
                        }
                    });
                }
                inProgressFuture.complete(response);
            }

            @Override
            public void handleException(TransportException exp) {
                logger.error((Message)new ParameterizedMessage("IndicesModuleRequest failed", new Object[0]), (Throwable)exp);
                inProgressFuture.completeExceptionally(exp);
            }

            @Override
            public String executor() {
                return "generic";
            }
        };
        try {
            logger.info("Sending extension request type: indices:internal/extensions");
            this.transportService.sendRequest(extensionNode, INDICES_EXTENSION_POINT_ACTION_NAME, new IndicesModuleRequest(indexModule), indicesModuleResponseHandler);
            inProgressFuture.orTimeout(10L, TimeUnit.SECONDS).join();
            logger.info("Received response from Extension");
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof TimeoutException) {
                logger.info("No response from extension to request.");
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private ExtensionsSettings readFromExtensionsYml(Path filePath) throws IOException {
        Yaml yaml = new Yaml(new SafeConstructor());
        try (InputStream inputStream = Files.newInputStream(filePath, new OpenOption[0]);){
            Map obj = (Map)yaml.load(inputStream);
            if (obj == null) {
                inputStream.close();
                throw new IOException("extensions.yml is empty");
            }
            ArrayList unreadExtensions = new ArrayList((Collection)obj.get("extensions"));
            ArrayList<ExtensionsSettings.Extension> readExtensions = new ArrayList<ExtensionsSettings.Extension>();
            for (HashMap extensionMap : unreadExtensions) {
                ArrayList<ExtensionDependency> extensionDependencyList = new ArrayList<ExtensionDependency>();
                if (extensionMap.get("dependencies") != null) {
                    ArrayList extensionDependencies = new ArrayList((Collection)extensionMap.get("dependencies"));
                    for (HashMap dependency : extensionDependencies) {
                        extensionDependencyList.add(new ExtensionDependency(dependency.get("uniqueId").toString(), Version.fromString(dependency.get("version").toString())));
                    }
                }
                readExtensions.add(new ExtensionsSettings.Extension(extensionMap.get("name").toString(), extensionMap.get("uniqueId").toString(), extensionMap.get("hostAddress").toString(), extensionMap.get("port").toString(), extensionMap.get("version").toString(), extensionMap.get("opensearchVersion").toString(), extensionMap.get("minimumCompatibleVersion").toString(), extensionDependencyList));
            }
            inputStream.close();
            ExtensionsSettings extensionsSettings = new ExtensionsSettings(readExtensions);
            return extensionsSettings;
        }
    }

    public static String getRequestExtensionActionName() {
        return REQUEST_EXTENSION_ACTION_NAME;
    }

    public static String getIndicesExtensionPointActionName() {
        return INDICES_EXTENSION_POINT_ACTION_NAME;
    }

    public static String getIndicesExtensionNameActionName() {
        return INDICES_EXTENSION_NAME_ACTION_NAME;
    }

    public static String getRequestExtensionClusterState() {
        return REQUEST_EXTENSION_CLUSTER_STATE;
    }

    public static String getRequestExtensionClusterSettings() {
        return REQUEST_EXTENSION_CLUSTER_SETTINGS;
    }

    public static Logger getLogger() {
        return logger;
    }

    public Path getExtensionsPath() {
        return this.extensionsPath;
    }

    public List<DiscoveryExtensionNode> getExtensions() {
        return this.extensions;
    }

    public TransportService getTransportService() {
        return this.transportService;
    }

    public ClusterService getClusterService() {
        return this.clusterService;
    }

    public static String getRequestExtensionRegisterRestActions() {
        return REQUEST_EXTENSION_REGISTER_REST_ACTIONS;
    }

    public static String getRequestOpensearchParseNamedWriteable() {
        return REQUEST_OPENSEARCH_PARSE_NAMED_WRITEABLE;
    }

    public static String getRequestRestExecuteOnExtensionAction() {
        return REQUEST_REST_EXECUTE_ON_EXTENSION_ACTION;
    }

    public Map<String, DiscoveryExtensionNode> getExtensionIdMap() {
        return this.extensionIdMap;
    }

    public RestActionsRequestHandler getRestActionsRequestHandler() {
        return this.restActionsRequestHandler;
    }

    public void setExtensions(List<DiscoveryExtensionNode> extensions) {
        this.extensions = extensions;
    }

    public void setExtensionIdMap(Map<String, DiscoveryExtensionNode> extensionIdMap) {
        this.extensionIdMap = extensionIdMap;
    }

    public void setRestActionsRequestHandler(RestActionsRequestHandler restActionsRequestHandler) {
        this.restActionsRequestHandler = restActionsRequestHandler;
    }

    public void setTransportService(TransportService transportService) {
        this.transportService = transportService;
    }

    public void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public static String getRequestExtensionRegisterTransportActions() {
        return REQUEST_EXTENSION_REGISTER_TRANSPORT_ACTIONS;
    }

    public static String getRequestExtensionRegisterCustomSettings() {
        return REQUEST_EXTENSION_REGISTER_CUSTOM_SETTINGS;
    }

    public CustomSettingsRequestHandler getCustomSettingsRequestHandler() {
        return this.customSettingsRequestHandler;
    }

    public void setCustomSettingsRequestHandler(CustomSettingsRequestHandler customSettingsRequestHandler) {
        this.customSettingsRequestHandler = customSettingsRequestHandler;
    }

    public static String getRequestExtensionEnvironmentSettings() {
        return REQUEST_EXTENSION_ENVIRONMENT_SETTINGS;
    }

    public static String getRequestExtensionAddSettingsUpdateConsumer() {
        return REQUEST_EXTENSION_ADD_SETTINGS_UPDATE_CONSUMER;
    }

    public static String getRequestExtensionUpdateSettings() {
        return REQUEST_EXTENSION_UPDATE_SETTINGS;
    }

    public AddSettingsUpdateConsumerRequestHandler getAddSettingsUpdateConsumerRequestHandler() {
        return this.addSettingsUpdateConsumerRequestHandler;
    }

    public void setAddSettingsUpdateConsumerRequestHandler(AddSettingsUpdateConsumerRequestHandler addSettingsUpdateConsumerRequestHandler) {
        this.addSettingsUpdateConsumerRequestHandler = addSettingsUpdateConsumerRequestHandler;
    }

    public Settings getEnvironmentSettings() {
        return this.environmentSettings;
    }

    public void setEnvironmentSettings(Settings environmentSettings) {
        this.environmentSettings = environmentSettings;
    }

    public static String getRequestExtensionHandleTransportAction() {
        return REQUEST_EXTENSION_HANDLE_TRANSPORT_ACTION;
    }

    public static String getTransportActionRequestFromExtension() {
        return TRANSPORT_ACTION_REQUEST_FROM_EXTENSION;
    }

    public static int getExtensionRequestWaitTimeout() {
        return 10;
    }

    public ExtensionTransportActionsHandler getExtensionTransportActionsHandler() {
        return this.extensionTransportActionsHandler;
    }

    public void setExtensionTransportActionsHandler(ExtensionTransportActionsHandler extensionTransportActionsHandler) {
        this.extensionTransportActionsHandler = extensionTransportActionsHandler;
    }

    public NodeClient getClient() {
        return this.client;
    }

    public void setClient(NodeClient client) {
        this.client = client;
    }

    public static enum RequestType {
        REQUEST_EXTENSION_CLUSTER_STATE,
        REQUEST_EXTENSION_CLUSTER_SETTINGS,
        REQUEST_EXTENSION_REGISTER_REST_ACTIONS,
        REQUEST_EXTENSION_REGISTER_SETTINGS,
        REQUEST_EXTENSION_ENVIRONMENT_SETTINGS,
        REQUEST_EXTENSION_DEPENDENCY_INFORMATION,
        CREATE_COMPONENT,
        ON_INDEX_MODULE,
        GET_SETTINGS;

    }

    public static enum OpenSearchRequestType {
        REQUEST_OPENSEARCH_NAMED_WRITEABLE_REGISTRY;

    }
}

