/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.fielddata.ordinals;

import java.io.IOException;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;

final class GlobalOrdinalMapping
extends SortedSetDocValues {
    private final SortedSetDocValues values;
    private final OrdinalMap ordinalMap;
    private final LongValues mapping;
    private final TermsEnum[] lookups;

    GlobalOrdinalMapping(OrdinalMap ordinalMap, SortedSetDocValues values, TermsEnum[] lookups, int segmentIndex) {
        this.values = values;
        this.lookups = lookups;
        this.ordinalMap = ordinalMap;
        this.mapping = ordinalMap.getGlobalOrds(segmentIndex);
    }

    @Override
    public long getValueCount() {
        return this.ordinalMap.getValueCount();
    }

    public long getGlobalOrd(long segmentOrd) {
        return this.mapping.get(segmentOrd);
    }

    @Override
    public boolean advanceExact(int target) throws IOException {
        return this.values.advanceExact(target);
    }

    @Override
    public long nextOrd() throws IOException {
        long segmentOrd = this.values.nextOrd();
        if (segmentOrd == -1L) {
            return -1L;
        }
        return this.getGlobalOrd(segmentOrd);
    }

    @Override
    public BytesRef lookupOrd(long globalOrd) throws IOException {
        long segmentOrd = this.ordinalMap.getFirstSegmentOrd(globalOrd);
        int readerIndex = this.ordinalMap.getFirstSegmentNumber(globalOrd);
        this.lookups[readerIndex].seekExact(segmentOrd);
        return this.lookups[readerIndex].term();
    }

    @Override
    public int docID() {
        return this.values.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        return this.values.nextDoc();
    }

    @Override
    public int advance(int target) throws IOException {
        return this.values.advance(target);
    }

    @Override
    public long cost() {
        return this.values.cost();
    }

    @Override
    public int docValueCount() {
        return this.values.docValueCount();
    }
}

