/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.rankeval;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionResponse;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.common.io.stream.NamedWriteableRegistry;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.index.rankeval.DiscountedCumulativeGain;
import org.opensearch.index.rankeval.EvaluationMetric;
import org.opensearch.index.rankeval.ExpectedReciprocalRank;
import org.opensearch.index.rankeval.MeanReciprocalRank;
import org.opensearch.index.rankeval.MetricDetail;
import org.opensearch.index.rankeval.PrecisionAtK;
import org.opensearch.index.rankeval.RankEvalAction;
import org.opensearch.index.rankeval.RankEvalNamedXContentProvider;
import org.opensearch.index.rankeval.RecallAtK;
import org.opensearch.index.rankeval.RestRankEvalAction;
import org.opensearch.index.rankeval.TransportRankEvalAction;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;

public class RankEvalPlugin
extends Plugin
implements ActionPlugin {
    @Override
    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler(RankEvalAction.INSTANCE, TransportRankEvalAction.class, new Class[0]));
    }

    @Override
    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Collections.singletonList(new RestRankEvalAction());
    }

    @Override
    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> namedWriteables = new ArrayList<NamedWriteableRegistry.Entry>();
        namedWriteables.add(new NamedWriteableRegistry.Entry(EvaluationMetric.class, "precision", PrecisionAtK::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(EvaluationMetric.class, "recall", RecallAtK::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(EvaluationMetric.class, "mean_reciprocal_rank", MeanReciprocalRank::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(EvaluationMetric.class, "dcg", DiscountedCumulativeGain::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(EvaluationMetric.class, "expected_reciprocal_rank", ExpectedReciprocalRank::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(MetricDetail.class, "precision", PrecisionAtK.Detail::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(MetricDetail.class, "recall", RecallAtK.Detail::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(MetricDetail.class, "mean_reciprocal_rank", MeanReciprocalRank.Detail::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(MetricDetail.class, "dcg", DiscountedCumulativeGain.Detail::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(MetricDetail.class, "expected_reciprocal_rank", ExpectedReciprocalRank.Detail::new));
        return namedWriteables;
    }

    @Override
    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return new RankEvalNamedXContentProvider().getNamedXContentParsers();
    }
}

