/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.reindex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchParseException;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.common.Nullable;
import org.opensearch.common.ParseField;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.ObjectParser;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.index.reindex.BulkByScrollResponseBuilder;
import org.opensearch.index.reindex.BulkByScrollTask;
import org.opensearch.index.reindex.ScrollableHitSource;
import org.opensearch.rest.RestStatus;

public class BulkByScrollResponse
extends ActionResponse
implements ToXContentFragment {
    private TimeValue took;
    private BulkByScrollTask.Status status;
    private List<BulkItemResponse.Failure> bulkFailures;
    private List<ScrollableHitSource.SearchFailure> searchFailures;
    private boolean timedOut;
    private static final String TOOK_FIELD = "took";
    private static final String TIMED_OUT_FIELD = "timed_out";
    private static final String FAILURES_FIELD = "failures";
    private static final ObjectParser<BulkByScrollResponseBuilder, Void> PARSER = new ObjectParser("bulk_by_scroll_response", true, BulkByScrollResponseBuilder::new);

    public BulkByScrollResponse(StreamInput in) throws IOException {
        super(in);
        this.took = in.readTimeValue();
        this.status = new BulkByScrollTask.Status(in);
        this.bulkFailures = in.readList(BulkItemResponse.Failure::new);
        this.searchFailures = in.readList(ScrollableHitSource.SearchFailure::new);
        this.timedOut = in.readBoolean();
    }

    public BulkByScrollResponse(TimeValue took, BulkByScrollTask.Status status, List<BulkItemResponse.Failure> bulkFailures, List<ScrollableHitSource.SearchFailure> searchFailures, boolean timedOut) {
        this.took = took;
        this.status = Objects.requireNonNull(status, "Null status not supported");
        this.bulkFailures = bulkFailures;
        this.searchFailures = searchFailures;
        this.timedOut = timedOut;
    }

    public BulkByScrollResponse(Iterable<BulkByScrollResponse> toMerge, @Nullable String reasonCancelled) {
        long mergedTook = 0L;
        ArrayList<BulkByScrollTask.StatusOrException> statuses = new ArrayList<BulkByScrollTask.StatusOrException>();
        this.bulkFailures = new ArrayList<BulkItemResponse.Failure>();
        this.searchFailures = new ArrayList<ScrollableHitSource.SearchFailure>();
        for (BulkByScrollResponse response : toMerge) {
            mergedTook = Math.max(mergedTook, response.getTook().nanos());
            statuses.add(new BulkByScrollTask.StatusOrException(response.status));
            this.bulkFailures.addAll(response.getBulkFailures());
            this.searchFailures.addAll(response.getSearchFailures());
            this.timedOut |= response.isTimedOut();
        }
        this.took = TimeValue.timeValueNanos(mergedTook);
        this.status = new BulkByScrollTask.Status(statuses, reasonCancelled);
    }

    public TimeValue getTook() {
        return this.took;
    }

    public BulkByScrollTask.Status getStatus() {
        return this.status;
    }

    public long getCreated() {
        return this.status.getCreated();
    }

    public long getTotal() {
        return this.status.getTotal();
    }

    public long getDeleted() {
        return this.status.getDeleted();
    }

    public long getUpdated() {
        return this.status.getUpdated();
    }

    public int getBatches() {
        return this.status.getBatches();
    }

    public long getVersionConflicts() {
        return this.status.getVersionConflicts();
    }

    public long getNoops() {
        return this.status.getNoops();
    }

    public String getReasonCancelled() {
        return this.status.getReasonCancelled();
    }

    public long getBulkRetries() {
        return this.status.getBulkRetries();
    }

    public long getSearchRetries() {
        return this.status.getSearchRetries();
    }

    public List<BulkItemResponse.Failure> getBulkFailures() {
        return this.bulkFailures;
    }

    public List<ScrollableHitSource.SearchFailure> getSearchFailures() {
        return this.searchFailures;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeTimeValue(this.took);
        this.status.writeTo(out);
        out.writeList(this.bulkFailures);
        out.writeList(this.searchFailures);
        out.writeBoolean(this.timedOut);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(TOOK_FIELD, this.took.millis());
        builder.field(TIMED_OUT_FIELD, this.timedOut);
        this.status.innerXContent(builder, params);
        builder.startArray(FAILURES_FIELD);
        for (BulkItemResponse.Failure failure : this.bulkFailures) {
            builder.startObject();
            failure.toXContent(builder, params);
            builder.endObject();
        }
        for (ScrollableHitSource.SearchFailure searchFailure : this.searchFailures) {
            searchFailure.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static BulkByScrollResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null).buildResponse();
    }

    private static Object parseFailure(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        String index = null;
        String id = null;
        Integer status = null;
        Integer shardId = null;
        String nodeId = null;
        OpenSearchException bulkExc = null;
        OpenSearchException searchExc = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
            String name = parser.currentName();
            token = parser.nextToken();
            if (token == XContentParser.Token.START_ARRAY) {
                parser.skipChildren();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                switch (name) {
                    case "reason": {
                        searchExc = OpenSearchException.fromXContent(parser);
                        break;
                    }
                    case "cause": {
                        bulkExc = OpenSearchException.fromXContent(parser);
                        break;
                    }
                    default: {
                        parser.skipChildren();
                        break;
                    }
                }
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                switch (name) {
                    case "index": {
                        index = parser.text();
                        break;
                    }
                    case "id": {
                        id = parser.text();
                        break;
                    }
                    case "node": {
                        nodeId = parser.text();
                        break;
                    }
                }
                continue;
            }
            if (token != XContentParser.Token.VALUE_NUMBER) continue;
            switch (name) {
                case "status": {
                    status = parser.intValue();
                    break;
                }
                case "shard": {
                    shardId = parser.intValue();
                    break;
                }
            }
        }
        if (bulkExc != null) {
            return new BulkItemResponse.Failure(index, id, bulkExc, RestStatus.fromCode(status));
        }
        if (searchExc != null) {
            if (status == null) {
                return new ScrollableHitSource.SearchFailure(searchExc, index, shardId, nodeId);
            }
            return new ScrollableHitSource.SearchFailure(searchExc, index, shardId, nodeId, RestStatus.fromCode(status));
        }
        throw new OpenSearchParseException("failed to parse failures array. At least one of {reason,cause} must be present", new Object[0]);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append("[");
        builder.append("took=").append(this.took).append(',');
        builder.append("timed_out=").append(this.timedOut).append(',');
        this.status.innerToString(builder);
        builder.append(",bulk_failures=").append(this.getBulkFailures().subList(0, Math.min(3, this.getBulkFailures().size())));
        builder.append(",search_failures=").append(this.getSearchFailures().subList(0, Math.min(3, this.getSearchFailures().size())));
        return builder.append(']').toString();
    }

    static {
        PARSER.declareLong(BulkByScrollResponseBuilder::setTook, new ParseField(TOOK_FIELD, new String[0]));
        PARSER.declareBoolean(BulkByScrollResponseBuilder::setTimedOut, new ParseField(TIMED_OUT_FIELD, new String[0]));
        PARSER.declareObjectArray(BulkByScrollResponseBuilder::setFailures, (p, c) -> BulkByScrollResponse.parseFailure(p), new ParseField(FAILURES_FIELD, new String[0]));
        BulkByScrollTask.Status.declareFields(PARSER);
    }
}

