/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;
import org.opensearch.common.util.concurrent.ReleasableLock;
import org.opensearch.core.internal.io.IOUtils;
import org.opensearch.index.engine.LifecycleAware;
import org.opensearch.index.seqno.LocalCheckpointTracker;
import org.opensearch.index.shard.ShardId;
import org.opensearch.index.translog.Translog;
import org.opensearch.index.translog.TranslogConfig;
import org.opensearch.index.translog.TranslogDeletionPolicy;
import org.opensearch.index.translog.TranslogException;
import org.opensearch.index.translog.TranslogFactory;
import org.opensearch.index.translog.TranslogManager;
import org.opensearch.index.translog.TranslogRecoveryRunner;
import org.opensearch.index.translog.TranslogStats;
import org.opensearch.index.translog.listener.TranslogEventListener;

public class InternalTranslogManager
implements TranslogManager,
Closeable {
    private final ReleasableLock readLock;
    private final LifecycleAware engineLifeCycleAware;
    private final ShardId shardId;
    private final Translog translog;
    private final AtomicBoolean pendingTranslogRecovery = new AtomicBoolean(false);
    private final TranslogEventListener translogEventListener;
    private final Supplier<LocalCheckpointTracker> localCheckpointTrackerSupplier;
    private static final Logger logger = LogManager.getLogger(InternalTranslogManager.class);

    public AtomicBoolean getPendingTranslogRecovery() {
        return this.pendingTranslogRecovery;
    }

    public InternalTranslogManager(TranslogConfig translogConfig, LongSupplier primaryTermSupplier, LongSupplier globalCheckpointSupplier, TranslogDeletionPolicy translogDeletionPolicy, ShardId shardId, ReleasableLock readLock, Supplier<LocalCheckpointTracker> localCheckpointTrackerSupplier, String translogUUID, TranslogEventListener translogEventListener, LifecycleAware engineLifeCycleAware, TranslogFactory translogFactory, BooleanSupplier primaryModeSupplier) throws IOException {
        this.shardId = shardId;
        this.readLock = readLock;
        this.engineLifeCycleAware = engineLifeCycleAware;
        this.translogEventListener = translogEventListener;
        this.localCheckpointTrackerSupplier = localCheckpointTrackerSupplier;
        Translog translog = this.openTranslog(translogConfig, primaryTermSupplier, translogDeletionPolicy, globalCheckpointSupplier, seqNo -> {
            LocalCheckpointTracker tracker = (LocalCheckpointTracker)localCheckpointTrackerSupplier.get();
            assert (tracker != null || !this.getTranslog(true).isOpen());
            if (tracker != null) {
                tracker.markSeqNoAsPersisted(seqNo);
            }
        }, translogUUID, translogFactory, primaryModeSupplier);
        assert (translog.getGeneration() != null);
        this.translog = translog;
        assert (!this.pendingTranslogRecovery.get()) : "translog recovery can't be pending before we set it";
        this.pendingTranslogRecovery.set(true);
    }

    @Override
    public void rollTranslogGeneration() throws TranslogException {
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.engineLifeCycleAware.ensureOpen();
            this.translog.rollGeneration();
            this.translog.trimUnreferencedReaders();
        }
        catch (AlreadyClosedException e) {
            this.translogEventListener.onFailure("translog roll generation failed", e);
            throw e;
        }
        catch (Exception e) {
            try {
                this.translogEventListener.onFailure("translog roll generation failed", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw new TranslogException(this.shardId, "failed to roll translog", e);
        }
    }

    @Override
    public int recoverFromTranslog(TranslogRecoveryRunner translogRecoveryRunner, long localCheckpoint, long recoverUpToSeqNo) throws IOException {
        int opsRecovered = 0;
        this.translogEventListener.onBeginTranslogRecovery();
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.engineLifeCycleAware.ensureOpen();
            if (!this.pendingTranslogRecovery.get()) {
                throw new IllegalStateException("Engine has already been recovered");
            }
            try {
                opsRecovered = this.recoverFromTranslogInternal(translogRecoveryRunner, localCheckpoint, recoverUpToSeqNo);
            }
            catch (Exception e) {
                try {
                    this.pendingTranslogRecovery.set(true);
                    this.translogEventListener.onFailure("failed to recover from translog", e);
                }
                catch (Exception inner) {
                    e.addSuppressed(inner);
                }
                throw e;
            }
        }
        return opsRecovered;
    }

    private int recoverFromTranslogInternal(TranslogRecoveryRunner translogRecoveryRunner, long localCheckpoint, long recoverUpToSeqNo) {
        int opsRecovered;
        block10: {
            if (localCheckpoint < recoverUpToSeqNo) {
                try (Translog.Snapshot snapshot = this.translog.newSnapshot(localCheckpoint + 1L, recoverUpToSeqNo);){
                    opsRecovered = translogRecoveryRunner.run(snapshot);
                    break block10;
                }
                catch (Exception e) {
                    throw new TranslogException(this.shardId, "failed to recover from translog", e);
                }
            }
            opsRecovered = 0;
        }
        assert (this.pendingTranslogRecovery.get()) : "translogRecovery is not pending but should be";
        this.pendingTranslogRecovery.set(false);
        logger.trace(() -> new ParameterizedMessage("flushing post recovery from translog: ops recovered [{}], current translog generation [{}]", (Object)opsRecovered, (Object)this.translog.currentFileGeneration()));
        this.translogEventListener.onAfterTranslogRecovery();
        return opsRecovered;
    }

    @Override
    public boolean isTranslogSyncNeeded() {
        return this.getTranslog(true).syncNeeded();
    }

    @Override
    public boolean ensureTranslogSynced(Stream<Translog.Location> locations) throws IOException {
        boolean synced = this.translog.ensureSynced(locations);
        if (synced) {
            this.translogEventListener.onAfterTranslogSync();
        }
        return synced;
    }

    @Override
    public void syncTranslog() throws IOException {
        this.translog.sync();
        this.translogEventListener.onAfterTranslogSync();
    }

    @Override
    public TranslogStats getTranslogStats() {
        return this.getTranslog(true).stats();
    }

    @Override
    public Translog.Location getTranslogLastWriteLocation() {
        return this.getTranslog(true).getLastWriteLocation();
    }

    @Override
    public void trimUnreferencedTranslogFiles() throws TranslogException {
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.engineLifeCycleAware.ensureOpen();
            this.translog.trimUnreferencedReaders();
        }
        catch (AlreadyClosedException e) {
            this.translogEventListener.onFailure("translog trimming unreferenced translog failed", e);
            throw e;
        }
        catch (Exception e) {
            try {
                this.translogEventListener.onFailure("translog trimming unreferenced translog failed", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw new TranslogException(this.shardId, "failed to trim unreferenced translog translog", e);
        }
    }

    @Override
    public boolean shouldRollTranslogGeneration() {
        return this.getTranslog(true).shouldRollGeneration();
    }

    @Override
    public void trimOperationsFromTranslog(long belowTerm, long aboveSeqNo) throws TranslogException {
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.engineLifeCycleAware.ensureOpen();
            this.translog.trimOperations(belowTerm, aboveSeqNo);
        }
        catch (AlreadyClosedException e) {
            this.translogEventListener.onFailure("translog operations trimming failed", e);
            throw e;
        }
        catch (Exception e) {
            try {
                this.translogEventListener.onFailure("translog operations trimming failed", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw new TranslogException(this.shardId, "failed to trim translog operations", e);
        }
    }

    @Override
    public int restoreLocalHistoryFromTranslog(long processedCheckpoint, TranslogRecoveryRunner translogRecoveryRunner) throws IOException {
        try (ReleasableLock ignored = this.readLock.acquire();){
            int n;
            block12: {
                this.engineLifeCycleAware.ensureOpen();
                Translog.Snapshot snapshot = this.getTranslog(true).newSnapshot(processedCheckpoint + 1L, Long.MAX_VALUE);
                try {
                    n = translogRecoveryRunner.run(snapshot);
                    if (snapshot == null) break block12;
                }
                catch (Throwable throwable) {
                    if (snapshot != null) {
                        try {
                            snapshot.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                snapshot.close();
            }
            return n;
        }
    }

    @Override
    public void ensureCanFlush() {
        if (this.pendingTranslogRecovery.get()) {
            throw new IllegalStateException(this.shardId.toString() + " flushes are disabled - pending translog recovery");
        }
    }

    @Override
    public void setMinSeqNoToKeep(long seqNo) {
        this.translog.setMinSeqNoToKeep(seqNo);
    }

    @Override
    public Translog.Operation readOperation(Translog.Location location) throws IOException {
        return this.translog.readOperation(location);
    }

    @Override
    public Translog.Location add(Translog.Operation operation) throws IOException {
        return this.translog.add(operation);
    }

    @Override
    public void skipTranslogRecovery() {
        assert (this.pendingTranslogRecovery.get()) : "translogRecovery is not pending but should be";
        this.pendingTranslogRecovery.set(false);
    }

    public Translog getTranslog() {
        return this.translog;
    }

    private Translog getTranslog(boolean ensureOpen) {
        if (ensureOpen) {
            this.engineLifeCycleAware.ensureOpen();
        }
        return this.translog;
    }

    protected Translog openTranslog(TranslogConfig translogConfig, LongSupplier primaryTermSupplier, TranslogDeletionPolicy translogDeletionPolicy, LongSupplier globalCheckpointSupplier, LongConsumer persistedSequenceNumberConsumer, String translogUUID, TranslogFactory translogFactory, BooleanSupplier primaryModeSupplier) throws IOException {
        return translogFactory.newTranslog(translogConfig, translogUUID, translogDeletionPolicy, globalCheckpointSupplier, primaryTermSupplier, persistedSequenceNumberConsumer, primaryModeSupplier);
    }

    public long getLastSyncedGlobalCheckpoint() {
        return this.translog.getLastSyncedGlobalCheckpoint();
    }

    public long getMaxSeqNo() {
        return this.translog.getMaxSeqNo();
    }

    public void trimUnreferencedReaders() throws IOException {
        this.translog.trimUnreferencedReaders();
    }

    public TranslogDeletionPolicy getDeletionPolicy() {
        return this.translog.getDeletionPolicy();
    }

    public Exception getTragicExceptionIfClosed() {
        return !this.translog.isOpen() ? this.translog.getTragicException() : null;
    }

    public String getTranslogUUID() {
        return this.translog.getTranslogUUID();
    }

    public boolean shouldPeriodicallyFlush(long localCheckpointOfLastCommit, long flushThreshold) {
        long translogGenerationOfLastCommit = this.translog.getMinGenerationForSeqNo((long)(localCheckpointOfLastCommit + 1L)).translogFileGeneration;
        if (this.translog.sizeInBytesByMinGen(translogGenerationOfLastCommit) < flushThreshold) {
            return false;
        }
        long translogGenerationOfNewCommit = this.translog.getMinGenerationForSeqNo((long)(this.localCheckpointTrackerSupplier.get().getProcessedCheckpoint() + 1L)).translogFileGeneration;
        return translogGenerationOfLastCommit < translogGenerationOfNewCommit || this.localCheckpointTrackerSupplier.get().getProcessedCheckpoint() == this.localCheckpointTrackerSupplier.get().getMaxSeqNo();
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeWhileHandlingException((Closeable)this.translog);
    }
}

