/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.function.BooleanSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import org.opensearch.common.SetOnce;
import org.opensearch.common.io.FileSystemUtils;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.concurrent.ReleasableLock;
import org.opensearch.core.internal.io.IOUtils;
import org.opensearch.index.shard.ShardId;
import org.opensearch.index.translog.BaseTranslogReader;
import org.opensearch.index.translog.Checkpoint;
import org.opensearch.index.translog.Translog;
import org.opensearch.index.translog.TranslogConfig;
import org.opensearch.index.translog.TranslogDeletionPolicy;
import org.opensearch.index.translog.transfer.BlobStoreTransferService;
import org.opensearch.index.translog.transfer.FileTransferTracker;
import org.opensearch.index.translog.transfer.TransferSnapshot;
import org.opensearch.index.translog.transfer.TranslogCheckpointTransferSnapshot;
import org.opensearch.index.translog.transfer.TranslogTransferManager;
import org.opensearch.index.translog.transfer.TranslogTransferMetadata;
import org.opensearch.index.translog.transfer.listener.TranslogTransferListener;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.threadpool.ThreadPool;

public class RemoteFsTranslog
extends Translog {
    private final BlobStoreRepository blobStoreRepository;
    private final TranslogTransferManager translogTransferManager;
    private final FileTransferTracker fileTransferTracker;
    private final BooleanSupplier primaryModeSupplier;
    private volatile long maxRemoteTranslogGenerationUploaded;
    private volatile long minSeqNoToKeep;
    private volatile long minRemoteGenReferenced;
    private final SetOnce<Boolean> olderPrimaryCleaned = new SetOnce();
    private static final int REMOTE_DELETION_PERMITS = 2;
    private final Semaphore remoteGenerationDeletionPermits = new Semaphore(2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFsTranslog(TranslogConfig config, String translogUUID, TranslogDeletionPolicy deletionPolicy, LongSupplier globalCheckpointSupplier, LongSupplier primaryTermSupplier, LongConsumer persistedSequenceNumberConsumer, BlobStoreRepository blobStoreRepository, ThreadPool threadPool, BooleanSupplier primaryModeSupplier) throws IOException {
        super(config, translogUUID, deletionPolicy, globalCheckpointSupplier, primaryTermSupplier, persistedSequenceNumberConsumer);
        this.blobStoreRepository = blobStoreRepository;
        this.primaryModeSupplier = primaryModeSupplier;
        this.fileTransferTracker = new FileTransferTracker(this.shardId);
        this.translogTransferManager = RemoteFsTranslog.buildTranslogTransferManager(blobStoreRepository, threadPool, this.shardId, this.fileTransferTracker);
        try {
            RemoteFsTranslog.download(this.translogTransferManager, this.location);
            Checkpoint checkpoint = RemoteFsTranslog.readCheckpoint(this.location);
            this.readers.addAll(this.recoverFromFiles(checkpoint));
            if (this.readers.isEmpty()) {
                throw new IllegalStateException("at least one reader must be recovered");
            }
            boolean success = false;
            this.current = null;
            try {
                this.current = this.createWriter(checkpoint.generation + 1L, this.getMinFileGeneration(), checkpoint.globalCheckpoint, persistedSequenceNumberConsumer);
                success = true;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this.readers);
                }
            }
        }
        catch (Exception e) {
            IOUtils.closeWhileHandlingException((Closeable)this.current);
            IOUtils.closeWhileHandlingException(this.readers);
            throw e;
        }
    }

    public static void download(TranslogTransferManager translogTransferManager, Path location) throws IOException {
        TranslogTransferMetadata translogMetadata = translogTransferManager.readMetadata();
        if (translogMetadata != null) {
            if (Files.notExists(location, new LinkOption[0])) {
                Files.createDirectories(location, new FileAttribute[0]);
            }
            for (Path file : FileSystemUtils.files(location)) {
                Files.delete(file);
            }
            Map<String, String> generationToPrimaryTermMapper = translogMetadata.getGenerationToPrimaryTermMapper();
            for (long i = translogMetadata.getGeneration(); i >= translogMetadata.getMinTranslogGeneration(); --i) {
                String generation = Long.toString(i);
                translogTransferManager.downloadTranslog(generationToPrimaryTermMapper.get(generation), generation, location);
            }
            Files.copy(location.resolve(Translog.getCommitCheckpointFileName(translogMetadata.getGeneration())), location.resolve("translog.ckp"), new CopyOption[0]);
        }
    }

    public static TranslogTransferManager buildTranslogTransferManager(BlobStoreRepository blobStoreRepository, ThreadPool threadPool, ShardId shardId, FileTransferTracker fileTransferTracker) {
        return new TranslogTransferManager(new BlobStoreTransferService(blobStoreRepository.blobStore(), threadPool), blobStoreRepository.basePath().add(shardId.getIndex().getUUID()).add(String.valueOf(shardId.id())), fileTransferTracker);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean ensureSynced(Translog.Location location) throws IOException {
        try (ReleasableLock ignored = this.writeLock.acquire();){
            assert (location.generation <= this.current.getGeneration());
            if (location.generation != this.current.getGeneration()) return false;
            this.ensureOpen();
            boolean bl = this.prepareAndUpload(this.primaryTermSupplier.getAsLong(), location.generation);
            return bl;
        }
        catch (Exception ex) {
            this.closeOnTragicEvent(ex);
            throw ex;
        }
    }

    @Override
    public void rollGeneration() throws IOException {
        this.syncBeforeRollGeneration();
        if (this.current.totalOperations() == 0 && this.primaryTermSupplier.getAsLong() == this.current.getPrimaryTerm()) {
            return;
        }
        this.prepareAndUpload(this.primaryTermSupplier.getAsLong(), null);
    }

    /*
     * Unable to fully structure code
     */
    private boolean prepareAndUpload(Long primaryTerm, Long generation) throws IOException {
        ignored = this.writeLock.acquire();
        try {
            if (generation == null || generation.longValue() == this.current.getGeneration()) {
                try {
                    reader = this.current.closeIntoReader();
                    this.readers.add(reader);
                    this.copyCheckpointTo(this.location.resolve(RemoteFsTranslog.getCommitCheckpointFileName(this.current.getGeneration())));
                    if (this.closed.get()) ** GOTO lbl20
                    this.logger.trace("Creating new writer for gen: [{}]", (Object)(this.current.getGeneration() + 1L));
                    this.current = this.createWriter(this.current.getGeneration() + 1L);
                }
                catch (Exception e) {
                    this.tragedy.setTragicException(e);
                    this.closeOnTragicEvent(e);
                    throw e;
                }
            } else if (generation < this.current.getGeneration()) {
                var4_6 = false;
                return var4_6;
            }
lbl20:
            // 4 sources

            if (generation == null) {
                if (!this.closed.get()) {
                    var4_7 = this.upload(primaryTerm, this.current.getGeneration() - 1L);
                    return var4_7;
                }
                var4_8 = this.upload(primaryTerm, this.current.getGeneration());
                return var4_8;
            }
            var4_9 = this.upload(primaryTerm, generation);
            return var4_9;
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    private boolean upload(final Long primaryTerm, final Long generation) throws IOException {
        if (!this.primaryModeSupplier.getAsBoolean()) {
            this.logger.trace("skipped uploading translog for {} {}", (Object)primaryTerm, (Object)generation);
            return true;
        }
        this.logger.trace("uploading translog for {} {}", (Object)primaryTerm, (Object)generation);
        try (TranslogCheckpointTransferSnapshot transferSnapshotProvider = new TranslogCheckpointTransferSnapshot.Builder(primaryTerm, generation, this.location, this.readers, Translog::getCommitCheckpointFileName).build();){
            final Releasable transferReleasable = Releasables.wrap(this.deletionPolicy.acquireTranslogGen(this.getMinFileGeneration()));
            boolean bl = this.translogTransferManager.transferSnapshot(transferSnapshotProvider, new TranslogTransferListener(){

                @Override
                public void onUploadComplete(TransferSnapshot transferSnapshot) throws IOException {
                    transferReleasable.close();
                    RemoteFsTranslog.this.closeFilesIfNoPendingRetentionLocks();
                    RemoteFsTranslog.this.maxRemoteTranslogGenerationUploaded = generation;
                    RemoteFsTranslog.this.minRemoteGenReferenced = RemoteFsTranslog.this.getMinFileGeneration();
                    RemoteFsTranslog.this.logger.trace("uploaded translog for {} {} ", (Object)primaryTerm, (Object)generation);
                }

                @Override
                public void onUploadFailed(TransferSnapshot transferSnapshot, Exception ex) throws IOException {
                    transferReleasable.close();
                    RemoteFsTranslog.this.closeFilesIfNoPendingRetentionLocks();
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    throw (RuntimeException)ex;
                }
            });
            return bl;
        }
    }

    public Set<String> allUploaded() {
        return this.fileTransferTracker.allUploaded();
    }

    private boolean syncToDisk() throws IOException {
        ReleasableLock lock = this.readLock.acquire();
        try {
            boolean bl = this.current.sync();
            if (lock != null) {
                lock.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception ex) {
                this.closeOnTragicEvent(ex);
                throw ex;
            }
        }
    }

    @Override
    public void sync() throws IOException {
        try {
            if (this.syncToDisk() || this.syncNeeded()) {
                this.prepareAndUpload(this.primaryTermSupplier.getAsLong(), null);
            }
        }
        catch (Exception e) {
            this.tragedy.setTragicException(e);
            this.closeOnTragicEvent(e);
            throw e;
        }
    }

    @Override
    public boolean syncNeeded() {
        try (ReleasableLock lock = this.readLock.acquire();){
            boolean bl = this.current.syncNeeded() || this.maxRemoteTranslogGenerationUploaded + 1L < this.currentFileGeneration() && this.current.totalOperations() == 0;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        assert (Translog.calledFromOutsideOrViaTragedyClose()) : "Translog.close method is called from inside Translog, but not via closeOnTragicEvent method";
        if (this.closed.compareAndSet(false, true)) {
            try (ReleasableLock lock = this.writeLock.acquire();){
                this.sync();
            }
            finally {
                this.logger.debug("translog closed");
                this.closeFilesIfNoPendingRetentionLocks();
            }
        }
    }

    @Override
    protected long getMinReferencedGen() throws IOException {
        assert (this.readLock.isHeldByCurrentThread() || this.writeLock.isHeldByCurrentThread());
        long minReferencedGen = Math.min(this.deletionPolicy.minTranslogGenRequired(this.readers, this.current), RemoteFsTranslog.minGenerationForSeqNo(Math.min(this.deletionPolicy.getLocalCheckpointOfSafeCommit() + 1L, this.minSeqNoToKeep), this.current, this.readers));
        assert (minReferencedGen >= this.getMinFileGeneration()) : "deletion policy requires a minReferenceGen of [" + minReferencedGen + "] but the lowest gen available is [" + this.getMinFileGeneration() + "]";
        assert (minReferencedGen <= this.currentFileGeneration()) : "deletion policy requires a minReferenceGen of [" + minReferencedGen + "] which is higher than the current generation [" + this.currentFileGeneration() + "]";
        return minReferencedGen;
    }

    @Override
    protected void setMinSeqNoToKeep(long seqNo) {
        if (seqNo < this.minSeqNoToKeep) {
            throw new IllegalArgumentException("min seq number required can't go backwards: current [" + this.minSeqNoToKeep + "] new [" + seqNo + "]");
        }
        this.minSeqNoToKeep = seqNo;
    }

    @Override
    public void trimUnreferencedReaders() throws IOException {
        super.trimUnreferencedReaders();
        if (!this.remoteGenerationDeletionPermits.tryAcquire(2)) {
            return;
        }
        HashSet<Long> generationsToDelete = new HashSet<Long>();
        for (long generation = this.minRemoteGenReferenced - 1L; generation >= 0L && this.fileTransferTracker.uploaded(Translog.getFilename(generation)); --generation) {
            generationsToDelete.add(generation);
        }
        if (!generationsToDelete.isEmpty()) {
            this.deleteRemoteGeneration(generationsToDelete);
            this.deleteStaleRemotePrimaryTermsAndMetadataFiles();
        } else {
            this.remoteGenerationDeletionPermits.release(2);
        }
    }

    private void deleteRemoteGeneration(Set<Long> generations) {
        this.translogTransferManager.deleteGenerationAsync(this.primaryTermSupplier.getAsLong(), generations, this.remoteGenerationDeletionPermits::release);
    }

    private void deleteStaleRemotePrimaryTermsAndMetadataFiles() {
        if (this.olderPrimaryCleaned.trySet(Boolean.TRUE)) {
            assert (!this.readers.isEmpty()) : "Expected non-empty readers";
            long minimumReferencedPrimaryTerm = this.readers.stream().map(BaseTranslogReader::getPrimaryTerm).min(Long::compare).get();
            this.translogTransferManager.deletePrimaryTermsAsync(minimumReferencedPrimaryTerm);
            this.translogTransferManager.deleteStaleTranslogMetadataFilesAsync();
        }
    }
}

