/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog.transfer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.opensearch.common.SetOnce;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.io.stream.BytesStreamOutput;

public class TranslogTransferMetadata {
    private final long primaryTerm;
    private final long generation;
    private final long minTranslogGeneration;
    private int count;
    private final SetOnce<Map<String, String>> generationToPrimaryTermMapper = new SetOnce();
    public static final String METADATA_SEPARATOR = "__";
    private static final int BUFFER_SIZE = 4096;
    private static final int CURRENT_VERSION = 1;
    private static final String METADATA_CODEC = "md";
    public static final Comparator<String> METADATA_FILENAME_COMPARATOR = new MetadataFilenameComparator();

    public TranslogTransferMetadata(long primaryTerm, long generation, long minTranslogGeneration, int count) {
        this.primaryTerm = primaryTerm;
        this.generation = generation;
        this.minTranslogGeneration = minTranslogGeneration;
        this.count = count;
    }

    public TranslogTransferMetadata(IndexInput indexInput) throws IOException {
        CodecUtil.checksumEntireFile(indexInput);
        CodecUtil.checkHeader(indexInput, METADATA_CODEC, 1, 1);
        this.primaryTerm = indexInput.readLong();
        this.generation = indexInput.readLong();
        this.minTranslogGeneration = indexInput.readLong();
        this.generationToPrimaryTermMapper.set(indexInput.readMapOfStrings());
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public long getGeneration() {
        return this.generation;
    }

    public long getMinTranslogGeneration() {
        return this.minTranslogGeneration;
    }

    public int getCount() {
        return this.count;
    }

    public void setGenerationToPrimaryTermMapper(Map<String, String> generationToPrimaryTermMap) {
        this.generationToPrimaryTermMapper.set(generationToPrimaryTermMap);
    }

    public Map<String, String> getGenerationToPrimaryTermMapper() {
        return this.generationToPrimaryTermMapper.get();
    }

    public static String getFileName(long primaryTerm, long generation) {
        return String.join((CharSequence)METADATA_SEPARATOR, Arrays.asList(String.valueOf(primaryTerm), String.valueOf(generation)));
    }

    public byte[] createMetadataBytes() throws IOException {
        try (BytesStreamOutput output = new BytesStreamOutput();){
            try (OutputStreamIndexOutput indexOutput = new OutputStreamIndexOutput("translog transfer metadata " + this.primaryTerm, TranslogTransferMetadata.getFileName(this.primaryTerm, this.generation), output, 4096);){
                CodecUtil.writeHeader(indexOutput, METADATA_CODEC, 1);
                this.write(indexOutput);
                CodecUtil.writeFooter(indexOutput);
            }
            byte[] byArray = BytesReference.toBytes(output.bytes());
            return byArray;
        }
    }

    public int hashCode() {
        return Objects.hash(this.primaryTerm, this.generation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TranslogTransferMetadata other = (TranslogTransferMetadata)o;
        return Objects.equals(this.primaryTerm, other.primaryTerm) && Objects.equals(this.generation, other.generation);
    }

    private void write(DataOutput out) throws IOException {
        out.writeLong(this.primaryTerm);
        out.writeLong(this.generation);
        out.writeLong(this.minTranslogGeneration);
        if (this.generationToPrimaryTermMapper.get() != null) {
            out.writeMapOfStrings(this.generationToPrimaryTermMapper.get());
        } else {
            out.writeMapOfStrings(new HashMap<String, String>());
        }
    }

    private static class MetadataFilenameComparator
    implements Comparator<String> {
        private MetadataFilenameComparator() {
        }

        @Override
        public int compare(String first, String second) {
            String[] filenameTokens1 = first.split(TranslogTransferMetadata.METADATA_SEPARATOR);
            String[] filenameTokens2 = second.split(TranslogTransferMetadata.METADATA_SEPARATOR);
            for (int i = 0; i < filenameTokens1.length; ++i) {
                if (filenameTokens1[i].equals(filenameTokens2[i])) continue;
                return Long.compare(Long.parseLong(filenameTokens1[i]), Long.parseLong(filenameTokens2[i]));
            }
            throw new IllegalArgumentException("TranslogTransferMetadata files " + first + " and " + second + " have same primary term and generation");
        }
    }
}

